/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.editors.schedblock;

import alma.obsprep.bo.schedblock.AbstractBaseBandConfig;
import alma.obsprep.bo.schedblock.BLSpectralWindow;
import alma.obsprep.guiutil.ScrollWhenFocusedPane;
import alma.obsprep.guiutil.mvc.FieldID;
import alma.obsprep.guiutil.mvc.Model;
import alma.obsprep.ot.boEditors.EditorWithGridBagLayout;
import alma.obsprep.ot.gui.toplevel.InitServices;
import alma.obsprep.ot.models.schedblock.ChannelAverageRegionModel;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class ChannelAverageRegionEditor
extends EditorWithGridBagLayout
implements ListSelectionListener {
    public final FieldID CARADDBUTTON_FID = new FieldID("ChannelAverageRegion.addBtn");
    public final FieldID CARDELBUTTON_FID = new FieldID("ChannelAverageRegion.delBtn");
    public final FieldID CARTABLE_FID = new FieldID("ChannelAverageRegion.table");
    private JButton carAddButton;
    private JButton carDelButton;
    private JTable carTable;

    public ChannelAverageRegionEditor(Model model) {
        this.setModel(model);
        this.build();
        model.publish();
    }

    public ChannelAverageRegionModel getMyModel() {
        return (ChannelAverageRegionModel)this.getModel();
    }

    @Override
    protected void build() {
        super.build("SpectralWindow");
    }

    @Override
    protected void addComponents(String string) {
        JPanel jPanel = new JPanel();
        GridBagLayout gridBagLayout = this.createNewLayout(jPanel);
        GridBagConstraints gridBagConstraints = this.createNewConstraints();
        this.carAddButton = this.makeButton(this.CARADDBUTTON_FID, "Add", "Add a Channel Average Region");
        this.carDelButton = this.makeButton(this.CARDELBUTTON_FID, "Delete", "Delete a Channel Average Region");
        this.carTable = new JTable(this.getMyModel().getCARTableModel());
        this.carTable.getTableHeader().setReorderingAllowed(false);
        this.initEvents(this.carTable, this.CARTABLE_FID);
        this.carTable.setSelectionMode(0);
        this.carTable.setColumnSelectionAllowed(false);
        this.carTable.getSelectionModel().addListSelectionListener(this);
        this.carTable.setToolTipText("Up to 32 Channel Average Bands may be added");
        this.addLabel(jPanel, gridBagLayout, gridBagConstraints, "Spectral Average Region");
        Dimension dimension = new Dimension(300, 160);
        this.carTable.setPreferredScrollableViewportSize(dimension);
        ScrollWhenFocusedPane scrollWhenFocusedPane = new ScrollWhenFocusedPane(this.carTable);
        scrollWhenFocusedPane.setMinimumSize(dimension);
        this.addComponent(jPanel, gridBagLayout, gridBagConstraints, scrollWhenFocusedPane);
        JPanel jPanel2 = new JPanel();
        jPanel2.add(this.carAddButton);
        jPanel2.add(this.carDelButton);
        this.addComponent(jPanel, gridBagLayout, gridBagConstraints, jPanel2);
        this.constraints.weightx = 1.0;
        this.constraints.fill = 0;
        this.constraints.anchor = 17;
        this.addComponent(this, this.layout, this.constraints, jPanel);
    }

    @Override
    public void update(FieldID fieldID, Object object) {
        if (fieldID.equals(this.CARADDBUTTON_FID)) {
            int n = this.carTable.getSelectedRow();
            this.getMyModel().addChannelAverageRegion(n + 1);
            this.setButtons();
            return;
        }
        if (fieldID.equals(this.CARDELBUTTON_FID)) {
            int n = this.carTable.getSelectedRow();
            this.getMyModel().deleteChannelAverageRegion(n);
            if (n == 0) {
                if (this.getMyModel().getChannelAverageRegionCount() != 0) {
                    this.carTable.setRowSelectionInterval(n, n);
                }
            } else if (n == this.getMyModel().getChannelAverageRegionCount()) {
                this.carTable.setRowSelectionInterval(n - 1, n - 1);
            } else if (n != -1) {
                this.carTable.setRowSelectionInterval(n, n);
            }
            this.setButtons();
            return;
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        this.setButtons();
    }

    private void setButtons() {
        if (!this.isEnabled()) {
            return;
        }
        int n = this.getMyModel().getChannelAverageRegionCount();
        this.setEnabled(this.carAddButton, n < AbstractBaseBandConfig.maxChannelAverageRegionCount());
        this.setEnabled(this.carDelButton, n > 0 && this.carTable.getSelectedRow() != -1);
    }

    public static void main(String[] stringArray) {
        InitServices.initModelSupportClasses();
        ChannelAverageRegionModel channelAverageRegionModel = new ChannelAverageRegionModel(null);
        ChannelAverageRegionEditor channelAverageRegionEditor = new ChannelAverageRegionEditor(channelAverageRegionModel);
        BLSpectralWindow bLSpectralWindow = BLSpectralWindow.createBLSpectralWindow();
        channelAverageRegionModel.setDocument(bLSpectralWindow);
        ChannelAverageRegionEditor.runTestApp(channelAverageRegionEditor, 500, 500);
    }
}

