/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.editors.obsproject;

import alma.obsprep.bo.obsproject.QuerySource;
import alma.obsprep.bo.obsproject.QuerySourceAdapter;
import alma.obsprep.guiutil.ScrollWhenFocusedPane;
import alma.obsprep.guiutil.mvc.FieldID;
import alma.obsprep.guiutil.mvc.Model;
import alma.obsprep.guiutil.mvc.widgets.OTTextField;
import alma.obsprep.ot.boEditors.EditorWithGridBagLayout;
import alma.obsprep.ot.editors.obsproject.ObservatoryGoalTargetsEditor;
import alma.obsprep.ot.editors.obsproject.QuerySourceEditor;
import alma.obsprep.ot.gui.resources.Icons;
import alma.obsprep.ot.gui.toplevel.InitServices;
import alma.obsprep.services.experts.CalibratorExpert;
import alma.obsprep.services.experts.calibrators.CalibratorExpertController;
import alma.obsprep.services.experts.calibrators.CalibratorExpertEditor;
import alma.obsprep.services.experts.calibrators.CalibratorExpertModel;
import alma.obsprep.services.experts.calibrators.DeclinationComparator;
import alma.obsprep.services.experts.calibrators.MeasurementTableModel;
import alma.obsprep.services.experts.spectralline.gui.TableCellRendererFactory;
import alma.obsprep.util.UnitMapConfigurator;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.border.TitledBorder;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableRowSorter;

public class ObservatoryGoalTargetQuerySourceEditor
extends EditorWithGridBagLayout
implements TableModelListener {
    private final MeasurementTableModel tableModel = new MeasurementTableModel();
    private final QuerySourceEditor queryEditor;
    private JPanel buttonPanel;
    private JComboBox catalogue;
    private JLabel catalogueLabel;
    private JButton closeButton;
    private JLabel helpLabel;
    private JLabel infoLabel;
    private JPanel resultsPanel;
    private JScrollPane scrollPane;
    private JLabel spacer1;
    private JLabel spacer2;
    private JLabel spacer3;
    private JButton submitButton;
    private JTable table;
    private OTTextField maxSources;

    public ObservatoryGoalTargetQuerySourceEditor(Model model) {
        this.setModel(model);
        this.queryEditor = new QuerySourceEditor(model, QuerySourceEditor.ShowSourceNameEnum.ShowSourceNameFilter);
        this.registerSubView(this.queryEditor);
        this.buildResultsPanel();
        this.build();
        model.publish();
    }

    @Override
    protected void build() {
        super.build("CalibrationSetupParametersQuerySourceEditor");
        this.catalogue.setModel(new DefaultComboBoxModel<String>(CalibratorExpert.SourceCatalog.getNames()));
        this.initEvents(this.catalogue, QuerySourceEditor.catlocFID);
        this.makeTableSortable();
        this.tableModel.addTableModelListener(this);
    }

    @Override
    protected void addComponents(String string) {
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.queryEditor, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.resultsPanel.setBorder(new TitledBorder("Search Results"));
        this.add((Component)this.resultsPanel, gridBagConstraints);
    }

    @Override
    public Object widgetUpdated(FieldID fieldID, Object object) {
        if (QuerySourceEditor.filterFID.equals(fieldID)) {
            this.submitButton.setEnabled(false);
        }
        return super.widgetUpdated(fieldID, object);
    }

    @Override
    public void update(FieldID fieldID, Object object) {
        if (fieldID.equals(CalibratorExpertEditor.tableFID)) {
            if (object instanceof List) {
                int n;
                List list = (List)object;
                int n2 = n = list.size();
                try {
                    String string = this.maxSources.getText();
                    n2 = Integer.parseInt(string);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (n2 > 0 && n > n2) {
                    this.tableModel.setCalibrators(list.subList(0, n2));
                } else {
                    this.tableModel.setCalibrators(list);
                }
                if (this.infoLabel != null) {
                    this.infoLabel.setText("These results could be different at project execution time");
                    this.infoLabel.setIcon(Icons.warning);
                }
            }
            if (this.submitButton != null) {
                this.submitButton.setEnabled(true);
            }
        } else if (fieldID.equals(QuerySourceEditor.raFID)) {
            String string = (String)object;
            this.tableModel.setQueryRA(string);
        } else if (fieldID.equals(QuerySourceEditor.decFID)) {
            String string = (String)object;
            this.tableModel.setQueryDec(string);
        }
        super.update(fieldID, object);
    }

    public void setCloseButtonVisible(boolean bl) {
        this.closeButton.setVisible(bl);
    }

    @Override
    public void tableChanged(TableModelEvent tableModelEvent) {
    }

    private void resizeColumn(JTable jTable, TableColumn tableColumn, TableCellRenderer tableCellRenderer, int n) {
        Component component = tableCellRenderer.getTableCellRendererComponent(jTable, tableColumn.getHeaderValue(), false, false, 0, n);
        int n2 = component.getPreferredSize().width;
        for (int i = 0; i < jTable.getRowCount(); ++i) {
            TableCellRenderer tableCellRenderer2 = jTable.getCellRenderer(i, n);
            component = tableCellRenderer2.getTableCellRendererComponent(jTable, jTable.getValueAt(i, n), false, false, i, n);
            n2 = Math.max(n2, component.getPreferredSize().width);
        }
        tableColumn.setPreferredWidth(n2);
    }

    private void buildResultsPanel() {
        this.resultsPanel = new JPanel();
        this.helpLabel = new JLabel();
        this.infoLabel = new JLabel();
        this.scrollPane = new ScrollWhenFocusedPane();
        this.table = new JTable();
        this.table.getTableHeader().setReorderingAllowed(false);
        this.buttonPanel = new JPanel();
        this.spacer1 = new JLabel();
        this.spacer2 = new JLabel();
        this.spacer3 = new JLabel();
        this.closeButton = new JButton();
        this.catalogueLabel = new JLabel();
        this.catalogue = new JComboBox();
        this.submitButton = this.makeButton(QuerySourceEditor.filterFID, "Test Query", "Find Calibrators Matching the Given Constraints");
        this.resultsPanel.setLayout(new GridBagLayout());
        this.helpLabel.setFont(this.helpLabel.getFont().deriveFont(this.helpLabel.getFont().getStyle() & 0xFFFFFFFE));
        this.helpLabel.setText("<html><ul><li>Click <i>Test Query</i> to find the current set of source catalog measurements matching your constraints.</li></ul></html>");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(12, 12, 0, 11);
        this.resultsPanel.add((Component)this.helpLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(11, 12, 0, 11);
        this.resultsPanel.add((Component)this.infoLabel, gridBagConstraints);
        this.table.setModel(this.tableModel);
        this.table.setSelectionMode(0);
        TableColumn tableColumn = this.table.getColumnModel().getColumn(3);
        tableColumn.setCellRenderer(TableCellRendererFactory.getTableCellRenderer(TableCellRendererFactory.Units.SEPARATION));
        tableColumn = this.table.getColumnModel().getColumn(4);
        tableColumn.setCellRenderer(TableCellRendererFactory.getTableCellRenderer(TableCellRendererFactory.Units.FREQUENCY));
        tableColumn = this.table.getColumnModel().getColumn(5);
        tableColumn.setCellRenderer(TableCellRendererFactory.getTableCellRenderer(TableCellRendererFactory.Units.FLUX_DENSITY));
        tableColumn = this.table.getColumnModel().getColumn(6);
        tableColumn.setCellRenderer(TableCellRendererFactory.getTableCellRenderer(TableCellRendererFactory.Units.DATE));
        this.scrollPane.setViewportView(this.table);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipady = 6;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 12, 0, 11);
        this.resultsPanel.add((Component)this.scrollPane, gridBagConstraints);
        this.catalogueLabel.setText("using");
        this.closeButton.setText("Close");
        GroupLayout groupLayout = new GroupLayout(this.buttonPanel);
        this.buttonPanel.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addComponent(this.spacer1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.spacer2, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.submitButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.catalogueLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.catalogue, -2, -1, -2).addGap(18, 18, 18).addComponent(this.spacer3, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.closeButton)));
        groupLayout.linkSize(0, this.closeButton, this.spacer1);
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.spacer1).addComponent(this.spacer2).addComponent(this.catalogueLabel).addComponent(this.catalogue, -2, -1, -2).addComponent(this.submitButton).addComponent(this.spacer3).addComponent(this.closeButton)));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(11, 12, 11, 11);
        this.resultsPanel.add((Component)this.buttonPanel, gridBagConstraints);
        this.buttonPanel.setName("ObservatoryGoalQuerySourceEditor.buttonPanel");
        this.catalogue.setName("ObservatoryGoalQuerySourceEditor.catalogue");
        this.catalogueLabel.setName("ObservatoryGoalQuerySourceEditor.catalogueLabel");
        this.closeButton.setName("ObservatoryGoalQuerySourceEditor.closeButton");
        this.helpLabel.setName("ObservatoryGoalQuerySourceEditor.helpLabel");
        this.infoLabel.setName("ObservatoryGoalQuerySourceEditor.infoLabel");
        this.queryEditor.setName("ObservatoryGoalQuerySourceEditor.queryEditor");
        this.resultsPanel.setName("ObservatoryGoalQuerySourceEditor.resultsPanel");
        this.scrollPane.setName("ObservatoryGoalQuerySourceEditor.scrollPane");
        this.spacer1.setName("ObservatoryGoalQuerySourceEditor.spacer1");
        this.spacer2.setName("ObservatoryGoalQuerySourceEditor.spacer2");
        this.spacer3.setName("ObservatoryGoalQuerySourceEditor.spacer3");
        this.submitButton.setName("ObservatoryGoalQuerySourceEditor.submitButton");
        this.table.setName("ObservatoryGoalQuerySourceEditor.table");
        if (this.maxSources != null) {
            this.maxSources.setName("ObservatoryGoalQuerySourceEditor.maxSources");
        }
    }

    private void makeTableSortable() {
        TableRowSorter<MeasurementTableModel> tableRowSorter = new TableRowSorter<MeasurementTableModel>(this.tableModel);
        tableRowSorter.setComparator(2, new DeclinationComparator());
        this.table.setRowSorter(tableRowSorter);
    }

    public static void main(String[] stringArray) {
        InitServices.initModelSupportClasses();
        UnitMapConfigurator.configureUnitMaps();
        CalibratorExpertModel calibratorExpertModel = new CalibratorExpertModel(null);
        calibratorExpertModel.subscribe(new CalibratorExpertController());
        QuerySource querySource = QuerySource.createQuerySource(QuerySource.INTENDEDUSE_AMPLITUDE);
        querySource.setMaxSources(100);
        QuerySourceAdapter querySourceAdapter = new QuerySourceAdapter(querySource);
        EventQueue.invokeLater(() -> {
            try {
                UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException | UnsupportedLookAndFeelException exception) {
                Logger.getLogger(ObservatoryGoalTargetsEditor.class.getName()).log(Level.SEVERE, null, exception);
            }
            ObservatoryGoalTargetQuerySourceEditor observatoryGoalTargetQuerySourceEditor = new ObservatoryGoalTargetQuerySourceEditor(calibratorExpertModel);
            calibratorExpertModel.setDocument(querySourceAdapter);
            JFrame jFrame = new JFrame("CalibrationSetupParametersQueryEditor");
            jFrame.setDefaultCloseOperation(3);
            jFrame.getContentPane().add(observatoryGoalTargetQuerySourceEditor);
            jFrame.pack();
            jFrame.setVisible(true);
        });
    }

    public JButton getCloseButton() {
        return this.closeButton;
    }

    public JButton getSubmitButton() {
        return this.submitButton;
    }
}

