/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.editors.obsproject;

import alma.obsprep.bo.obsproject.DataProcessingParameters;
import alma.obsprep.bo.obsproject.ObsUnitSet;
import alma.obsprep.guiutil.mvc.Model;
import alma.obsprep.ot.boEditors.EditorWithGridBagLayout;
import alma.obsprep.ot.boEditors.FieldIDs;
import alma.obsprep.ot.editors.obsproject.ObsUnitEditor;
import alma.obsprep.ot.gui.toplevel.InitServices;
import alma.obsprep.ot.models.obsproject.ObsUnitSetModel;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.help.CSH;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class ObsUnitSetEditor
extends ObsUnitEditor {
    public ObsUnitSetEditor(Model model) {
        this.setModel(model);
        this.build();
        model.publish();
    }

    protected ObsUnitSetEditor() {
    }

    @Override
    public ObsUnitSetModel getModel() {
        return (ObsUnitSetModel)super.getModel();
    }

    @Override
    protected void addComponents(String string) {
        JComponent jComponent = this.addBasicsGroup(string);
        CSH.setHelpIDString((Component)jComponent, (String)"TOC-Phase 2 Program Scheduling Blocks-Observing Unit Set-Basics");
        JPanel jPanel = this.addControlGroup();
        CSH.setHelpIDString((Component)jPanel, (String)"TOC-Phase 2 Program Scheduling Blocks-Observing Unit Set-Control");
        this.addUnitDependenciesGroup(string);
        this.addObsUnitSetComponent(string);
        this.addDataProcessingComponent();
    }

    protected JPanel addObsUnitSetComponent(String string) {
        JPanel jPanel = this.createNewGroup();
        GridBagLayout gridBagLayout = this.createNewLayout(jPanel);
        GridBagConstraints gridBagConstraints = this.createNewConstraints();
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        this.addTextComponent(jPanel, gridBagLayout, gridBagConstraints, FieldIDs.scienceProcessingScriptFID, "Data Processing Script", "The science data processing script");
        this.addBooleanComponent(jPanel, gridBagLayout, gridBagConstraints, FieldIDs.runSciencePipelineFID, "Run the Science Pipeline", "If checked the science pipeline will be initiated when all containing units are complete");
        return this.addGroup(jPanel, "Pipeline Information", false);
    }

    protected JPanel addDataProcessingComponent() {
        JPanel jPanel = this.createNewGroup();
        GridBagLayout gridBagLayout = this.createNewLayout(jPanel);
        GridBagConstraints gridBagConstraints = this.createNewConstraints();
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        this.addValueUnitPair((JComponent)jPanel, gridBagLayout, gridBagConstraints, this.getModel().getAngularResolutionModel(), "Angular Resolution", "Desired angular resolution");
        this.addVelocity(jPanel, gridBagLayout, gridBagConstraints, this.getModel().getVelocityResolutionModel(), "Velocity Resolution", "Desired velocity resolution");
        this.addValueUnitPair((JComponent)jPanel, gridBagLayout, gridBagConstraints, this.getModel().getTBSensitivityModel(), "TB Sensitivity", "Desired brightness temperature sensitivity limit");
        this.addValueUnitPair((JComponent)jPanel, gridBagLayout, gridBagConstraints, this.getModel().getRMSGoalModel(), "RMS Goal", "Desired rms noise");
        this.addComboBox((JComponent)jPanel, gridBagLayout, gridBagConstraints, FieldIDs.projectTypeFID, "Project Type", "Project type description", DataProcessingParameters.getKnownProjectTypeList());
        return this.addGroup(jPanel, "Data Processing Parameters ( Not currently used )", true);
    }

    @Override
    protected void build() {
        super.build("ObsUnitSet");
    }

    public static void main(String[] stringArray) {
        InitServices.initModelSupportClasses();
        ObsUnitSetModel obsUnitSetModel = new ObsUnitSetModel(null);
        ObsUnitSetEditor obsUnitSetEditor = new ObsUnitSetEditor(obsUnitSetModel);
        ObsUnitSet obsUnitSet = ObsUnitSet.createObsUnitSet();
        obsUnitSetModel.setDocument(obsUnitSet);
        EditorWithGridBagLayout.runTestApp(obsUnitSetEditor);
    }
}

