/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.editors.obsproject;

import alma.obsprep.bo.obsproject.CalibrationTargetProperties;
import alma.valuetypes.Frequency;
import alma.valuetypes.Sensitivity;
import java.util.ArrayList;
import java.util.List;
import javax.swing.table.AbstractTableModel;

public class GoalTargetPropertiesTableModel
extends AbstractTableModel {
    List<CalibrationTargetProperties> properties = new ArrayList<CalibrationTargetProperties>();

    @Override
    public int getColumnCount() {
        return ColumnDescriptor.getColumnCount();
    }

    @Override
    public String getColumnName(int n) {
        return this.getColumnDescriptor(n).getColumnName();
    }

    @Override
    public int getRowCount() {
        return this.properties.size();
    }

    public CalibrationTargetProperties getCalibrationTargetPropertiesAt(int n) {
        return this.properties.get(n);
    }

    @Override
    public Object getValueAt(int n, int n2) {
        CalibrationTargetProperties calibrationTargetProperties = this.getCalibrationTargetPropertiesAt(n);
        switch (this.getColumnDescriptor(n2).ordinal()) {
            case 0: {
                return calibrationTargetProperties.getFrequency();
            }
            case 1: {
                return calibrationTargetProperties.getFlux();
            }
        }
        throw new IllegalArgumentException("Invalid column: " + n2);
    }

    @Override
    public Class<?> getColumnClass(int n) {
        return this.getColumnDescriptor(n).getColumnClass();
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        return true;
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        CalibrationTargetProperties calibrationTargetProperties = this.getCalibrationTargetPropertiesAt(n);
        switch (this.getColumnDescriptor(n2).ordinal()) {
            case 0: {
                Frequency frequency = (Frequency)((Object)object);
                calibrationTargetProperties.getFrequency().setContent(frequency.getContent());
                calibrationTargetProperties.getFrequency().setUnit(frequency.getUnit());
                break;
            }
            case 1: {
                Sensitivity sensitivity = (Sensitivity)((Object)object);
                calibrationTargetProperties.getFlux().setContent(sensitivity.getContent());
                calibrationTargetProperties.getFlux().setUnit(sensitivity.getUnit());
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected column: " + n2);
            }
        }
        this.fireTableCellUpdated(n, n2);
    }

    public void clearAll() {
        this.properties.clear();
    }

    public void addCalibrationTargetProperties(CalibrationTargetProperties calibrationTargetProperties) {
        if (calibrationTargetProperties != null) {
            this.properties.add(calibrationTargetProperties);
        }
        this.fireTableDataChanged();
    }

    public void setCalibrationTargetProperties(CalibrationTargetProperties[] calibrationTargetPropertiesArray) {
        this.clearAll();
        for (CalibrationTargetProperties calibrationTargetProperties : calibrationTargetPropertiesArray) {
            this.properties.add(calibrationTargetProperties);
        }
        this.fireTableDataChanged();
    }

    public void removeCalibrationTargetProperties(CalibrationTargetProperties calibrationTargetProperties) {
        this.properties.remove((Object)calibrationTargetProperties);
        this.fireTableDataChanged();
    }

    private ColumnDescriptor getColumnDescriptor(int n) {
        return ColumnDescriptor.getColumnDescriptor(n);
    }

    public static enum ColumnDescriptor {
        FREQUENCY("Frequency", Frequency.class),
        FLUX("Flux", Sensitivity.class);

        private final String columnName;
        private final Class<?> columnClass;

        protected static int getColumnCount() {
            return ColumnDescriptor.values().length;
        }

        protected static ColumnDescriptor getColumnDescriptor(int n) {
            return ColumnDescriptor.values()[n];
        }

        private ColumnDescriptor(String string2, Class<?> clazz) {
            this.columnName = string2;
            this.columnClass = clazz;
        }

        public String getColumnName() {
            return this.columnName;
        }

        public Class<?> getColumnClass() {
            return this.columnClass;
        }
    }
}

