/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.editors.obsproject;

import alma.obsprep.bo.obsproject.Ellipse;
import alma.obsprep.guiutil.mvc.FieldID;
import alma.obsprep.guiutil.mvc.Model;
import alma.obsprep.ot.boEditors.EditorWithGridBagLayout;
import alma.obsprep.ot.boEditors.FieldIDs;
import alma.obsprep.ot.boEditors.NonNegativeVerifier;
import alma.obsprep.ot.editors.valuetypes.SkyCoordsEditor;
import alma.obsprep.ot.editors.valuetypes.ValueUnitPairEditor;
import alma.obsprep.ot.gui.toplevel.InitServices;
import alma.obsprep.ot.models.obsproject.EllipseModel;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class EllipseEditor
extends EditorWithGridBagLayout {
    private SkyCoordsEditor centreEditor = null;
    private ValueUnitPairEditor semiMajorEditor = null;
    private ValueUnitPairEditor semiMinorEditor = null;
    private ValueUnitPairEditor paMajorEditor = null;
    private ValueUnitPairEditor spacingEditor = null;

    public EllipseEditor(Model model) {
        this.setModel(model);
        this.build();
        model.publish();
    }

    private EllipseModel getMyModel() {
        return (EllipseModel)this.getModel();
    }

    @Override
    protected void build() {
        super.build("Ellipse");
    }

    @Override
    protected void addComponents(String string) {
        JPanel jPanel = null;
        jPanel = this.createNewGroup();
        GridBagLayout gridBagLayout = this.createNewLayout(jPanel);
        GridBagConstraints gridBagConstraints = this.createNewConstraints();
        this.addTextComponent(jPanel, gridBagLayout, gridBagConstraints, FieldIDs.nameFID, string + " Name", "The name of this " + string);
        this.addNonCollapsingGroup(jPanel, "");
        jPanel = this.createNewGroup();
        gridBagLayout = this.createNewLayout(jPanel);
        gridBagConstraints = this.createNewConstraints();
        this.centreEditor = this.addSkyCoordinates(jPanel, gridBagLayout, gridBagConstraints, this.getMyModel().getCentreModel(), "Centre", "The centre of this ellipse");
        this.semiMajorEditor = this.addValueUnitPair((JComponent)jPanel, gridBagLayout, gridBagConstraints, this.getMyModel().getSemiMajorModel(), "Semi Major", "The semi major axis of the ellipse");
        this.semiMajorEditor.setVerifier("FOCUSLOST_VERIFIER", new NonNegativeVerifier(this.semiMajorEditor));
        this.semiMinorEditor = this.addValueUnitPair((JComponent)jPanel, gridBagLayout, gridBagConstraints, this.getMyModel().getSemiMinorModel(), "Semi Minor", "The semi minor axis the ellipse");
        this.semiMinorEditor.setVerifier("FOCUSLOST_VERIFIER", new NonNegativeVerifier(this.semiMinorEditor));
        this.paMajorEditor = this.addValueUnitPair((JComponent)jPanel, gridBagLayout, gridBagConstraints, this.getMyModel().getPAMajorModel(), "Pitch", "The pitch angle of the ellipse");
        this.paMajorEditor.setVerifier("FOCUSLOST_VERIFIER", new NonNegativeVerifier(this.paMajorEditor));
        this.spacingEditor = this.addValueUnitPair((JComponent)jPanel, gridBagLayout, gridBagConstraints, this.getMyModel().getSpacingModel(), "Spacing", "The spacing between beams");
        this.spacingEditor.setVerifier("FOCUSLOST_VERIFIER", new NonNegativeVerifier(this.spacingEditor));
        this.addGroup(jPanel, string);
    }

    @Override
    public void update(FieldID fieldID, Object object) {
        if (fieldID == FieldIDs.nameFID) {
            super.update(fieldID, object);
        } else if (fieldID == this.getMyModel().semiMajorUnitFID || fieldID == this.getMyModel().semiMajorValueFID) {
            this.semiMajorEditor.update(fieldID, object);
        } else if (fieldID == this.getMyModel().semiMinorUnitFID || fieldID == this.getMyModel().semiMinorValueFID) {
            this.semiMinorEditor.update(fieldID, object);
        } else if (fieldID == this.getMyModel().paMajorUnitFID || fieldID == this.getMyModel().paMajorValueFID) {
            this.paMajorEditor.update(fieldID, object);
        } else if (fieldID == this.getMyModel().spacingUnitFID || fieldID == this.getMyModel().spacingValueFID) {
            this.spacingEditor.update(fieldID, object);
        }
    }

    public static void main(String[] stringArray) {
        InitServices.initModelSupportClasses();
        EllipseModel ellipseModel = new EllipseModel(null);
        EllipseEditor ellipseEditor = new EllipseEditor(ellipseModel);
        Ellipse ellipse = Ellipse.createEllipse();
        ellipseModel.setDocument((Object)ellipse);
        EditorWithGridBagLayout.runTestApp(ellipseEditor);
    }
}

