/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.editors.obsproject;

import alma.hla.runtime.obsprep.bo.BusinessObject;
import alma.hla.runtime.obsprep.bo.IBusinessObject;
import alma.hla.runtime.obsprep.util.Log;
import alma.obsprep.bo.annotations.ObsUnitSetComponent;
import alma.obsprep.bo.obsproject.ObsUnit;
import alma.obsprep.bo.obsproject.ObsUnitSet;
import alma.obsprep.bo.schedblock.SchedBlock;
import alma.obsprep.ot.editors.obsproject.BusinessObjectListItem;
import alma.obsprep.ot.editors.obsproject.DependencyDialog;
import alma.obsprep.ot.models.obsproject.ObsUnitModel;
import alma.obsprep.services.experts.SchedBlockExpert;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class DependencyEditor
extends JPanel
implements PropertyChangeListener,
ActionListener {
    protected static final String OK_STRING = "OK";
    protected static final String CANCEL_STRING = "Cancel";
    private ObsUnitModel obsUnitModel = null;
    private final JButton showButton = new JButton("View / Edit");
    private DependencyDialog dependencyDialog = null;

    public DependencyEditor() {
        JLabel jLabel = new JLabel("Dependency List");
        this.setToolTipText("List of units which this unit depends on.");
        jLabel.setToolTipText("List of units which this unit depends on.");
        this.showButton.setToolTipText("List of units which this unit depends on.");
        this.showButton.addActionListener(this);
        this.add(jLabel);
        this.add(this.showButton);
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getNewValue() != null && propertyChangeEvent.getNewValue().equals(OK_STRING)) {
            this.updateUnitDependencies();
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Serializable serializable;
        if (this.dependencyDialog == null) {
            serializable = SwingUtilities.getRoot(this);
            JFrame jFrame = null;
            if (serializable instanceof JFrame) {
                jFrame = (JFrame)serializable;
            }
            this.dependencyDialog = new DependencyDialog(jFrame, this);
        }
        this.fillGUI();
        serializable = new Point(0, 0);
        SwingUtilities.convertPointToScreen((Point)serializable, this);
        this.dependencyDialog.setLocation((Point)serializable);
        this.dependencyDialog.pack();
        this.dependencyDialog.setVisible(true);
    }

    public void setObsUnitModel(ObsUnitModel obsUnitModel) {
        this.obsUnitModel = obsUnitModel;
    }

    private void fillGUI() {
        ObsUnit obsUnit = (ObsUnit)this.obsUnitModel.getDocument();
        String[] stringArray = obsUnit.getUnitDependencies().getDependencyList();
        Vector<String> vector = null;
        if (stringArray != null && stringArray.length > 0) {
            vector = new Vector<String>(Arrays.asList(stringArray));
        }
        Vector<BusinessObjectListItem> vector2 = this.dependencyDialog.getIncludedObsUnits();
        vector2.clear();
        Vector<BusinessObjectListItem> vector3 = this.dependencyDialog.getExcludedObsUnits();
        vector3.clear();
        List<SchedBlock> list = null;
        try {
            list = SchedBlockExpert.getAllSBsInObsProgram();
        }
        catch (SchedBlock.UnableToFindParentScienceGoalException unableToFindParentScienceGoalException) {
            Log.logger(DependencyEditor.class).info("Unable to determine SBs in the OUS : " + unableToFindParentScienceGoalException.getMessage());
            return;
        }
        for (IBusinessObject iBusinessObject : list) {
            if (iBusinessObject != obsUnit) {
                if (iBusinessObject instanceof SchedBlock) {
                    if (vector != null && ((SchedBlock)iBusinessObject).getEntityID() != null && vector.contains(((SchedBlock)iBusinessObject).getEntityID())) {
                        vector2.add(new BusinessObjectListItem((BusinessObject)iBusinessObject));
                    } else {
                        vector3.add(new BusinessObjectListItem((BusinessObject)iBusinessObject));
                    }
                }
                if (!(iBusinessObject instanceof ObsUnitSet)) continue;
                ObsUnitSet obsUnitSet = (ObsUnitSet)iBusinessObject;
                if (vector != null && obsUnitSet.getEntityPartId() != null && vector.contains(((ObsUnitSet)iBusinessObject).getEntityPartId())) {
                    vector2.add(new BusinessObjectListItem((BusinessObject)iBusinessObject));
                    continue;
                }
                vector3.add(new BusinessObjectListItem((BusinessObject)iBusinessObject));
                continue;
            }
            this.dependencyDialog.setTitle("Unit Dependency List (" + String.valueOf(new BusinessObjectListItem((BusinessObject)iBusinessObject)) + ")");
        }
        this.dependencyDialog.resetLists();
    }

    private void updateUnitDependencies() {
        Vector<BusinessObjectListItem> vector = this.dependencyDialog.getIncludedObsUnits();
        ObsUnit obsUnit = (ObsUnit)this.obsUnitModel.getDocument();
        obsUnit.getUnitDependencies().clearDependencyList();
        BusinessObject businessObject = null;
        for (BusinessObjectListItem businessObjectListItem : vector) {
            ObsUnitSetComponent obsUnitSetComponent;
            businessObject = businessObjectListItem.getBusinessObject();
            if (businessObject instanceof SchedBlock) {
                obsUnitSetComponent = (SchedBlock)businessObject;
                obsUnit.getUnitDependencies().addDependencyList(obsUnitSetComponent.getEntityID());
            }
            if (!(businessObject instanceof ObsUnitSet)) continue;
            obsUnitSetComponent = (ObsUnitSet)businessObject;
            obsUnit.getUnitDependencies().addDependencyList(obsUnitSetComponent.getEntityPartId());
        }
    }
}

