/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.editors.obsproject;

import alma.obsprep.bo.obsproject.CalibrationTargetParameters;
import alma.obsprep.bo.obsproject.IQuerySource;
import alma.obsprep.bo.obsproject.QuerySource;
import alma.valuetypes.Angle;
import alma.valuetypes.SkyCoordinates;
import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.Map;

public class CalibratorTableElement {
    public static final Map<Integer, String> CALIBRATOR_TYPES = new HashMap<Integer, String>();
    private final String intent;
    private final String type;
    private final String sourceName;
    private String ra;
    private String dec;
    private String radius;
    private final IQuerySource querySource;
    private final CalibrationTargetParameters calibrationTargetParameters;

    public CalibratorTableElement(IQuerySource iQuerySource) {
        if (iQuerySource == null) {
            throw new IllegalArgumentException("Cannot instantiate table element from null");
        }
        this.querySource = iQuerySource;
        this.calibrationTargetParameters = null;
        this.intent = iQuerySource.getIntendedUse();
        this.type = "Query";
        this.sourceName = "";
        SkyCoordinates skyCoordinates = iQuerySource.getQueryCenter().getICRSSkyCoordinates();
        try {
            this.ra = skyCoordinates.getLongitude().toHHMMSS();
        }
        catch (Exception exception) {
            this.ra = "-";
        }
        try {
            this.dec = skyCoordinates.getLatitude().toDDMMSS();
        }
        catch (Exception exception) {
            this.dec = "-";
        }
        double d = iQuerySource.getSearchRadius().getContentInUnits(Angle.UNIT_DEG);
        DecimalFormat decimalFormat = new DecimalFormat("0.0");
        this.setRadius(decimalFormat.format(d));
    }

    public CalibratorTableElement(CalibrationTargetParameters calibrationTargetParameters) {
        if (calibrationTargetParameters == null) {
            throw new IllegalArgumentException("Cannot instantiate table element from null");
        }
        this.calibrationTargetParameters = calibrationTargetParameters;
        this.querySource = null;
        this.intent = calibrationTargetParameters.getIntendedUse();
        this.type = "Fixed";
        if (calibrationTargetParameters.getNonSiderealMotion()) {
            this.sourceName = calibrationTargetParameters.getSolarSystemObject();
            this.ra = "-";
            this.dec = "-";
        } else {
            this.sourceName = calibrationTargetParameters.getSourceName();
            SkyCoordinates skyCoordinates = calibrationTargetParameters.getSourceCoordinates().getICRSSkyCoordinates();
            try {
                this.ra = skyCoordinates.getLongitude().toHHMMSS();
            }
            catch (Exception exception) {
                this.ra = "-";
            }
            try {
                this.dec = skyCoordinates.getLatitude().toDDMMSS();
            }
            catch (Exception exception) {
                this.dec = "-";
            }
        }
        this.setRadius("-");
    }

    public String getRA() {
        return this.ra;
    }

    public String getIntent() {
        return this.intent;
    }

    public String getType() {
        return this.type;
    }

    public String getSourceName() {
        return this.sourceName;
    }

    public String getDec() {
        return this.dec;
    }

    public String getRadius() {
        return this.radius;
    }

    public void setRadius(String string) {
        this.radius = string;
    }

    public IQuerySource getQuerySource() {
        return this.querySource;
    }

    public CalibrationTargetParameters getCalibrationTargetParameters() {
        return this.calibrationTargetParameters;
    }

    static {
        int n = 0;
        for (String string : QuerySource.getKnownIntendedUseList()) {
            CALIBRATOR_TYPES.put(n++, string);
        }
    }
}

