/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.editors.misc;

import alma.obsprep.bo.obsproject.TemporalParameters;
import alma.obsprep.ot.editors.misc.TimingConstraintsTableLoader;
import alma.obsprep.ot.models.misc.SummaryTableColumns;
import alma.obsprep.ot.models.misc.SummaryTableRow;

public class TemporalParametersSummaryTableColumns
implements SummaryTableColumns {
    public static Object[] longValues = new Object[]{"2014-10-01T09:30:55", "2014-10-02T09:30:55"};
    protected TemporalParameters timingConstraints;

    public TemporalParametersSummaryTableColumns(TemporalParameters temporalParameters) {
        this.timingConstraints = temporalParameters;
    }

    @Override
    public SummaryTableRow getSummaryTableRow() {
        return this.timingConstraints;
    }

    @Override
    public Class<?> getSummaryColumnClass(int n) {
        TimingConstraintsTableLoader.ColumnIndexEnumeration columnIndexEnumeration = TimingConstraintsTableLoader.ColumnIndexEnumeration.findColumnIndex(n);
        switch (columnIndexEnumeration) {
            case COL_STARTDATE: {
                return String.class;
            }
            case COL_ENDDATE: {
                return String.class;
            }
        }
        throw new IllegalArgumentException("Unable to process column index: " + n);
    }

    @Override
    public int getSummaryColumnCount() {
        return TimingConstraintsTableLoader.ColumnIndexEnumeration.values().length;
    }

    @Override
    public String getSummaryColumnName(int n) {
        TimingConstraintsTableLoader.ColumnIndexEnumeration columnIndexEnumeration = TimingConstraintsTableLoader.ColumnIndexEnumeration.findColumnIndex(n);
        switch (columnIndexEnumeration) {
            case COL_STARTDATE: {
                return "Start date";
            }
            case COL_ENDDATE: {
                return "End date";
            }
        }
        throw new IllegalArgumentException("Unable to process column index: " + n);
    }

    @Override
    public Object getSummaryValueAt(int n) {
        TimingConstraintsTableLoader.ColumnIndexEnumeration columnIndexEnumeration = TimingConstraintsTableLoader.ColumnIndexEnumeration.findColumnIndex(n);
        switch (columnIndexEnumeration) {
            case COL_STARTDATE: {
                return this.timingConstraints.getStartTime();
            }
            case COL_ENDDATE: {
                return this.timingConstraints.getEndTime();
            }
        }
        throw new IllegalArgumentException("Unable to process column index: " + n);
    }

    @Override
    public boolean isSummaryCellEditable(int n) {
        TimingConstraintsTableLoader.ColumnIndexEnumeration columnIndexEnumeration = TimingConstraintsTableLoader.ColumnIndexEnumeration.findColumnIndex(n);
        switch (columnIndexEnumeration) {
            case COL_STARTDATE: {
                return true;
            }
            case COL_ENDDATE: {
                return true;
            }
        }
        throw new IllegalArgumentException("Unable to process column index: " + n);
    }

    @Override
    public boolean isSummaryCellEnable(int n) {
        return true;
    }

    @Override
    public void setSummaryValueAt(Object object, int n) {
    }

    @Override
    public Object[] getSummaryColumnKnownItemList(int n) {
        return null;
    }

    @Override
    public Object[] getLongValues() {
        return longValues;
    }

    @Override
    public String getHeaderText() {
        return this.getLineText(true);
    }

    @Override
    public String getLineText() {
        return this.getLineText(false);
    }

    protected String getLineText(boolean bl) {
        int n;
        StringBuilder stringBuilder = new StringBuilder();
        for (n = 0; n < this.getSummaryColumnCount(); ++n) {
            String string = bl ? this.getSummaryColumnName(n) : this.getValueString(n);
            stringBuilder.append(string);
            stringBuilder.append(",").append(" ");
        }
        n = stringBuilder.lastIndexOf(",");
        if (n >= 0) {
            stringBuilder.delete(n, stringBuilder.length());
        }
        return stringBuilder.toString();
    }

    protected String getValueString(int n) {
        Object object = this.getSummaryValueAt(n);
        String string = object == null ? "" : object.toString();
        return string;
    }
}

