/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.editors.misc;

import alma.hla.runtime.obsprep.bo.ValueUnitPair;
import alma.obsprep.bo.obsproject.TargetParameters;
import alma.obsprep.ot.editors.misc.FieldTypeLabelConverter;
import alma.obsprep.ot.models.misc.SummaryTableColumns;
import alma.obsprep.ot.models.misc.SummaryTableRow;
import alma.valuetypes.Flux;
import alma.valuetypes.Frequency;
import alma.valuetypes.Latitude;
import alma.valuetypes.Longitude;
import alma.valuetypes.UserFrequency;

public class TargetParametersSummaryTableColumns
implements SummaryTableColumns {
    protected static final int COL_SOURCENAME = 0;
    protected static final int COL_FIELDTYPE = 1;
    protected static final int COL_NUMPOINTS = 2;
    protected static final int COL_RA = 3;
    protected static final int COL_DEC = 4;
    protected static final int COL_REDSHIFT = 5;
    protected static final int COL_FLUXDENSITY = 6;
    protected static final int COL_LINEFLUXDENSITY = 7;
    protected static final int COL_LINEWIDTH = 8;
    protected static final int COL_CONTPOLARISATION = 9;
    protected static final int COL_LINEPOLARISATION = 10;
    protected static final int COL_CIRCULAR_CONTPOLARISATION = 11;
    protected static final int COL_CIRCULAR_LINEPOLARISATION = 12;
    protected static final int NUM_COLUMNS = 13;
    public static Object[] longValues = new Object[]{"J095942+022936.0", "Point", "1", "09:59:42.680", "02:29:36.000", "0.012", "5.0 mJy", "0.1 Jy", "4.031E-5 GHz", "12.3", "25.0", "3.0", "3.0"};
    protected TargetParameters targetParameters;

    public TargetParametersSummaryTableColumns(TargetParameters targetParameters) {
        this.targetParameters = targetParameters;
    }

    @Override
    public SummaryTableRow getSummaryTableRow() {
        return this.targetParameters;
    }

    @Override
    public Class<?> getSummaryColumnClass(int n) {
        switch (n) {
            case 0: {
                return String.class;
            }
            case 1: {
                return String.class;
            }
            case 2: {
                return Integer.class;
            }
            case 3: {
                return Longitude.class;
            }
            case 4: {
                return Latitude.class;
            }
            case 5: {
                return String.class;
            }
            case 6: {
                return String.class;
            }
            case 7: {
                return String.class;
            }
            case 8: {
                return String.class;
            }
            case 9: {
                return String.class;
            }
            case 10: {
                return String.class;
            }
            case 11: {
                return String.class;
            }
            case 12: {
                return String.class;
            }
        }
        throw new RuntimeException(String.format("Invalid column number (%d)", n));
    }

    @Override
    public int getSummaryColumnCount() {
        return 13;
    }

    @Override
    public String getSummaryColumnName(int n) {
        switch (n) {
            case 0: {
                return "Source Name";
            }
            case 1: {
                return "Field Type";
            }
            case 2: {
                return "No. Ptgs";
            }
            case 3: {
                return "RA";
            }
            case 4: {
                return "Dec";
            }
            case 5: {
                return "z";
            }
            case 6: {
                return "Cont. Flux";
            }
            case 7: {
                return "Peak Line Flux";
            }
            case 8: {
                return "Line Width";
            }
            case 9: {
                return "Cont. Pol.(%)";
            }
            case 10: {
                return "Line Pol.(%)";
            }
            case 11: {
                return "Circular Cont Pol.(%)";
            }
            case 12: {
                return "Circular Line Pol.(%)";
            }
        }
        throw new RuntimeException(String.format("Invalid column number (%d)", n));
    }

    @Override
    public Object getSummaryValueAt(int n) {
        switch (n) {
            case 0: {
                return this.targetParameters.getSourceName();
            }
            case 1: {
                return FieldTypeLabelConverter.convert(this.targetParameters.getType());
            }
            case 2: {
                return this.targetParameters.getNumberOfPointings();
            }
            case 3: {
                return this.targetParameters.getSourceCoordinates().getICRSSkyCoordinates().getLongitude();
            }
            case 4: {
                return this.targetParameters.getSourceCoordinates().getICRSSkyCoordinates().getLatitude();
            }
            case 5: {
                double d = this.targetParameters.getSourceVelocity().asRedshift();
                return String.format("%f", d);
            }
            case 6: {
                Flux flux = this.targetParameters.getExpectedProperties().getExpectedPeakFluxDensity();
                return this.getFluxFormattedValue(flux);
            }
            case 7: {
                Flux flux = this.targetParameters.getExpectedProperties().getExpectedPeakLineFluxDensity();
                return this.getFluxFormattedValue(flux);
            }
            case 8: {
                UserFrequency userFrequency = this.targetParameters.getExpectedProperties().getExpectedLineWidth();
                return this.getFrequencyFormattedValue(userFrequency);
            }
            case 9: {
                double d = this.targetParameters.getExpectedProperties().getDesiredPolarizationPercentage();
                return String.format("%.2f", d);
            }
            case 10: {
                double d = this.targetParameters.getExpectedProperties().getDesiredLinePolarizationPercentage();
                return String.format("%.2f", d);
            }
            case 11: {
                double d = this.targetParameters.getExpectedProperties().getDesiredCircularPolarizationPercentage();
                return String.format("%.2f", d);
            }
            case 12: {
                double d = this.targetParameters.getExpectedProperties().getDesiredLineCircularPolarizationPercentage();
                return String.format("%.2f", d);
            }
        }
        return null;
    }

    public String getFluxFormattedValue(Flux flux) {
        double d = flux.getContentInUnits(Flux.UNIT_JY);
        if (d >= 1.0 && d < 1000.0) {
            return String.format("%.2f Jy", d);
        }
        if (d >= 1000.0 && d < 1000000.0) {
            return String.format("%.2f kJy", d / 1000.0);
        }
        if (d >= 1000000.0) {
            return String.format("%.2f MJy", d / 1000000.0);
        }
        if (d >= 0.001 && d < 1.0) {
            return String.format("%.2f mJy", d * 1000.0);
        }
        if (d <= 0.001) {
            return String.format("%.2f uJy", d * 1000000.0);
        }
        return String.format("%.4f Jy", d);
    }

    public String getFrequencyFormattedValue(UserFrequency userFrequency) {
        double d = userFrequency.getContentInUnits(UserFrequency.USERUNIT_M_S);
        if (d > 0.0 && d < 1000.0) {
            return String.format("%.2f m/s", d);
        }
        if (d > 1000.0 && d < 1000000.0) {
            return String.format("%.2f km/s", d / 1000.0);
        }
        if (d > 1000000.0) {
            return String.format("%.2f Mm/s", d / 1000000.0);
        }
        return String.format("%.4f m/s", d);
    }

    @Override
    public boolean isSummaryCellEditable(int n) {
        switch (n) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                return false;
            }
        }
        throw new RuntimeException(String.format("Invalid column number (%d)", n));
    }

    @Override
    public boolean isSummaryCellEnable(int n) {
        switch (n) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                return true;
            }
        }
        throw new RuntimeException(String.format("Invalid column number (%d)", n));
    }

    @Override
    public void setSummaryValueAt(Object object, int n) {
        switch (n) {
            case 0: {
                this.targetParameters.setSourceName((String)object);
                break;
            }
            case 1: {
                this.targetParameters.setType(FieldTypeLabelConverter.convert((String)object));
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                Longitude longitude = (Longitude)((Object)object);
                Longitude longitude2 = this.targetParameters.getSourceCoordinates().getLongitude();
                longitude2.setContentAndUnit((ValueUnitPair)longitude);
                break;
            }
            case 4: {
                Latitude latitude = (Latitude)((Object)object);
                Latitude latitude2 = this.targetParameters.getSourceCoordinates().getLatitude();
                latitude2.setContentAndUnit((ValueUnitPair)latitude);
                break;
            }
            case 5: {
                double d = (Double)object;
                this.targetParameters.getSourceVelocity().fromRedshift(d);
                break;
            }
            case 6: {
                Flux flux = (Flux)((Object)object);
                this.targetParameters.getExpectedProperties().setExpectedPeakFluxDensity(flux);
                break;
            }
            case 7: {
                Flux flux = (Flux)((Object)object);
                this.targetParameters.getExpectedProperties().setExpectedPeakFluxDensity(flux);
                break;
            }
            case 8: {
                UserFrequency userFrequency = UserFrequency.createUserFrequency((Frequency)((Object)object));
                this.targetParameters.getExpectedProperties().setExpectedLineWidth(userFrequency);
                break;
            }
            case 9: {
                double d = (Double)object;
                this.targetParameters.getExpectedProperties().setDesiredPolarizationPercentage(d);
                break;
            }
            case 10: {
                double d = (Double)object;
                this.targetParameters.getExpectedProperties().setDesiredLinePolarizationPercentage(d);
                break;
            }
            case 11: {
                double d = (Double)object;
                this.targetParameters.getExpectedProperties().setDesiredCircularPolarizationPercentage(d);
                break;
            }
            case 12: {
                double d = (Double)object;
                this.targetParameters.getExpectedProperties().setDesiredLineCircularPolarizationPercentage(d);
                break;
            }
            default: {
                return;
            }
        }
    }

    @Override
    public Object[] getSummaryColumnKnownItemList(int n) {
        switch (n) {
            case 1: {
                return TargetParameters.getKnownTypeList();
            }
        }
        return null;
    }

    @Override
    public Object[] getLongValues() {
        return longValues;
    }

    @Override
    public String getHeaderText() {
        return this.getLineText(true);
    }

    @Override
    public String getLineText() {
        return this.getLineText(false);
    }

    protected String getLineText(boolean bl) {
        int n;
        StringBuilder stringBuilder = new StringBuilder();
        for (n = 0; n < this.getSummaryColumnCount(); ++n) {
            String string = bl ? this.getSummaryColumnName(n) : this.getValueString(n);
            stringBuilder.append(string);
            stringBuilder.append(",").append(" ");
        }
        n = stringBuilder.lastIndexOf(",");
        if (n >= 0) {
            stringBuilder.delete(n, stringBuilder.length());
        }
        return stringBuilder.toString();
    }

    protected String getValueString(int n) {
        Object object = this.getSummaryValueAt(n);
        String string = object == null ? "" : object.toString();
        Class<?> clazz = this.getSummaryColumnClass(n);
        if (clazz == Longitude.class) {
            try {
                Longitude longitude = (Longitude)((Object)this.getSummaryValueAt(n));
                string = longitude.toHHMMSS();
            }
            catch (Exception exception) {}
        } else if (clazz == Latitude.class) {
            try {
                Latitude latitude = (Latitude)((Object)this.getSummaryValueAt(n));
                string = latitude.toDDMMSS();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return string;
    }
}

