/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.editors.misc;

import alma.obsprep.guiutil.ScrollWhenFocusedPane;
import alma.obsprep.guiutil.mvc.Editor;
import alma.obsprep.ot.editors.misc.TabbedEditor;
import alma.obsprep.ot.models.misc.TabbedEditorModel;
import java.util.EventObject;
import javax.swing.BoxLayout;
import javax.swing.JTable;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class TabbedEditorWithSummaryTable
extends TabbedEditor {
    private JTable table;
    private SelectionManager selectionManager = new SelectionManager();

    public TabbedEditorWithSummaryTable() {
        this.addChangeListener(this.selectionManager);
    }

    public TabbedEditorWithSummaryTable(TabbedEditorModel tabbedEditorModel, Editor editor) {
        this();
        this.subEditor = editor;
        this.registerSubView(this.subEditor);
        this.setModel(tabbedEditorModel);
        this.build();
        tabbedEditorModel.publish();
    }

    protected JTable getTable() {
        return this.table;
    }

    public void setTable(JTable jTable) {
        this.table = jTable;
        jTable.getSelectionModel().addListSelectionListener(this.selectionManager);
    }

    @Override
    protected void build() {
        this.setLayout(new BoxLayout(this, 3));
        if (this.table != null) {
            ScrollWhenFocusedPane scrollWhenFocusedPane = new ScrollWhenFocusedPane(this.table);
            scrollWhenFocusedPane.setMinimumSize(this.table.getPreferredScrollableViewportSize());
            this.add(scrollWhenFocusedPane);
        }
        this.add(this.tabbedPane);
        if (this.showsButtonBox()) {
            this.add(this.createButtons());
        }
    }

    @Override
    public int getSelectedIndex() {
        return this.selectionManager.getSelectedIndex();
    }

    @Override
    public void setSelectedIndex(int n) {
        this.selectionManager.setSelectedIndex(n, null);
    }

    protected class SelectionManager
    implements ListSelectionListener,
    ChangeListener {
        private int index = 0;

        protected SelectionManager() {
        }

        private int getSelectedIndex() {
            return TabbedEditorWithSummaryTable.this.getBOCount() == 0 ? -1 : this.index;
        }

        protected void setSelectedIndex(int n, EventObject eventObject) {
            if (n == -1) {
                this.index = 0;
                return;
            }
            this.index = n;
            JTable jTable = TabbedEditorWithSummaryTable.this.getTable();
            if (jTable != null && jTable.getSelectedRow() != n) {
                jTable.setRowSelectionInterval(n, n);
            }
            TabbedEditorWithSummaryTable.this.tabbedPane.setSelectedIndex(n);
            TabbedEditorWithSummaryTable.this.updateButtons();
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            int n = TabbedEditorWithSummaryTable.this.getTable().getSelectedRow();
            if (n != -1) {
                this.setSelectedIndex(n, listSelectionEvent);
            } else {
                this.index = 0;
            }
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            int n = TabbedEditorWithSummaryTable.this.tabbedPane.getSelectedIndex();
            if (n != -1) {
                this.setSelectedIndex(n, changeEvent);
            }
        }
    }
}

