/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.editors.misc;

import alma.obsprep.ot.editors.misc.IndividualPointingsTableLoader;
import alma.obsprep.ot.models.misc.SummaryTableColumns;
import alma.obsprep.ot.models.misc.SummaryTableRow;
import alma.valuetypes.Latitude;
import alma.valuetypes.Longitude;
import alma.valuetypes.SkyCoordinates;

public class SkyCoordinatesSummaryTableColumns
implements SummaryTableColumns {
    public static Object[] longValues = new Object[]{"09:59:42.680", "02:29:36.000", "Absolute", "SEXAGEISMAL"};
    protected SkyCoordinates skyCoords;

    public SkyCoordinatesSummaryTableColumns(SkyCoordinates skyCoordinates) {
        this.skyCoords = skyCoordinates;
    }

    @Override
    public SummaryTableRow getSummaryTableRow() {
        return this.skyCoords;
    }

    @Override
    public Class<?> getSummaryColumnClass(int n) {
        IndividualPointingsTableLoader.ColumnIndexEnumeration columnIndexEnumeration = IndividualPointingsTableLoader.ColumnIndexEnumeration.findColumnIndex(n);
        switch (columnIndexEnumeration) {
            case COL_COORDTYPE: {
                return String.class;
            }
            case COL_COORDUNIT: {
                return String.class;
            }
            case COL_DEC: {
                return Latitude.class;
            }
            case COL_RA: {
                return Longitude.class;
            }
        }
        throw new IllegalArgumentException("Unable to process column index: " + n);
    }

    @Override
    public int getSummaryColumnCount() {
        return IndividualPointingsTableLoader.ColumnIndexEnumeration.values().length;
    }

    @Override
    public String getSummaryColumnName(int n) {
        IndividualPointingsTableLoader.ColumnIndexEnumeration columnIndexEnumeration = IndividualPointingsTableLoader.ColumnIndexEnumeration.findColumnIndex(n);
        switch (columnIndexEnumeration) {
            case COL_COORDTYPE: {
                return "Coordinate type";
            }
            case COL_COORDUNIT: {
                return "Coordinate unit";
            }
            case COL_DEC: {
                return "Dec";
            }
            case COL_RA: {
                return "RA";
            }
        }
        throw new IllegalArgumentException("Unable to process column index: " + n);
    }

    @Override
    public Object getSummaryValueAt(int n) {
        IndividualPointingsTableLoader.ColumnIndexEnumeration columnIndexEnumeration = IndividualPointingsTableLoader.ColumnIndexEnumeration.findColumnIndex(n);
        switch (columnIndexEnumeration) {
            case COL_COORDTYPE: {
                return this.skyCoords.getType();
            }
            case COL_COORDUNIT: {
                return "Undefined";
            }
            case COL_DEC: {
                return this.skyCoords.getLatitude();
            }
            case COL_RA: {
                return this.skyCoords.getLongitude();
            }
        }
        throw new IllegalArgumentException("Unable to process column index: " + n);
    }

    @Override
    public boolean isSummaryCellEditable(int n) {
        IndividualPointingsTableLoader.ColumnIndexEnumeration columnIndexEnumeration = IndividualPointingsTableLoader.ColumnIndexEnumeration.findColumnIndex(n);
        switch (columnIndexEnumeration) {
            case COL_COORDTYPE: {
                return false;
            }
            case COL_COORDUNIT: {
                return false;
            }
            case COL_DEC: {
                return true;
            }
            case COL_RA: {
                return true;
            }
        }
        throw new IllegalArgumentException("Unable to process column index: " + n);
    }

    @Override
    public boolean isSummaryCellEnable(int n) {
        return true;
    }

    @Override
    public void setSummaryValueAt(Object object, int n) {
    }

    @Override
    public Object[] getSummaryColumnKnownItemList(int n) {
        return null;
    }

    @Override
    public Object[] getLongValues() {
        return longValues;
    }

    @Override
    public String getHeaderText() {
        return this.getLineText(true);
    }

    @Override
    public String getLineText() {
        return this.getLineText(false);
    }

    protected String getLineText(boolean bl) {
        int n;
        StringBuilder stringBuilder = new StringBuilder();
        for (n = 0; n < this.getSummaryColumnCount(); ++n) {
            String string = bl ? this.getSummaryColumnName(n) : this.getValueString(n);
            stringBuilder.append(string);
            stringBuilder.append(",").append(" ");
        }
        n = stringBuilder.lastIndexOf(",");
        if (n >= 0) {
            stringBuilder.delete(n, stringBuilder.length());
        }
        return stringBuilder.toString();
    }

    protected String getValueString(int n) {
        Object object = this.getSummaryValueAt(n);
        String string = object == null ? "" : object.toString();
        Class<?> clazz = this.getSummaryColumnClass(n);
        if (clazz == Longitude.class) {
            try {
                Longitude longitude = (Longitude)((Object)this.getSummaryValueAt(n));
                string = longitude.toHHMMSS();
            }
            catch (Exception exception) {}
        } else if (clazz == Latitude.class) {
            try {
                Latitude latitude = (Latitude)((Object)this.getSummaryValueAt(n));
                string = latitude.toDDMMSS();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return string;
    }
}

