/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.editors.misc;

import alma.hla.runtime.obsprep.util.Log;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JTextField;

public class AstroHolographyDialog
implements ActionListener,
WindowListener {
    private JDialog dialog;
    private GridBagLayout l;
    private GridBagConstraints c;
    private JButton okButton;
    private JButton cancelButton;
    private boolean okPressed = false;
    private boolean cancelPressed = false;
    private JTextField srcnamefld;
    private JTextField obsfreqfld;
    private JTextField refantfld;

    public AstroHolographyDialog(Frame frame, String string) {
        this.buildDialog(frame, string);
    }

    private void buildDialog(Frame frame, String string) {
        this.dialog = new JDialog(frame, string, true);
        this.dialog.setModal(true);
        this.dialog.setLocationRelativeTo(frame);
        this.l = new GridBagLayout();
        this.c = new GridBagConstraints();
        this.c.anchor = 10;
        this.dialog.getContentPane().setLayout(this.l);
        String string2 = "Enter the source name for this holography SB and the ";
        String string3 = "frequency you wish to observe at.";
        String string4 = "Then click OK to create the astro-holography SB.";
        String string5 = "If the name resolution fails, or if you wish to change";
        String string6 = "any values then you may edit the SB target afterwards.";
        this.c.gridx = 0;
        this.c.gridy = 0;
        this.c.gridwidth = 2;
        JLabel jLabel = new JLabel(string2);
        this.add(jLabel);
        this.c.gridy = 1;
        JLabel jLabel2 = new JLabel(string3);
        this.add(jLabel2);
        this.c.gridy = 2;
        JLabel jLabel3 = new JLabel(string4);
        this.add(jLabel3);
        this.c.gridy = 3;
        JLabel jLabel4 = new JLabel(string5);
        this.add(jLabel4);
        this.c.gridy = 4;
        JLabel jLabel5 = new JLabel(string6);
        this.add(jLabel5);
        ++this.c.gridy;
        this.c.weighty = 10.0;
        this.c.gridwidth = 1;
        JLabel jLabel6 = new JLabel("Source name: ");
        this.srcnamefld = new JTextField();
        this.srcnamefld.setToolTipText("Name of source to be used");
        this.srcnamefld.setColumns(20);
        this.srcnamefld.setText("");
        this.add(jLabel6);
        ++this.c.gridx;
        this.add(this.srcnamefld);
        ++this.c.gridy;
        ++this.c.gridy;
        JLabel jLabel7 = new JLabel("Observing Frequency (GHz): ");
        this.obsfreqfld = new JTextField();
        this.obsfreqfld.setToolTipText("Observing frequency to be used, in GHz");
        this.obsfreqfld.setColumns(20);
        this.obsfreqfld.setText("104.0");
        this.c.gridx = 0;
        ++this.c.gridy;
        this.add(jLabel7);
        ++this.c.gridx;
        this.add(this.obsfreqfld);
        this.c.gridx = 0;
        ++this.c.gridy;
        ++this.c.gridy;
        JLabel jLabel8 = new JLabel("Reference Antennas: ");
        this.refantfld = new JTextField();
        this.refantfld.setToolTipText("Antennas to use for this run");
        this.refantfld.setColumns(20);
        ++this.c.gridy;
        this.add(jLabel8);
        ++this.c.gridx;
        this.add(this.refantfld);
        this.c.gridx = 0;
        ++this.c.gridy;
        ++this.c.gridy;
        this.c.weighty = 10.0;
        this.addButtons();
        this.dialog.setDefaultCloseOperation(1);
        this.dialog.addWindowListener(this);
        this.dialog.setModal(true);
        this.dialog.pack();
        this.dialog.setVisible(true);
    }

    private void addButtons() {
        this.okButton = new JButton("OK");
        this.cancelButton = new JButton("Cancel");
        this.okButton.setMinimumSize(this.cancelButton.getMinimumSize());
        this.okButton.setPreferredSize(this.cancelButton.getPreferredSize());
        this.okButton.setMaximumSize(this.cancelButton.getMaximumSize());
        this.c.gridx = 0;
        this.c.gridwidth = 1;
        this.add(this.okButton);
        ++this.c.gridx;
        this.add(this.cancelButton);
        ++this.c.gridx;
        this.okButton.addActionListener(this);
        this.cancelButton.addActionListener(this);
    }

    public boolean cancelPressed() {
        return this.cancelPressed;
    }

    public boolean okPressed() {
        return this.okPressed;
    }

    public String getSourceName() {
        return this.srcnamefld.getText();
    }

    public double getObservingFrequencyGHz() throws NumberFormatException {
        String string = this.obsfreqfld.getText();
        Double d = Double.parseDouble(string);
        return d;
    }

    public String getReferenceAntennas() {
        return this.refantfld.getText();
    }

    private void add(Component component) {
        this.l.setConstraints(component, this.c);
        this.dialog.getContentPane().add(component);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        JButton jButton = (JButton)actionEvent.getSource();
        if (jButton.equals(this.okButton)) {
            this.okPressed = true;
            this.dialog.setVisible(false);
        } else if (jButton.equals(this.cancelButton)) {
            this.cancelPressed = true;
            this.dialog.setVisible(false);
        }
    }

    @Override
    public void windowActivated(WindowEvent windowEvent) {
        Log.logger((Object)this).finest("windowActivated(ev)");
    }

    @Override
    public void windowClosed(WindowEvent windowEvent) {
        Log.logger((Object)this).finest("windowClosed(ev)");
    }

    @Override
    public void windowClosing(WindowEvent windowEvent) {
        this.cancelPressed = true;
        Log.logger((Object)this).finest("windowClosing(ev)");
    }

    @Override
    public void windowDeactivated(WindowEvent windowEvent) {
        Log.logger((Object)this).finest("windowDeactivated(ev)");
    }

    @Override
    public void windowDeiconified(WindowEvent windowEvent) {
        Log.logger((Object)this).finest("windowDeiconified(ev)");
    }

    @Override
    public void windowIconified(WindowEvent windowEvent) {
        Log.logger((Object)this).finest("windowIconified(ev)");
    }

    @Override
    public void windowOpened(WindowEvent windowEvent) {
        Log.logger((Object)this).finest("windowOpened(ev)");
    }
}

