/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.editors.investigator;

import alma.hla.runtime.obsprep.util.Log;
import alma.hla.runtime.obsprep.util.UnknownEntityException;
import alma.obsprep.bo.obsproject.ObsProject;
import alma.obsprep.bo.obsproposal.Investigator;
import alma.obsprep.bo.obsproposal.ObsProposal;
import alma.obsprep.ot.editors.investigator.InvestigatorsEditor;
import alma.obsprep.ot.editors.investigator.TableInvestigator;
import alma.obsprep.ot.gui.toplevel.ObservingToolController;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import javax.swing.table.AbstractTableModel;

public class InvestigatorsTableModel
extends AbstractTableModel {
    private static final int ARC_COLUMN = 5;
    private static final int USERID_COLUMN = 4;
    private static final int ORGANISATION_COLUMN = 3;
    private static final int EMAIL_COLUMN = 2;
    private static final int FULLNAME_COLUMN = 1;
    static final int REVIEWER_COLUMN = 6;
    String[] columnNames = new String[]{"Type", "Full name", "Email", "Affiliation", "ALMA ID", "Executive", "Reviewer"};
    LinkedList<TableInvestigator> investigators = new LinkedList();

    @Override
    public int getColumnCount() {
        return this.columnNames.length;
    }

    @Override
    public String getColumnName(int n) {
        return this.columnNames[n];
    }

    @Override
    public int getRowCount() {
        return this.investigators.size();
    }

    public TableInvestigator getUserAt(int n) {
        return this.investigators.get(n);
    }

    @Override
    public Object getValueAt(int n, int n2) {
        TableInvestigator tableInvestigator = this.getUserAt(n);
        switch (n2) {
            case 0: {
                if (tableInvestigator.getUserType() == TableInvestigator.USER_TYPE.PI) {
                    return "PI";
                }
                if (tableInvestigator.getUserType() == TableInvestigator.USER_TYPE.COPI) {
                    return "CoPI";
                }
                return "CoI";
            }
            case 1: {
                return tableInvestigator.getFullName().equals("") ? "Not set" : tableInvestigator.getFullName();
            }
            case 2: {
                return tableInvestigator.getEMail().equals("") ? "Not set" : tableInvestigator.getEMail();
            }
            case 3: {
                return tableInvestigator.getOrganisation().equals("") ? "Not set" : tableInvestigator.getOrganisation();
            }
            case 4: {
                return tableInvestigator.getUserId().equals("") ? "Not set" : tableInvestigator.getUserId();
            }
            case 5: {
                return InvestigatorsEditor.Executive.fromSoValue(tableInvestigator.getAssociatedExec());
            }
            case 6: {
                return this.isUserReviewer(tableInvestigator);
            }
        }
        return null;
    }

    private boolean isUserReviewer(TableInvestigator tableInvestigator) {
        Investigator investigator = null;
        try {
            ObsProject obsProject = ObservingToolController.getMyInstance().getPrimaryProject();
            investigator = obsProject.getObsProposal().getReviewer();
        }
        catch (Exception exception) {
            return false;
        }
        if (investigator == null) {
            return false;
        }
        return tableInvestigator.getUserId().equals(investigator.getUserId());
    }

    @Override
    public Class<?> getColumnClass(int n) {
        return this.getValueAt(0, n).getClass();
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        TableInvestigator tableInvestigator;
        String string;
        if (5 == n2 && Investigator.ALLOWEDEXEC_NA_EA.equals(string = (tableInvestigator = this.getUserAt(n)).getAssociatedArc())) {
            return true;
        }
        return 6 == n2;
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        TableInvestigator tableInvestigator = this.getUserAt(n);
        if (object instanceof String) {
            String string = (String)object;
            switch (n2) {
                case 1: {
                    tableInvestigator.setFullName(string);
                    tableInvestigator.setVerifiedUser(false);
                    break;
                }
                case 2: {
                    tableInvestigator.setEmail(string);
                    tableInvestigator.setVerifiedUser(false);
                    break;
                }
                case 3: {
                    tableInvestigator.setOrganisation(string);
                    tableInvestigator.setVerifiedUser(false);
                    break;
                }
                case 4: {
                    tableInvestigator.setUserId(string);
                    tableInvestigator.setVerifiedUser(false);
                }
            }
            this.fireTableCellUpdated(n, n2);
        } else if (object instanceof Boolean) {
            if (n2 == 6) {
                boolean bl = (Boolean)object;
                try {
                    ObsProposal obsProposal = ObservingToolController.getMyInstance().getPrimaryProject().getObsProposal();
                    List<Investigator> list = this.getAllInvestigators();
                    if (bl) {
                        list.stream().filter(investigator -> investigator.getUserId().equals(tableInvestigator.getUserId())).findFirst().ifPresent(investigator -> obsProposal.setReviewer(investigator.deepCopy()));
                    } else {
                        obsProposal.setReviewer(null);
                    }
                    this.fireTableCellUpdated(n, n2);
                }
                catch (Exception exception) {
                    Log.logger(this.getClass()).warning("Unable to determine reviewer " + exception.getMessage());
                }
            }
        } else if (object instanceof InvestigatorsEditor.Executive) {
            InvestigatorsEditor.Executive executive = (InvestigatorsEditor.Executive)((Object)object);
            tableInvestigator.setAssociatedExec(executive.getSoValue());
            tableInvestigator.setVerifiedUser(false);
            this.fireTableCellUpdated(n, n2);
        } else {
            throw new IllegalArgumentException("Unhandled table value: " + String.valueOf(object));
        }
    }

    private List<Investigator> getAllInvestigators() throws UnknownEntityException {
        ObsProposal obsProposal = ObservingToolController.getMyInstance().getPrimaryProject().getObsProposal();
        List<Investigator> list = Arrays.asList(obsProposal.getPrincipalInvestigator());
        List<Investigator> list2 = Arrays.asList(obsProposal.getCoInvestigator());
        List<Investigator> list3 = Arrays.asList(obsProposal.getCoPrincipalInvestigator());
        ArrayList<Investigator> arrayList = new ArrayList<Investigator>();
        arrayList.addAll(list);
        arrayList.addAll(list2);
        arrayList.addAll(list3);
        return arrayList;
    }

    public void clearAll() {
        this.investigators.clear();
    }

    public void setPi(Investigator investigator) {
        if (investigator != null) {
            this.removePi();
            this.investigators.push(new TableInvestigator(investigator, TableInvestigator.USER_TYPE.PI));
        }
        this.fireTableDataChanged();
    }

    public void setPi(List<Investigator> list) {
        if (!list.isEmpty()) {
            this.setPi(list.get(0));
        }
    }

    public void addCois(List<Investigator> list) {
        for (Investigator investigator : list) {
            this.investigators.add(new TableInvestigator(investigator, TableInvestigator.USER_TYPE.COI));
        }
        this.fireTableDataChanged();
    }

    public void removeCois(List<TableInvestigator> list) {
        for (TableInvestigator tableInvestigator : list) {
            if (tableInvestigator.getUserType() != TableInvestigator.USER_TYPE.COI) continue;
            this.investigators.remove(tableInvestigator);
        }
        this.fireTableDataChanged();
    }

    private int getIndexOfLastCoPI() {
        int n = 1;
        for (int i = this.investigators.size() - 1; i > 1; --i) {
            TableInvestigator tableInvestigator = this.investigators.get(i);
            if (!TableInvestigator.USER_TYPE.COPI.equals((Object)tableInvestigator.getUserType())) continue;
            n = i;
            break;
        }
        return n;
    }

    public void addCoPis(List<Investigator> list) {
        ArrayList<TableInvestigator> arrayList = new ArrayList<TableInvestigator>();
        for (Investigator investigator : list) {
            arrayList.add(new TableInvestigator(investigator, TableInvestigator.USER_TYPE.COPI));
        }
        int n = this.getIndexOfLastCoPI();
        this.investigators.addAll(n, arrayList);
        this.fireTableDataChanged();
    }

    public void removeCoPis(List<TableInvestigator> list) {
        for (TableInvestigator tableInvestigator : list) {
            if (tableInvestigator.getUserType() != TableInvestigator.USER_TYPE.COPI) continue;
            this.investigators.remove(tableInvestigator);
            try {
                this.removeInvestigatorAsReviewer(tableInvestigator);
            }
            catch (UnknownEntityException unknownEntityException) {
                Log.logger(this.getClass()).warning("Unable to determine reviewer " + unknownEntityException.getMessage());
            }
        }
        this.fireTableDataChanged();
    }

    private void removeInvestigatorAsReviewer(TableInvestigator tableInvestigator) throws UnknownEntityException {
        ObsProposal obsProposal = ObservingToolController.getMyInstance().getPrimaryProject().getObsProposal();
        if (obsProposal.gettrueReviewer() != null) {
            return;
        }
        List<Investigator> list = this.getAllInvestigators();
        list.stream().filter(investigator -> investigator.getEMail().equals(tableInvestigator.getEMail())).findFirst().ifPresent(investigator -> obsProposal.setReviewer(null));
    }

    private void removePi() {
        for (TableInvestigator tableInvestigator : this.investigators) {
            if (tableInvestigator.getUserType() != TableInvestigator.USER_TYPE.PI) continue;
            this.investigators.remove(tableInvestigator);
            try {
                this.removeInvestigatorAsReviewer(tableInvestigator);
            }
            catch (UnknownEntityException unknownEntityException) {
                Log.logger(this.getClass()).warning("Unable to determine reviewer " + unknownEntityException.getMessage());
            }
            return;
        }
    }
}

