/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.actions.deletechecker;

import alma.obsprep.bo.obsproject.ObsUnitSet;
import alma.obsprep.bo.obsproject.ScienceGoal;
import alma.obsprep.ot.actions.OTActionHelper;
import alma.obsprep.ot.actions.deletechecker.DeleteChecker;
import alma.obsprep.services.network.roledirectory.RoleDirectoryServiceHelper;

class ScienceGoalDeleteChecker
implements DeleteChecker {
    private final ScienceGoal goal;

    public ScienceGoalDeleteChecker(ScienceGoal scienceGoal) {
        this.goal = scienceGoal;
    }

    @Override
    public boolean canDelete() {
        ObsUnitSet obsUnitSet = this.goal.gettrueObsUnitSet();
        if (obsUnitSet == null) {
            if (!RoleDirectoryServiceHelper.isUserP2G()) {
                return OTActionHelper.isOperationValidOnSGForPI(this.goal);
            }
            return true;
        }
        if (obsUnitSet.isDeletable()) {
            return !this.goal.isPhase2ScienceGoal() || RoleDirectoryServiceHelper.isUserP2G();
        }
        return false;
    }
}

