/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.actions;

import alma.obsprep.bo.obsproject.ObsProject;
import alma.obsprep.ot.actions.RetrieveBase;
import alma.obsprep.ot.actions.RetrievePerformer;
import alma.obsprep.ot.gui.toplevel.DialogId;
import alma.obsprep.ot.gui.toplevel.ObservingToolGui;
import alma.obsprep.ot.persistence.ProjectRepository;
import alma.obsprep.util.GUIUtilities;

public class RetrieveProject
extends RetrieveBase {
    private static DialogId DIALOG_WILL_NOT_BE_ABLE_TO_RESUBMIT = new DialogId("Retrieve.ResubmissionFutile");

    public RetrieveProject(ObservingToolGui observingToolGui, ProjectRepository projectRepository) {
        super(observingToolGui, projectRepository);
        RetrievePerformer retrievePerformer = new RetrievePerformer(this, projectRepository);
        this.setPerformer(retrievePerformer);
    }

    @Override
    public ProjectRepository.RetrieveVariant getRetrieveVariant() {
        return ProjectRepository.RetrieveVariant.retrieve;
    }

    @Override
    public void display(ObsProject obsProject) {
        this.gui.setPrimaryProject(obsProject, null, false);
        this.gui.flagBrokenSchedBlocks(obsProject);
        if (!ObsProject.getSubmittableStates().contains(obsProject.getStatus())) {
            // empty if block
        }
    }

    @Override
    public boolean convertPhase1ToPhase2() {
        return true;
    }

    @Override
    public boolean convertPhase2ToPhase1() {
        return false;
    }

    @Override
    public void infoAboutRejected() {
        GUIUtilities.info(null, "Please note that this is a rejected project: Retrieving for reading only, you cannot re-submit");
    }

    @Override
    public String getObsProjectId() {
        return super.getObsProjectIdFromArchiveFinder();
    }

    @Override
    public boolean confirmOverwrite() {
        return super.confirmOverwriteIfModified();
    }
}

