/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.actions;

import alma.obsprep.ot.actions.OTAction;
import alma.obsprep.ot.actions.RetrieveInteractor;
import alma.obsprep.ot.actions.RetrievePerformer;
import alma.obsprep.ot.gui.toplevel.DialogId;
import alma.obsprep.ot.gui.toplevel.ObsProjectChooser;
import alma.obsprep.ot.gui.toplevel.ObservingToolGui;
import alma.obsprep.ot.persistence.ProjectRepository;
import alma.obsprep.util.GUIUtilities;
import alma.obsprep.util.IHelpfulError;

public abstract class RetrieveBase
extends OTAction
implements RetrieveInteractor {
    protected static DialogId DIALOG_SAVE_CURRENT_PROJECT = new DialogId("Retrieve.SaveCurrentProject");
    protected ObservingToolGui gui;

    public RetrieveBase(ObservingToolGui observingToolGui, ProjectRepository projectRepository) {
        this.gui = observingToolGui;
        this.setEnabled(projectRepository != null);
    }

    @Override
    public void error(Exception exception) {
        String string;
        String string2 = string = exception instanceof IHelpfulError ? ((IHelpfulError)((Object)exception)).getUserMeaning() : exception.getMessage();
        if (string == null) {
            string = "retrieve failed";
        }
        GUIUtilities.error(null, "Retrieve operation cancelled: " + string, exception);
    }

    @Override
    public void info(String string) {
        GUIUtilities.info(null, string);
    }

    @Override
    public void busy(boolean bl) {
        this.gui.showAsBusy(bl);
    }

    protected String getObsProjectIdFromArchiveFinder() {
        String string = null;
        ProjectRepository projectRepository = ((RetrievePerformer)this.getPerformer()).projectRepository();
        ObsProjectChooser.DefaultDialog defaultDialog = new ObsProjectChooser.DefaultDialog(projectRepository);
        defaultDialog.setAdvancedOptionsVisible(this.gui.shouldShowStaffActions());
        string = defaultDialog.letUserChooseProject();
        return string;
    }

    protected boolean confirmOverwriteIfModified() {
        if (this.gui.isProjectModified(this.gui.getPrimaryProject())) {
            switch (GUIUtilities.offer(DIALOG_SAVE_CURRENT_PROJECT, "The current project has unsaved changes.\nDo you want to save it now, or discard the changes?", "Save", "Discard", "Cancel")) {
                case 2: {
                    return false;
                }
                case 0: {
                    this.gui.primaryProjectCompartment().getProjectTiedActions().save.actionPerformed(null);
                }
            }
        }
        return true;
    }
}

