/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.actions;

import alma.acs.entityutil.EntityException;
import alma.hla.runtime.obsprep.util.Log;
import alma.hla.runtime.obsprep.util.UnknownEntityException;
import alma.obsprep.bo.obsproject.ObsProject;
import alma.obsprep.ot.actions.OTAction;
import alma.obsprep.ot.gui.toplevel.ObservingToolGui;
import alma.obsprep.ot.persistence.MendMyStruct;
import alma.obsprep.util.GUIUtilities;
import java.util.logging.Level;

public class RejuvenateProject {

    public static class Action
    extends OTAction
    implements Interactor {
        protected ObservingToolGui gui;

        public Action(ObservingToolGui observingToolGui) {
            this.gui = observingToolGui;
            super.setPerformer(new Performer(this));
        }

        @Override
        public ObsProject getProject() {
            return this.gui.getPrimaryProject();
        }

        @Override
        public void error(String string) {
            GUIUtilities.error(null, string);
        }
    }

    public static interface Interactor
    extends alma.obsprep.ot.actions.Interactor {
        public ObsProject getProject();

        public void error(String var1);
    }

    public static class Performer
    extends alma.obsprep.ot.actions.Performer {
        public Performer(Interactor interactor) {
            super(interactor);
        }

        @Override
        public void perform() {
            Interactor interactor = (Interactor)super.getGui();
            ObsProject obsProject = interactor.getProject();
            try {
                MendMyStruct.recycleProjectAsNewProject(obsProject, false);
            }
            catch (EntityException | UnknownEntityException throwable) {
                interactor.error("Failed to convert project to a Phase 1 project");
                Log.logger((Object)this).log(Level.INFO, "Failed to convert project to a Phase 1 project", throwable);
            }
        }
    }
}

