/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.actions;

import alma.obsprep.ot.actions.Interactor;
import alma.obsprep.ot.actions.Performer;
import alma.obsprep.util.job.AbstractJob;
import alma.obsprep.util.job.JobUtility;
import java.awt.event.ActionEvent;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;

public abstract class OTAction
extends AbstractAction
implements Interactor {
    protected static final String SAVE_OR_DISCARD_CHANGES = "The current project has unsaved changes.\nDo you want to save it now, or discard the changes?";
    protected static final String IO_FILE_FILTER_DESCRIPTION = "OT import/export files";
    private Performer performer = null;
    private boolean hidable = true;
    List<JComponent> components = new ArrayList<JComponent>();
    protected boolean isUIComponentsHiddenWhenActionOutOfContext = false;

    protected OTAction() {
    }

    OTAction(String string) {
        super(string);
    }

    OTAction(String string, Icon icon) {
        super(string, icon);
    }

    public String getName() {
        return (String)this.getValue("Name");
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        AbstractJob abstractJob = new AbstractJob(this.getName(), false){

            @Override
            public void job() throws Exception {
                OTAction.this.performer.perform();
            }
        };
        if (this.performer instanceof Performer.Async) {
            abstractJob.setExecutor(JobUtility.swing);
        } else if (this.performer instanceof Performer.Async2) {
            abstractJob.setExecutor(JobUtility.otqueue);
        } else {
            if (!SwingUtilities.isEventDispatchThread()) {
                try {
                    SwingUtilities.invokeAndWait(abstractJob);
                }
                catch (InvocationTargetException invocationTargetException) {
                    Throwable throwable = invocationTargetException.getTargetException();
                    if (throwable instanceof Error) {
                        throw (Error)throwable;
                    }
                    if (throwable instanceof RuntimeException) {
                        throw (RuntimeException)throwable;
                    }
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                }
                return;
            }
            abstractJob.setExecutor(JobUtility.inline);
        }
        abstractJob.go();
    }

    public void addComponent(JComponent jComponent) {
        if (!this.components.contains(jComponent)) {
            this.components.add(jComponent);
        }
    }

    public void setVisible(boolean bl) {
        for (JComponent jComponent : this.components) {
            jComponent.setVisible(bl);
        }
    }

    public boolean isVisible() {
        Iterator<JComponent> iterator = this.components.iterator();
        if (iterator.hasNext()) {
            JComponent jComponent = iterator.next();
            return jComponent.isVisible();
        }
        return true;
    }

    public Performer getPerformer() {
        return this.performer;
    }

    public void setPerformer(Performer performer) {
        this.performer = performer;
    }

    public boolean isHidable() {
        return this.hidable;
    }

    public void setHidable(boolean bl) {
        this.hidable = bl;
    }

    public boolean isUIComponentsHiddenWhenActionOutOfContext() {
        return this.isUIComponentsHiddenWhenActionOutOfContext;
    }

    public void setUIComponentsHiddenWhenActionOutOfContext(boolean bl) {
        this.isUIComponentsHiddenWhenActionOutOfContext = bl;
    }
}

