/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.actions;

import alma.common.sensitivitycalculatorcore.calc.SensitivityCalculatorEngine;
import alma.obsprep.guiutil.events.EventManager;
import alma.obsprep.guiutil.events.EventReceiver;
import alma.obsprep.guiutil.events.EventTypes;
import alma.obsprep.ot.actions.ExpTimeCalcInteractor;
import alma.obsprep.ot.actions.ExpTimeCalcPerformer;
import alma.obsprep.ot.actions.OTAction;
import alma.obsprep.ot.gui.toplevel.GuiFactory;
import alma.obsprep.services.etc.editor.EtcParamsSeed;
import alma.obsprep.services.etc.editor.SensitivityCalculatorEditor;
import alma.obsprep.services.etc.editor.SensitivityCalculatorModel;
import java.awt.Component;
import javax.help.CSH;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;

public class ExpTimeCalc
extends OTAction
implements ExpTimeCalcInteractor {
    private final JFrame frame;
    private final SensitivityCalculatorModel scm = new SensitivityCalculatorModel(null);
    private final SensitivityCalculatorEditor sce = new SensitivityCalculatorEditor(this.scm);

    public ExpTimeCalc() {
        this((EventReceiver)null);
        EtcParamsSeed etcParamsSeed = new EtcParamsSeed(this.scm);
        EventManager.subscribeByType(EventTypes.NODESELECTED, etcParamsSeed);
    }

    public ExpTimeCalc(EventReceiver eventReceiver) {
        SensitivityCalculatorEngine sensitivityCalculatorEngine = new SensitivityCalculatorEngine();
        sensitivityCalculatorEngine.setObservingFrequencyInGHZ(345.0);
        sensitivityCalculatorEngine.setBandwidth(7.5);
        sensitivityCalculatorEngine.set12MIntegrationTimeInSec(60.0);
        sensitivityCalculatorEngine.set7MIntegrationTimeInSec(60.0);
        sensitivityCalculatorEngine.setTPIntegrationTimeInSec(60.0);
        sensitivityCalculatorEngine.set12MBeamsizeInArcsecs(0.0);
        sensitivityCalculatorEngine.set7MBeamsizeInArcsecs(0.0);
        sensitivityCalculatorEngine.set12MSensitivityUnit(SensitivityCalculatorEngine.UserSensitivityType.UJY);
        sensitivityCalculatorEngine.set7MSensitivityUnit(SensitivityCalculatorEngine.UserSensitivityType.MJY);
        sensitivityCalculatorEngine.setTPSensitivityUnit(SensitivityCalculatorEngine.UserSensitivityType.MJY);
        this.scm.setDocument(sensitivityCalculatorEngine);
        if (eventReceiver != null) {
            EventManager.subscribeByType(EventTypes.NODESELECTED, eventReceiver);
        }
        this.frame = GuiFactory.getFactory().giveFrame("Sensitivity Calculator");
        this.frame.getContentPane().add(this.sce);
        this.frame.pack();
        CSH.setHelpIDString((Component)this.frame, (String)"TOC-Tools and Simulators-ALMA Sensitivity Calculator");
        ExpTimeCalcPerformer expTimeCalcPerformer = new ExpTimeCalcPerformer(this);
        this.setPerformer(expTimeCalcPerformer);
    }

    public SensitivityCalculatorEditor getSensitivityCalculatorEditor() {
        return this.sce;
    }

    @Override
    public void showPanel() {
        SwingUtilities.updateComponentTreeUI(this.frame);
        this.frame.setVisible(true);
    }
}

