/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.actions;

import alma.hla.runtime.obsprep.bo.BusinessObject;
import alma.obsprep.guiutil.events.Event;
import alma.obsprep.guiutil.events.EventManager;
import alma.obsprep.guiutil.events.EventReceiver;
import alma.obsprep.guiutil.events.EventTypes;
import alma.obsprep.ot.actions.CopyInteractor;
import alma.obsprep.ot.actions.CopyPerformer;
import alma.obsprep.ot.actions.OTAction;
import alma.obsprep.ot.actions.OTActionHelper;
import alma.obsprep.ot.project.ProjectTree;
import alma.obsprep.ot.project.ProjectTreeNode;
import alma.obsprep.services.network.roledirectory.RoleDirectoryService;
import alma.obsprep.util.GUIUtilities;
import lombok.NonNull;

public class Copy
extends OTAction
implements CopyInteractor,
EventReceiver,
RoleDirectoryService.UserAuthenticatesListener {
    private final ProjectTree m_oustree;
    private final ProjectTree m_usertree;
    private BusinessObject selectedBO = null;
    private BusinessObject parentBO = null;
    private ProjectTreeNode selectedNode = null;
    private ProjectTreeNode parentNode = null;
    private boolean isUserview;

    public Copy(@NonNull ProjectTree projectTree, @NonNull ProjectTree projectTree2) {
        if (projectTree == null) {
            throw new NullPointerException("usertree is marked non-null but is null");
        }
        if (projectTree2 == null) {
            throw new NullPointerException("oustree is marked non-null but is null");
        }
        this.m_usertree = projectTree;
        this.m_oustree = projectTree2;
        CopyPerformer copyPerformer = new CopyPerformer(this);
        this.setPerformer(copyPerformer);
        EventManager.subscribeByType(EventTypes.NODESELECTED, this);
        this.setEnabled(false);
        RoleDirectoryService.addUserAuthenticatesListener(this);
        this.setHidable(false);
    }

    @Override
    public void error(String string) {
        GUIUtilities.error(null, string);
    }

    @Override
    public void info(String string) {
        GUIUtilities.info(null, string);
    }

    @Override
    public void updateDisplay() {
        if (this.isUserview) {
            this.m_usertree.removeNodeFrom(this.getSelectedNode(), this.getParentNode());
        } else {
            this.m_oustree.removeNodeFrom(this.getSelectedNode(), this.getParentNode());
        }
    }

    private void setEnabledFor(ProjectTreeNode projectTreeNode, boolean bl) {
        ProjectTree projectTree = bl ? this.m_usertree : this.m_oustree;
        this.setEnabled(projectTree.isDndExportable(projectTreeNode, 1) && !OTActionHelper.isActionPIRestricted(projectTreeNode.getUserObjectPath()));
    }

    @Override
    public void receiveEvent(Event event) {
        this.selectedNode = (ProjectTreeNode)event.getSource();
        this.parentNode = (ProjectTreeNode)this.selectedNode.getParent();
        this.selectedBO = (BusinessObject)this.selectedNode.getUserObject();
        this.parentBO = this.parentNode != null ? (BusinessObject)this.parentNode.getUserObject() : null;
        this.isUserview = this.m_usertree.getTop() == this.selectedNode.getRoot();
        this.setEnabledFor(this.selectedNode, this.isUserview);
    }

    @Override
    public ProjectTree getProjectTree() {
        ProjectTree projectTree = null;
        projectTree = this.isUserview ? this.m_usertree : this.m_oustree;
        return projectTree;
    }

    @Override
    public void userHasAuthenticated() {
        if (this.selectedBO == null) {
            return;
        }
        this.setEnabledFor(this.selectedNode, this.isUserview);
    }

    @Override
    public BusinessObject getSelectedBO() {
        return this.selectedBO;
    }

    @Override
    public BusinessObject getParentBO() {
        return this.parentBO;
    }

    @Override
    public ProjectTreeNode getSelectedNode() {
        return this.selectedNode;
    }

    public ProjectTreeNode getParentNode() {
        return this.parentNode;
    }
}

