/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.actions;

import alma.hla.runtime.obsprep.bo.BusinessObject;
import alma.obsprep.bo.schedblock.Target;
import alma.obsprep.guiutil.events.Event;
import alma.obsprep.guiutil.events.EventManager;
import alma.obsprep.guiutil.events.EventReceiver;
import alma.obsprep.guiutil.events.EventTypes;
import alma.obsprep.ot.actions.AttachInteractor;
import alma.obsprep.ot.actions.AttachPerformer;
import alma.obsprep.ot.actions.OTAction;
import alma.obsprep.ot.editors.schedblock.AttachableComponentChooser;
import alma.obsprep.ot.project.ProjectTree;
import alma.obsprep.ot.project.ProjectTreeNode;
import alma.obsprep.services.network.roledirectory.RoleDirectoryServiceHelper;
import alma.obsprep.util.GUIUtilities;
import java.util.Iterator;
import java.util.List;

public class Attach
extends OTAction
implements AttachInteractor,
EventReceiver {
    private final ProjectTree m_ptree;
    private BusinessObject m_bo = null;
    private ProjectTreeNode m_treeNode = null;

    public Attach(ProjectTree projectTree) {
        this.m_ptree = projectTree;
        AttachPerformer attachPerformer = new AttachPerformer(this);
        this.setPerformer(attachPerformer);
        EventManager.subscribeByType(EventTypes.NODESELECTED, this);
        this.setEnabled(false);
    }

    @Override
    public Iterator<BusinessObject> select(List<BusinessObject> list, List<BusinessObject> list2) {
        BusinessObject[] businessObjectArray = list.toArray(new BusinessObject[list.size()]);
        BusinessObject[] businessObjectArray2 = list2.toArray(new BusinessObject[list2.size()]);
        return AttachableComponentChooser.chooseMultiple(businessObjectArray, businessObjectArray2);
    }

    @Override
    public void error(String string) {
        GUIUtilities.error(null, string);
    }

    @Override
    public BusinessObject getSelectedBO() {
        return this.m_bo;
    }

    public ProjectTreeNode getSelectedNode() {
        return this.m_treeNode;
    }

    private void setEnabledFor(BusinessObject businessObject) {
        boolean bl = businessObject.getClass() == Target.class ? !this.m_ptree.isOusCompProtected() && RoleDirectoryServiceHelper.isUserP2G() : false;
        this.setEnabled(bl);
    }

    @Override
    public void receiveEvent(Event event) {
        this.m_treeNode = (ProjectTreeNode)event.getSource();
        this.m_bo = (BusinessObject)this.m_treeNode.getUserObject();
        this.m_treeNode.getRoot();
        if (this.m_ptree.getTop() == this.m_treeNode.getRoot()) {
            this.setEnabledFor(this.m_bo);
        } else {
            this.setEnabled(false);
        }
    }
}

