/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.guiutil.mvc.widgets;

import alma.obsprep.guiutil.ScrollWhenFocusedPane;
import alma.obsprep.guiutil.mvc.widgets.UndoableTextArea;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.BoxLayout;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class OTBasicTextArea
extends JPanel
implements ActionListener {
    private static final long serialVersionUID = -7442106344194799536L;
    public static final String EDIT = "EditorUpdate";
    protected UndoableTextArea textArea = null;
    protected JScrollPane jsp = null;

    public OTBasicTextArea() {
        this("", false, "");
    }

    public OTBasicTextArea(boolean bl, String string) {
        this("", bl, string);
    }

    public OTBasicTextArea(String string, boolean bl, String string2) {
        this.setFocusCycleRoot(true);
        FocusListener focusListener = new FocusListener(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
                if (OTBasicTextArea.this.textArea.isEditable()) {
                    OTBasicTextArea.this.setText(OTBasicTextArea.this.getText(), true);
                }
            }
        };
        this.textArea = new UndoableTextArea(string);
        this.textArea.setToolTipText(string2);
        this.textArea.addFocusListener(focusListener);
        this.textArea.setFont(new Font("Courier", 0, 14));
        this.jsp = new ScrollWhenFocusedPane(this.textArea);
        this.jsp.setVerticalScrollBarPolicy(20);
        if (bl) {
            this.jsp.setHorizontalScrollBarPolicy(31);
            this.textArea.setLineWrap(true);
            this.textArea.setWrapStyleWord(true);
        } else {
            this.jsp.setHorizontalScrollBarPolicy(30);
        }
        this.jsp.setPreferredSize(new Dimension(100, 100));
        this.jsp.setOpaque(true);
        this.setLayout(new BoxLayout(this, 1));
        this.add(this.jsp);
    }

    protected synchronized void enableInlineEditing() {
        this.textArea.setEditable(true);
        this.textArea.setForeground(Color.BLACK);
        this.scrollToBottom();
        this.textArea.requestFocus();
    }

    protected synchronized void disableInlineEditing() {
        this.setText(this.getText(), true);
        this.textArea.setEditable(false);
        this.textArea.setForeground(Color.GRAY);
    }

    public JTextArea getJTextArea() {
        return this.textArea;
    }

    public String getText() {
        return this.textArea.getText();
    }

    public void scrollToTop() {
        this.textArea.setCaretPosition(0);
    }

    public void scrollToBottom() {
        this.textArea.setCaretPosition(this.textArea.getText().length());
    }

    public void setText(String string) {
        this.setText(string, false);
    }

    public void setText(String string, boolean bl) {
        this.scrollToTop();
        this.textArea.setText(string);
        if (bl) {
            this.firePropertyChange(EDIT, string, null);
        }
    }

    public void commitText() {
        this.setText(this.getText(), true);
    }

    @Override
    public void setEnabled(boolean bl) {
        this.textArea.setEditable(bl);
        super.setEnabled(bl);
    }

    public void setPreferredSize(int n, int n2) {
        this.jsp.setPreferredSize(new Dimension(n, n2));
    }

    public static void main(String[] stringArray) {
        Object object = "01234567890123456789012345678901234567890123456789012345678901234567890123456789";
        object = (String)object + "\n";
        object = (String)object + "0         1         2         3         4         5         6         7         ";
        OTBasicTextArea oTBasicTextArea = new OTBasicTextArea();
        oTBasicTextArea.setText((String)object);
        oTBasicTextArea.setPreferredSize(250, 100);
        JFrame jFrame = new JFrame("Test of OTTextArea");
        jFrame.setDefaultCloseOperation(3);
        jFrame.setContentPane(oTBasicTextArea);
        jFrame.pack();
        jFrame.setVisible(true);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
    }
}

