/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.guiutil.mvc.examples;

import alma.valuetypes.Angle;
import alma.valuetypes.Frequency;
import alma.valuetypes.UserAngle;
import alma.valuetypes.UserSensitivity;

public class SensitivityParameters {
    private Frequency observingFrequency;
    private UserAngle resolution;
    private UserSensitivity sensitivity;

    public Frequency getObservingFrequency() {
        if (this.observingFrequency == null) {
            this.observingFrequency = Frequency.createFrequency();
            this.getSensitivity().setObservingFrequency(this.observingFrequency);
        }
        return this.observingFrequency;
    }

    public void setObservingFrequency(Frequency frequency) {
        this.observingFrequency = frequency;
        this.getResolution().setObservingFrequency(frequency);
        this.getSensitivity().setObservingFrequency(frequency);
    }

    public UserAngle getResolution() {
        if (this.resolution == null) {
            this.resolution = UserAngle.createUserAngle();
            this.resolution.setUnit(UserAngle.UNIT_ARCSEC);
            this.resolution.setObservingFrequency(this.getObservingFrequency());
            this.getSensitivity().setBeamsize((Angle)((Object)this.resolution));
        }
        return this.resolution;
    }

    public void setResolution(UserAngle userAngle) {
        this.resolution = userAngle;
        this.getSensitivity().setBeamsize((Angle)((Object)userAngle));
    }

    public UserSensitivity getSensitivity() {
        if (this.sensitivity == null) {
            this.sensitivity = UserSensitivity.createUserSensitivity();
        }
        return this.sensitivity;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getClass().getSimpleName() + "@" + this.hashCode()).append("\n\t");
        stringBuilder.append((Object)this.observingFrequency).append(",\n\t");
        stringBuilder.append(this.resolution).append(",\n\t");
        stringBuilder.append(this.sensitivity);
        return stringBuilder.toString();
    }
}

