/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.guiutil.mvc.examples;

import alma.obsprep.bo.enumerations.Antenna;
import alma.obsprep.guiutil.mvc.Editor;
import alma.obsprep.guiutil.mvc.FieldID;
import alma.obsprep.guiutil.mvc.Model;
import alma.obsprep.guiutil.mvc.ModelChangeSubscriber;
import alma.obsprep.guiutil.mvc.examples.SensitivityEditor;
import alma.obsprep.guiutil.mvc.examples.SensitivityParameters;
import alma.obsprep.ot.models.valuetypes.SensitivityFormModel;
import alma.obsprep.ot.models.valuetypes.UserUnitValueUnitPairModel;
import alma.obsprep.ot.models.valuetypes.ValueUnitPairModel;

public class SensitivityModel
extends Model {
    private ValueUnitPairModel frequencyModel = new ValueUnitPairModel(null);
    private UserUnitValueUnitPairModel resolutionModel = new UserUnitValueUnitPairModel(null);
    private UserUnitValueUnitPairModel sensitivityModel = new SensitivityFormModel(null);

    public SensitivityModel(Object object) {
        super(object);
        this.registerSubModel(this.frequencyModel);
        this.registerSubModel(this.resolutionModel);
        this.registerSubModel(this.sensitivityModel);
        ModelChangeSubscriber modelChangeSubscriber = new ModelChangeSubscriber(){

            @Override
            public void modelChanged(Model model, FieldID fieldID, Object object) {
                if (model == SensitivityModel.this.frequencyModel) {
                    SensitivityModel.this.publish(SensitivityEditor.BEAMSIZE_FID, (Object)Antenna.ANTENNA_12M.getBeamSize(SensitivityModel.this.getParams().getObservingFrequency()));
                    SensitivityModel.this.sensitivityModel.publish();
                    return;
                }
                if (model == SensitivityModel.this.resolutionModel) {
                    SensitivityModel.this.sensitivityModel.publish();
                }
            }
        };
        this.frequencyModel.subscribe(modelChangeSubscriber);
        this.resolutionModel.subscribe(modelChangeSubscriber);
    }

    private SensitivityParameters getParams() {
        return (SensitivityParameters)this.getDocument();
    }

    public ValueUnitPairModel getFrequencyModel() {
        return this.frequencyModel;
    }

    public UserUnitValueUnitPairModel getResolutionModel() {
        return this.resolutionModel;
    }

    public UserUnitValueUnitPairModel getSensitivityModel() {
        return this.sensitivityModel;
    }

    public ValueUnitPairModel getFeedbackModel() {
        return ((SensitivityFormModel)this.sensitivityModel).getFeedbackModel();
    }

    @Override
    public void publish() {
        this.frequencyModel.publish();
        this.resolutionModel.publish();
        this.sensitivityModel.publish();
    }

    @Override
    public Object update(Editor editor, FieldID fieldID, Object object) {
        return object;
    }

    @Override
    public void setDocument(Object object) {
        this.document = object;
        SensitivityParameters sensitivityParameters = this.getParams();
        if (sensitivityParameters != null) {
            this.frequencyModel.setDocument((Object)sensitivityParameters.getObservingFrequency());
            this.resolutionModel.setDocument(sensitivityParameters.getResolution());
            this.sensitivityModel.setDocument(sensitivityParameters.getSensitivity());
        }
        this.publish();
    }
}

