/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.guiutil.mvc.examples;

import alma.obsprep.guiutil.mvc.examples.Book;
import alma.obsprep.guiutil.mvc.examples.Library;
import alma.obsprep.guiutil.mvc.examples.LibraryModel;
import alma.obsprep.guiutil.mvc.examples.LibraryNodeRenderer;
import alma.obsprep.guiutil.mvc.examples.LibraryTreeMouseListener;
import alma.obsprep.guiutil.mvc.examples.LibraryTreeSelectionListener;
import alma.obsprep.guiutil.mvc.examples.LibraryTreeTransferHandler;
import alma.obsprep.guiutil.mvc.examples.Shelf;
import java.awt.GridLayout;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class LibraryTree
extends JPanel {
    private Library library;
    private JTree tree;
    private DefaultTreeModel model;
    private DefaultMutableTreeNode top;
    private boolean dndPending = false;
    private JPopupMenu popup;

    public LibraryTree(LibraryModel libraryModel) {
        this.library = (Library)libraryModel.getDocument();
        this.tree = this.makeTree(this.library);
        this.tree.setDragEnabled(true);
        this.tree.setTransferHandler(new LibraryTreeTransferHandler(this));
        JScrollPane jScrollPane = new JScrollPane(this.tree);
        this.setLayout(new GridLayout(1, 0));
        this.add(jScrollPane);
    }

    private JTree makeTree(Library library) {
        JTree jTree = null;
        this.top = new DefaultMutableTreeNode(library);
        this.model = new DefaultTreeModel(this.top);
        LibraryNodeRenderer libraryNodeRenderer = new LibraryNodeRenderer();
        LibraryTreeSelectionListener libraryTreeSelectionListener = new LibraryTreeSelectionListener(this);
        Shelf[] shelfArray = library.getShelves();
        for (int i = 0; i < shelfArray.length; ++i) {
            Shelf shelf = shelfArray[i];
            if (shelf == null) continue;
            DefaultMutableTreeNode defaultMutableTreeNode = this.makeShelfNode(shelf);
            this.top.add(defaultMutableTreeNode);
        }
        jTree = new JTree(this.model);
        jTree.setEditable(false);
        jTree.getSelectionModel().setSelectionMode(1);
        jTree.setShowsRootHandles(true);
        jTree.addTreeSelectionListener(libraryTreeSelectionListener);
        jTree.setCellRenderer(libraryNodeRenderer);
        return jTree;
    }

    private DefaultMutableTreeNode makeShelfNode(Shelf shelf) {
        Object var2_2 = null;
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(shelf);
        Book[] bookArray = shelf.getBooks();
        for (int i = 0; i < bookArray.length; ++i) {
            Book book = bookArray[i];
            if (book == null) continue;
            DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(book);
            defaultMutableTreeNode.add(defaultMutableTreeNode2);
        }
        return defaultMutableTreeNode;
    }

    public void scrollTo(TreeNode treeNode) {
        TreePath treePath = new TreePath(treeNode);
        this.tree.scrollPathToVisible(treePath);
    }

    public void refresh(TreeNode treeNode) {
        this.model.reload(treeNode);
    }

    public void makeVisible(TreePath treePath) {
        this.tree.makeVisible(treePath);
    }

    public void select(TreePath treePath) {
        this.tree.clearSelection();
        this.tree.addSelectionPath(treePath);
    }

    public boolean isDndPending() {
        return this.dndPending;
    }

    public void setDndPending(boolean bl) {
        this.dndPending = bl;
    }

    public void setPopup(JPopupMenu jPopupMenu) {
        this.popup = jPopupMenu;
        if (jPopupMenu != null) {
            LibraryTreeMouseListener libraryTreeMouseListener = new LibraryTreeMouseListener(jPopupMenu);
            this.tree.addMouseListener(libraryTreeMouseListener);
        }
    }
}

