/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.guiutil.mvc.examples;

import alma.obsprep.bo.enumerations.Antenna;
import alma.valuetypes.Angle;
import alma.valuetypes.Frequency;
import alma.valuetypes.UserAngle;

public class FieldScaleParameters {
    private Antenna antenna = Antenna.ANTENNA_12M;
    private Frequency observingFrequency;
    private UserAngle resolution;
    private Angle largestScale;
    public static final String[] largestScaleUnitList = new String[]{Angle.UNIT_ARCSEC, Angle.UNIT_ARCMIN, Angle.UNIT_DEG};

    public Antenna getAntenna() {
        return this.antenna;
    }

    public void setAntenna(Antenna antenna) {
        this.antenna = antenna;
        this.getResolution().setAntenna(antenna);
    }

    public Frequency getObservingFrequency() {
        if (this.observingFrequency == null) {
            this.observingFrequency = Frequency.createFrequency();
        }
        return this.observingFrequency;
    }

    public void setObservingFrequency(Frequency frequency) {
        this.observingFrequency = frequency;
        this.getResolution().setObservingFrequency(frequency);
    }

    public UserAngle getResolution() {
        if (this.resolution == null) {
            this.resolution = UserAngle.createUserAngle();
            this.resolution.setUserUnitList(new String[]{Angle.UNIT_ARCSEC, UserAngle.USERUNIT_FRACTION_OF_MAIN_BEAM});
            this.resolution.setObservingFrequency(this.getObservingFrequency());
        }
        return this.resolution;
    }

    public Angle getLargestScale() {
        if (this.largestScale == null) {
            this.largestScale = Angle.createAngle();
        }
        return this.largestScale;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getClass().getSimpleName() + "@" + this.hashCode());
        stringBuilder.append("\n\t");
        stringBuilder.append((Object)this.antenna);
        stringBuilder.append(",\n\t ");
        stringBuilder.append((Object)this.observingFrequency);
        stringBuilder.append(",\n\t ");
        stringBuilder.append(this.resolution);
        stringBuilder.append(",\n\t ");
        stringBuilder.append((Object)this.largestScale);
        return stringBuilder.toString();
    }
}

