/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.guiutil.mvc.examples;

import alma.hla.runtime.obsprep.bo.ValueUnitPair;
import alma.hla.runtime.obsprep.util.Log;
import alma.obsprep.bo.TestUtilities;
import alma.obsprep.bo.enumerations.Antenna;
import alma.obsprep.guiutil.mvc.Editor;
import alma.obsprep.guiutil.mvc.FieldID;
import alma.obsprep.guiutil.mvc.Model;
import alma.obsprep.guiutil.mvc.examples.FieldScaleModel;
import alma.obsprep.guiutil.mvc.examples.FieldScaleParameters;
import alma.obsprep.ot.editors.valuetypes.UserUnitValueUnitPairEditor;
import alma.obsprep.ot.editors.valuetypes.ValueUnitPairEditor;
import alma.obsprep.util.LogLoggerProviderImpl;
import alma.obsprep.util.TextUtils;
import alma.obsprep.util.UnitMapConfigurator;
import alma.valuetypes.Frequency;
import alma.valuetypes.UserAngle;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JTextField;

public class FieldScaleEditor
extends Editor {
    public static final FieldID ANTENNA_FID = new FieldID("FieldScale.antenna");
    public static final FieldID BEAMSIZE_FID = new FieldID("FieldScale.beamsize");
    public static final FieldID FREQUENCY_VUPFID = new FieldID("FieldScale.frequency");
    public static final FieldID RESOLUTION_VUPFID = new FieldID("FieldScale.resolution");
    public static final FieldID LARGESTSCALE_VUPFID = new FieldID("FieldScale.largestScale");

    public FieldScaleEditor(Model model) {
        this.setModel(model);
        this.build();
        model.publish();
    }

    @Override
    public FieldScaleModel getModel() {
        return (FieldScaleModel)super.getModel();
    }

    @Override
    protected void build() {
        FieldScaleModel fieldScaleModel = this.getModel();
        JLabel jLabel = new JLabel("Antenna");
        JComboBox<String> jComboBox = new JComboBox<String>(Antenna.getLabels());
        this.initEvents(jComboBox, ANTENNA_FID);
        this.addLabeledWidget(jLabel, jComboBox);
        jLabel = new JLabel("Observing Frequency");
        ValueUnitPairEditor valueUnitPairEditor = new ValueUnitPairEditor(fieldScaleModel.getFrequencyModel());
        this.register(valueUnitPairEditor, FREQUENCY_VUPFID);
        this.addLabeledWidget(jLabel, valueUnitPairEditor);
        jLabel = new JLabel("Beamsize");
        JTextField jTextField = new JTextField();
        jTextField.setEditable(false);
        this.register(jTextField, BEAMSIZE_FID);
        this.addLabeledWidget(jLabel, jTextField);
        jLabel = new JLabel("Resolution");
        valueUnitPairEditor = new UserUnitValueUnitPairEditor(fieldScaleModel.getResolutionModel());
        this.register(valueUnitPairEditor, RESOLUTION_VUPFID);
        this.addLabeledWidget(jLabel, valueUnitPairEditor);
        jLabel = new JLabel("Largest Scale");
        valueUnitPairEditor = new ValueUnitPairEditor(fieldScaleModel.getLargestScaleModel());
        this.register(valueUnitPairEditor, LARGESTSCALE_VUPFID);
        this.addLabeledWidget(jLabel, valueUnitPairEditor);
        this.layoutLabeledWidgets();
    }

    @Override
    public void update(FieldID fieldID, Object object) {
        if (fieldID == BEAMSIZE_FID) {
            ValueUnitPair valueUnitPair = (ValueUnitPair)object;
            super.update(fieldID, TextUtils.format(valueUnitPair));
            return;
        }
        super.update(fieldID, object);
    }

    public static void main(String[] stringArray) {
        Log.setRuntimeImplementation((Log.LoggerProvider)new LogLoggerProviderImpl());
        UnitMapConfigurator.configureUnitMaps();
        FieldScaleModel fieldScaleModel = new FieldScaleModel(null);
        FieldScaleEditor fieldScaleEditor = new FieldScaleEditor(fieldScaleModel);
        FieldScaleParameters fieldScaleParameters = new FieldScaleParameters();
        fieldScaleParameters.setObservingFrequency(Frequency.createFrequencyGHZ(100.0));
        fieldScaleParameters.getResolution().setContent(1.0);
        fieldScaleParameters.getResolution().setUnit(UserAngle.USERUNIT_FRACTION_OF_MAIN_BEAM);
        fieldScaleParameters.getResolution().setContent(51.530528);
        fieldScaleParameters.getResolution().setUnit(UserAngle.USERUNIT_ARCSEC);
        fieldScaleParameters.getResolution().setContent(51.530528);
        fieldScaleParameters.getResolution().setUnit(UserAngle.USERUNIT_ARCSEC);
        fieldScaleParameters.getLargestScale().setContent(120.0);
        fieldScaleParameters.getLargestScale().setUnit(UserAngle.USERUNIT_ARCSEC);
        fieldScaleParameters.getLargestScale().setContent(2.0);
        fieldScaleParameters.getLargestScale().setUnit(UserAngle.USERUNIT_ARCMIN);
        fieldScaleModel.setDocument(fieldScaleParameters);
        TestUtilities.runTestApp(fieldScaleEditor);
    }
}

