/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.guiutil.jsky.image.graphics.gui;

import alma.obsprep.guiutil.jsky.image.graphics.AlmaDivaImageGraphics;
import alma.obsprep.guiutil.jsky.image.graphics.AlmaRoiRectangle;
import alma.obsprep.ot.editors.spatialvisual.mapper.FovFigure;
import diva.canvas.AbstractFigure;
import diva.canvas.interactor.Interactor;
import diva.canvas.interactor.SelectionModel;
import diva.util.java2d.Polygon2D;
import diva.util.java2d.Polyline2D;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import jsky.graphics.CanvasFigure;
import jsky.image.graphics.RoiFigure;
import jsky.image.graphics.gui.CanvasDraw;
import jsky.image.gui.DivaMainImageDisplay;
import jsky.util.I18N;
import jsky.util.gui.DialogUtil;

public class AlmaCanvasDraw
extends CanvasDraw {
    private static final I18N _I18N = I18N.getInstance(AlmaCanvasDraw.class);
    protected DivaMainImageDisplay imageDisplay;
    protected AlmaDivaImageGraphics graphics;
    private boolean roiDrawing = false;
    protected RoiFigure roi = null;

    public AlmaCanvasDraw(DivaMainImageDisplay divaMainImageDisplay) {
        super(divaMainImageDisplay);
        this.graphics = (AlmaDivaImageGraphics)divaMainImageDisplay.getCanvasGraphics();
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        switch (this.drawingMode) {
            case 5: {
                if (this.polyline != null) {
                    this.polyline = (Polyline2D.Double)this.figure.getShape();
                    break;
                }
                if (this.startX == mouseEvent.getX() && this.startY == mouseEvent.getY()) break;
                this.finishFigure();
                break;
            }
            case 6: {
                if (this.polygon != null) {
                    this.polygon = (Polygon2D.Double)this.figure.getShape();
                    break;
                }
                if (this.startX == mouseEvent.getX() && this.startY == mouseEvent.getY()) break;
                this.finishFigure();
                break;
            }
            case 8: {
                Point2D.Double double_ = new Point2D.Double(this.startX, this.startY);
                String string = DialogUtil.input((String)_I18N.getString("pleaseEnterLabelText"));
                if (string == null || string.length() == 0) break;
                this.figure = (AbstractFigure)this.graphics.makeLabel(double_, string, this.outline, this.font);
                this.addFigure((CanvasFigure)this.figure);
                this.finishFigure();
                return;
            }
            default: {
                if (this.startX == mouseEvent.getX() && this.startY == mouseEvent.getY()) break;
                this.finishFigure();
            }
        }
    }

    protected void finishFigure() {
        if (this.figure != null) {
            if (this.isRoiDrawing()) {
                this.setRoiDrawing(false);
                switch (this.drawingMode) {
                    case 3: {
                        this.roi = new AlmaRoiRectangle(this.figure.getBounds());
                        this.roi.setInteractor((Interactor)this.graphics.getRoiSelectionInteractor());
                        this.addFigure((CanvasFigure)this.roi);
                        this.graphics.remove((CanvasFigure)this.figure);
                        this.getFigureList().remove(this.figure);
                        this.graphics.clearSelection();
                        this.graphics.select((CanvasFigure)this.roi);
                        this.figure = null;
                        break;
                    }
                    case 4: {
                        this.graphics.clearSelection();
                        this.graphics.select((CanvasFigure)this.figure);
                        this.figure = null;
                        break;
                    }
                }
            } else {
                this.graphics.clearSelection();
                this.graphics.select((CanvasFigure)this.figure);
                this.figure = null;
                this.roi = null;
            }
        } else {
            this.roi = null;
        }
        this.polyline = null;
        this.polygon = null;
        this.freehand = null;
        this.setDrawingMode(0);
        this.mouseClicked = false;
    }

    public void setRoiDrawing(boolean bl) {
        this.roiDrawing = bl;
    }

    public boolean isRoiDrawing() {
        return this.roiDrawing;
    }

    public void setRoiFigure(RoiFigure roiFigure) {
        this.roi = roiFigure;
    }

    public RoiFigure getRoiFigure() {
        return this.roi;
    }

    private List<CanvasFigure> getSelectedFigureList(String string) {
        SelectionModel selectionModel = this.graphics.getSelectionInteractor().getSelectionModel();
        ListIterator listIterator = this.figureList.listIterator(0);
        ArrayList<CanvasFigure> arrayList = new ArrayList<CanvasFigure>();
        while (listIterator.hasNext()) {
            CanvasFigure canvasFigure = (CanvasFigure)listIterator.next();
            if (!selectionModel.containsSelection((Object)canvasFigure)) continue;
            boolean bl = false;
            if (string.equals("ROI")) {
                bl = canvasFigure instanceof RoiFigure;
            } else if (string.equals("FOV")) {
                bl = canvasFigure instanceof FovFigure;
            }
            if (!bl) continue;
            arrayList.add(canvasFigure);
        }
        return arrayList;
    }

    public List<CanvasFigure> getSelectedFovList() {
        return this.getSelectedFigureList("FOV");
    }

    public List<CanvasFigure> getSelectedRoiList() {
        return this.getSelectedFigureList("ROI");
    }

    public void addFigure(CanvasFigure canvasFigure) {
        this.figureList.add(canvasFigure);
        this.graphics.add(canvasFigure);
    }

    public void deleteFigure(CanvasFigure canvasFigure) {
        this.figureList.remove(canvasFigure);
        this.graphics.remove(canvasFigure);
    }
}

