/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.guiutil.jsky.image.graphics;

import alma.obsprep.ot.editors.spatialvisual.SelectionDraggerListener;
import diva.canvas.CanvasLayer;
import diva.canvas.Figure;
import diva.canvas.FigureDecorator;
import diva.canvas.FigureLayer;
import diva.canvas.GraphicsPane;
import diva.canvas.Site;
import diva.canvas.event.LayerAdapter;
import diva.canvas.event.LayerEvent;
import diva.canvas.event.LayerListener;
import diva.canvas.event.MouseFilter;
import diva.canvas.interactor.BoundsManipulator;
import diva.canvas.interactor.DragInteractor;
import diva.canvas.interactor.GrabHandle;
import diva.canvas.interactor.GrabHandleFactory;
import diva.canvas.interactor.Interactor;
import diva.canvas.interactor.PathManipulator;
import diva.canvas.interactor.SelectionEvent;
import diva.canvas.interactor.SelectionInteractor;
import diva.canvas.interactor.SelectionListener;
import diva.canvas.interactor.SelectionModel;
import diva.canvas.toolbox.BasicFigure;
import diva.canvas.toolbox.BasicHighlighter;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import javax.swing.SwingUtilities;
import jsky.coords.CoordinateConverter;
import jsky.graphics.CanvasFigure;
import jsky.graphics.CanvasFigureGroup;
import jsky.graphics.SelectedAreaListener;
import jsky.image.graphics.DivaImageGraphics;
import jsky.image.graphics.ImageFigure;
import jsky.image.graphics.ImageFigureGroup;
import jsky.image.graphics.ImageLabel;
import jsky.image.graphics.ImageLayer;
import jsky.image.graphics.LabeledImageFigure;
import jsky.image.graphics.RectangleGrabHandle;
import jsky.image.graphics.RectangleGrabHandleFactory;
import jsky.image.graphics.RectangleManipulator;
import jsky.image.graphics.RoiEllipse;
import jsky.image.graphics.RoiFigure;
import jsky.image.graphics.RoiRectangle;
import jsky.image.graphics.RotatableCanvasFigure;
import jsky.image.graphics.SelectionDragger;
import jsky.image.gui.DivaGraphicsImageDisplay;
import jsky.image.gui.GraphicsImageDisplay;

public class AlmaDivaImageGraphics
extends DivaImageGraphics {
    private GraphicsImageDisplay _imageDisplay;
    private GraphicsPane _graphicsPane;
    private FigureLayer _figureLayer;
    private ImageLayer _imageLayer;
    private SelectionInteractor _selectionInteractor;
    private SelectionInteractor _roiSelectionInteractor;
    private SelectionInteractor _lineInteractor;
    private DragInteractor _dragInteractor;
    private SelectionInteractor _fixedSelectionInteractor;
    private SelectionInteractor _draggableSelectionInteractor;
    private SelectionListener _selectionListener;
    private SelectionDragger _selectionDragger;
    private Set<CanvasFigure> _selectedSet;
    private Vector<SelectionDraggerListener> selectionDraggerListeners = new Vector();

    public AlmaDivaImageGraphics(DivaGraphicsImageDisplay divaGraphicsImageDisplay) {
        super(divaGraphicsImageDisplay);
        this._imageDisplay = divaGraphicsImageDisplay;
        this._imageLayer = this._makeImageLayer();
    }

    public void setGraphicsPane(GraphicsPane graphicsPane) {
        this._graphicsPane = graphicsPane;
        this._graphicsPane.setAntialiasing(false);
        this._imageLayer = this._makeImageLayer();
        this._graphicsPane.setBackgroundLayer((CanvasLayer)this._imageLayer);
        this._figureLayer = this._graphicsPane.getForegroundLayer();
        this._graphicsPane.getBackgroundEventLayer().addLayerListener((LayerListener)new LayerAdapter(){

            public void mousePressed(LayerEvent layerEvent) {
                AlmaDivaImageGraphics.this.clearSelection();
            }
        });
        this._selectedSet = new HashSet<CanvasFigure>();
        this._makeSelectionListener();
        this._makeDragInteractor();
        this._makeSelectionInteractor();
        this._makeRoiSelectionInteractor();
        this._makeDraggableSelectionInteractor();
        this._makeLineInteractor();
        this._makeFixedSelectionInteractor();
        this._makeSelectionDragger();
    }

    public GraphicsPane getGraphicsPane() {
        return this._graphicsPane;
    }

    private ImageLayer _makeImageLayer() {
        return new ImageLayer((DivaGraphicsImageDisplay)this._imageDisplay);
    }

    public ImageLayer getImageLayer() {
        return this._imageLayer;
    }

    private void _makeSelectionInteractor() {
        BoundsManipulator boundsManipulator = new BoundsManipulator();
        boundsManipulator.getHandleInteractor().addLayerListener((LayerListener)new LayerAdapter(this){

            public void mouseReleased(LayerEvent layerEvent) {
                Figure figure = layerEvent.getFigureSource();
                if (figure instanceof CanvasFigure) {
                    ((CanvasFigure)figure).fireCanvasFigureEvent(2);
                }
            }
        });
        this._selectionInteractor = new SelectionInteractor();
        this._selectionInteractor.setPrototypeDecorator((FigureDecorator)boundsManipulator);
        this._selectionInteractor.getSelectionModel().addSelectionListener(this._selectionListener);
        this._selectionInteractor.addInteractor((Interactor)this._dragInteractor);
    }

    private void _makeDraggableSelectionInteractor() {
        this._draggableSelectionInteractor = new SelectionInteractor(this._selectionInteractor.getSelectionModel());
        this._draggableSelectionInteractor.getSelectionModel().addSelectionListener(this._selectionListener);
        this._draggableSelectionInteractor.setToggleFilter(new MouseFilter(1, 2));
        this._draggableSelectionInteractor.addInteractor((Interactor)this._dragInteractor);
        AlphaComposite alphaComposite = AlphaComposite.getInstance(3, 0.4f);
        BasicHighlighter basicHighlighter = new BasicHighlighter((Paint)new Color(204, 204, 255), 1.0f, (Composite)alphaComposite);
        this._draggableSelectionInteractor.setPrototypeDecorator((FigureDecorator)basicHighlighter);
    }

    private void _makeRoiSelectionInteractor() {
        RectangleGrabHandleFactory rectangleGrabHandleFactory = new RectangleGrabHandleFactory(this){

            public GrabHandle createGrabHandle(Site site) {
                if (site.getID() == 0) {
                    return new RectangleGrabHandle(site, new Color(0, 127, 0));
                }
                return super.createGrabHandle(site);
            }
        };
        RectangleManipulator rectangleManipulator = new RectangleManipulator((GrabHandleFactory)rectangleGrabHandleFactory);
        rectangleManipulator.getHandleInteractor().addLayerListener((LayerListener)new LayerAdapter(this){

            public void mouseReleased(LayerEvent layerEvent) {
                Figure figure = layerEvent.getFigureSource();
                if (figure instanceof RectangleGrabHandle) {
                    Site site = ((RectangleGrabHandle)figure).getSite();
                    CanvasFigure canvasFigure = (CanvasFigure)site.getFigure();
                    if (site.getID() == 0) {
                        canvasFigure.fireCanvasFigureEvent(4);
                    } else {
                        canvasFigure.fireCanvasFigureEvent(2);
                    }
                }
            }
        });
        this._roiSelectionInteractor = new SelectionInteractor();
        this._roiSelectionInteractor.setPrototypeDecorator((FigureDecorator)rectangleManipulator);
        this._roiSelectionInteractor.setSelectionModel(this._selectionInteractor.getSelectionModel());
        this._roiSelectionInteractor.addInteractor((Interactor)this._dragInteractor);
    }

    private void _makeLineInteractor() {
        PathManipulator pathManipulator = new PathManipulator();
        pathManipulator.getHandleInteractor().addLayerListener((LayerListener)new LayerAdapter(this){

            public void mouseReleased(LayerEvent layerEvent) {
                Figure figure = layerEvent.getFigureSource();
                if (figure instanceof CanvasFigure) {
                    ((CanvasFigure)figure).fireCanvasFigureEvent(2);
                }
            }
        });
        this._lineInteractor = new SelectionInteractor(this._selectionInteractor.getSelectionModel());
        this._lineInteractor.setPrototypeDecorator((FigureDecorator)pathManipulator);
        this._lineInteractor.getSelectionModel().addSelectionListener(this._selectionListener);
        this._lineInteractor.addInteractor((Interactor)this._dragInteractor);
    }

    private void _makeSelectionListener() {
        this._selectionListener = new SelectionListener(){

            public void selectionChanged(SelectionEvent selectionEvent) {
                CanvasFigure canvasFigure;
                Object e;
                Iterator iterator;
                try {
                    iterator = selectionEvent.getSelectionAdditions();
                    while (iterator.hasNext()) {
                        e = iterator.next();
                        if (!(e instanceof CanvasFigure)) continue;
                        canvasFigure = (CanvasFigure)e;
                        AlmaDivaImageGraphics.this._selectedSet.add(canvasFigure);
                        canvasFigure.fireCanvasFigureEvent(0);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    iterator = selectionEvent.getSelectionRemovals();
                    while (iterator.hasNext()) {
                        e = iterator.next();
                        if (!(e instanceof CanvasFigure)) continue;
                        canvasFigure = (CanvasFigure)e;
                        AlmaDivaImageGraphics.this._selectedSet.remove(canvasFigure);
                        ((CanvasFigure)e).fireCanvasFigureEvent(1);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        };
    }

    public List<CanvasFigure> getSelectedFigures() {
        return new ArrayList<CanvasFigure>(this._selectedSet);
    }

    private void _makeDragInteractor() {
        this._dragInteractor = new DragInteractor();
        this._dragInteractor.addLayerListener((LayerListener)new LayerAdapter(this){

            public void mouseReleased(LayerEvent layerEvent) {
                Figure figure = layerEvent.getFigureSource();
                if (figure instanceof CanvasFigure) {
                    ((CanvasFigure)figure).fireCanvasFigureEvent(3);
                }
            }
        });
    }

    private void _makeFixedSelectionInteractor() {
        SelectionModel selectionModel = this._selectionInteractor.getSelectionModel();
        this._fixedSelectionInteractor = new SelectionInteractor(selectionModel);
        AlphaComposite alphaComposite = AlphaComposite.getInstance(3, 0.75f);
        BasicHighlighter basicHighlighter = new BasicHighlighter((Paint)new Color(204, 204, 255), 1.0f, (Composite)alphaComposite);
        this._fixedSelectionInteractor.setPrototypeDecorator((FigureDecorator)basicHighlighter);
    }

    private void _makeSelectionDragger() {
        this._selectionDragger = new SelectionDragger(this._graphicsPane){

            public void mouseReleased(LayerEvent layerEvent) {
                super.mouseReleased(layerEvent);
                AlmaDivaImageGraphics.this.selectionDraggerSelectionFinished();
                this.setEnabled(false);
            }
        };
        this._selectionDragger.addSelectionInteractor(this._selectionInteractor);
        this._selectionDragger.addSelectionInteractor(this._lineInteractor);
        this._selectionDragger.addSelectionInteractor(this._draggableSelectionInteractor);
        this._selectionDragger.addSelectionInteractor(this._fixedSelectionInteractor);
        this._selectionDragger.setEnabled(false);
    }

    public SelectionDragger getSelectionDragger() {
        return this._selectionDragger;
    }

    public DragInteractor getDragInteractor() {
        return this._dragInteractor;
    }

    public SelectionInteractor getSelectionInteractor() {
        return this._selectionInteractor;
    }

    public SelectionInteractor getRoiSelectionInteractor() {
        return this._roiSelectionInteractor;
    }

    public SelectionInteractor getDraggableSelectionInteractor() {
        return this._draggableSelectionInteractor;
    }

    public SelectionInteractor getLineInteractor() {
        return this._lineInteractor;
    }

    public SelectionInteractor getFixedSelectionInteractor() {
        return this._fixedSelectionInteractor;
    }

    public CanvasFigure makeLabeledFigure(Shape shape, Paint paint, Paint paint2, float f, String string, int n, Paint paint3, Font font, Interactor interactor) {
        if (string == null || string.length() == 0) {
            return new ImageFigure(shape, paint, paint2, f, interactor);
        }
        return new LabeledImageFigure((Figure)new ImageFigure(shape, paint, paint2, f, null), string, n, paint3, font, interactor);
    }

    public CanvasFigure makeFigure(Shape shape, Paint paint, Paint paint2, float f, Composite composite, Interactor interactor) {
        RotatableCanvasFigure rotatableCanvasFigure = this.makeFigure(shape, paint, paint2, f, interactor);
        if (composite != null && rotatableCanvasFigure instanceof BasicFigure) {
            ((BasicFigure)rotatableCanvasFigure).setComposite((AlphaComposite)composite);
        }
        return rotatableCanvasFigure;
    }

    public RotatableCanvasFigure makeFigure(Shape shape, Paint paint, Paint paint2, float f, Interactor interactor) {
        if (shape instanceof Rectangle2D.Double) {
            RotatableCanvasFigure rotatableCanvasFigure = this.makeRoiRectangle((Rectangle2D.Double)shape, paint, paint2, f);
            rotatableCanvasFigure.setInteractor(interactor);
            return rotatableCanvasFigure;
        }
        if (shape instanceof Ellipse2D.Double) {
            RotatableCanvasFigure rotatableCanvasFigure = this.makeRoiEllipse((Ellipse2D.Double)shape, paint, paint2, f);
            rotatableCanvasFigure.setInteractor(interactor);
            return rotatableCanvasFigure;
        }
        return new RoiFigure(shape, paint, paint2, f, interactor);
    }

    public CanvasFigure makeLabeledFigure(Shape shape, Paint paint, Paint paint2, float f, String string, int n, Paint paint3, Font font) {
        return this.makeLabeledFigure(shape, paint, paint2, f, string, n, paint3, font, (Interactor)this._fixedSelectionInteractor);
    }

    public CanvasFigure makeFigure(Shape shape, Paint paint, Paint paint2, float f) {
        return this.makeFigure(shape, paint, paint2, f, (Interactor)this._fixedSelectionInteractor);
    }

    public CanvasFigure makeLabeledRectangle(Rectangle2D.Double double_, int n, Paint paint, Paint paint2, float f, String string, int n2, Paint paint3, Font font, Interactor interactor) {
        CoordinateConverter coordinateConverter = this._imageDisplay.getCoordinateConverter();
        Point2D.Double double_2 = new Point2D.Double(double_.x, double_.y);
        coordinateConverter.convertCoords(double_2, n, 1, false);
        Point2D.Double double_3 = new Point2D.Double(double_.width, double_.height);
        coordinateConverter.convertCoords(double_3, n, 1, true);
        Rectangle2D.Double double_4 = new Rectangle2D.Double(double_2.x, double_2.y, double_3.x, double_3.y);
        return this.makeLabeledFigure(double_4, paint, paint2, f, string, n2, paint3, font, interactor);
    }

    public CanvasFigure makeRectangle(Rectangle2D.Double double_, int n, Paint paint, Paint paint2, float f, Interactor interactor) {
        CoordinateConverter coordinateConverter = this._imageDisplay.getCoordinateConverter();
        Point2D.Double double_2 = new Point2D.Double(double_.x, double_.y);
        coordinateConverter.convertCoords(double_2, n, 1, false);
        Point2D.Double double_3 = new Point2D.Double(double_.width, double_.height);
        coordinateConverter.convertCoords(double_3, n, 1, true);
        Rectangle2D.Double double_4 = new Rectangle2D.Double(double_2.x, double_2.y, double_3.x, double_3.y);
        return this.makeFigure(double_4, paint, paint2, f, interactor);
    }

    public RotatableCanvasFigure makeRoiRectangle(Rectangle2D.Double double_, Paint paint, Paint paint2, float f) {
        return this.makeRoiRectangle(double_, 1, paint, paint2, f);
    }

    public RotatableCanvasFigure makeRoiRectangle(Rectangle2D.Double double_, int n, Paint paint, Paint paint2, float f) {
        CoordinateConverter coordinateConverter = this._imageDisplay.getCoordinateConverter();
        Point2D.Double double_2 = new Point2D.Double(double_.x, double_.y);
        coordinateConverter.convertCoords(double_2, n, 1, false);
        Point2D.Double double_3 = new Point2D.Double(double_.width, double_.height);
        coordinateConverter.convertCoords(double_3, n, 1, true);
        Rectangle2D.Double double_4 = new Rectangle2D.Double(double_2.x, double_2.y, double_3.x, double_3.y);
        return new RoiRectangle((RectangularShape)double_4, paint, paint2, f, (Interactor)this._roiSelectionInteractor);
    }

    public RotatableCanvasFigure makeRoiEllipse(Ellipse2D.Double double_, Paint paint, Paint paint2, float f) {
        return this.makeRoiEllipse(double_, 1, paint, paint2, f);
    }

    public RotatableCanvasFigure makeRoiEllipse(Ellipse2D.Double double_, int n, Paint paint, Paint paint2, float f) {
        CoordinateConverter coordinateConverter = this._imageDisplay.getCoordinateConverter();
        Point2D.Double double_2 = new Point2D.Double(double_.x, double_.y);
        coordinateConverter.convertCoords(double_2, n, 1, false);
        Point2D.Double double_3 = new Point2D.Double(double_.width, double_.height);
        coordinateConverter.convertCoords(double_3, n, 1, true);
        Ellipse2D.Double double_4 = new Ellipse2D.Double(double_2.x, double_2.y, double_3.x, double_3.y);
        return new RoiEllipse((Ellipse2D)double_4, paint, paint2, f, (Interactor)this._roiSelectionInteractor);
    }

    public CanvasFigure makeLabeledEllipse(Ellipse2D.Double double_, int n, Paint paint, Paint paint2, float f, String string, int n2, Paint paint3, Font font, Interactor interactor) {
        CoordinateConverter coordinateConverter = this._imageDisplay.getCoordinateConverter();
        Point2D.Double double_2 = new Point2D.Double(double_.x, double_.y);
        coordinateConverter.convertCoords(double_2, n, 1, false);
        Point2D.Double double_3 = new Point2D.Double(double_.width, double_.height);
        coordinateConverter.convertCoords(double_3, n, 1, true);
        Ellipse2D.Double double_4 = new Ellipse2D.Double(double_2.x, double_2.y, double_3.x, double_3.y);
        return this.makeLabeledFigure(double_4, paint, paint2, f, string, n2, paint3, font, interactor);
    }

    public RotatableCanvasFigure makeEllipse(Ellipse2D.Double double_, int n, Paint paint, Paint paint2, float f, Interactor interactor) {
        CoordinateConverter coordinateConverter = this._imageDisplay.getCoordinateConverter();
        Point2D.Double double_2 = new Point2D.Double(double_.x, double_.y);
        coordinateConverter.convertCoords(double_2, n, 1, false);
        Point2D.Double double_3 = new Point2D.Double(double_.width, double_.height);
        coordinateConverter.convertCoords(double_3, n, 1, true);
        Ellipse2D.Double double_4 = new Ellipse2D.Double(double_2.x, double_2.y, double_3.x, double_3.y);
        return this.makeFigure(double_4, paint, paint2, f, interactor);
    }

    public CanvasFigure makeLabel(Point2D.Double double_, int n, String string, Paint paint, Font font, Interactor interactor) {
        CoordinateConverter coordinateConverter = this._imageDisplay.getCoordinateConverter();
        Point2D.Double double_2 = new Point2D.Double(double_.x, double_.y);
        coordinateConverter.convertCoords(double_2, n, 1, false);
        return new ImageLabel(string, double_2, paint, font, interactor);
    }

    public CanvasFigure makeLabel(Point2D.Double double_, String string, Paint paint, Font font) {
        return this.makeLabel(double_, 1, string, paint, font, null);
    }

    public CanvasFigureGroup makeFigureGroup(Interactor interactor) {
        return new ImageFigureGroup(interactor);
    }

    public CanvasFigureGroup makeFigureGroup() {
        return new ImageFigureGroup((Interactor)this._fixedSelectionInteractor);
    }

    public void add(CanvasFigure canvasFigure) {
        this._figureLayer.add((Figure)canvasFigure);
    }

    public void remove(CanvasFigure canvasFigure) {
        SelectionModel selectionModel;
        Interactor interactor = canvasFigure.getInteractor();
        if (interactor instanceof SelectionInteractor && (selectionModel = ((SelectionInteractor)interactor).getSelectionModel()).containsSelection((Object)canvasFigure)) {
            selectionModel.removeSelection((Object)canvasFigure);
        }
        this._figureLayer.remove((Figure)canvasFigure);
    }

    public void select(CanvasFigure canvasFigure) {
        Interactor interactor = canvasFigure.getInteractor();
        if (interactor instanceof SelectionInteractor) {
            ((SelectionInteractor)interactor).getSelectionModel().addSelection((Object)canvasFigure);
        }
    }

    public void deselect(CanvasFigure canvasFigure) {
        Interactor interactor = canvasFigure.getInteractor();
        if (interactor instanceof SelectionInteractor) {
            ((SelectionInteractor)interactor).getSelectionModel().removeSelection((Object)canvasFigure);
        }
    }

    public void clearSelection() {
        this._selectionInteractor.getSelectionModel().clearSelection();
        this._roiSelectionInteractor.getSelectionModel().clearSelection();
    }

    public void scheduleRemoval(CanvasFigure canvasFigure) {
        SwingUtilities.invokeLater(new FigureRemover(canvasFigure));
    }

    public int getFigureCount() {
        return this._figureLayer.getFigureCount();
    }

    public void transform(AffineTransform affineTransform) {
        this._selectionInteractor.getSelectionModel().clearSelection();
        Iterator iterator = this._figureLayer.figures();
        while (iterator.hasNext()) {
            Figure figure = (Figure)iterator.next();
            figure.transform(affineTransform);
        }
    }

    public void setInteractionMode(CanvasFigure canvasFigure, int n) {
        SelectionInteractor selectionInteractor = null;
        if ((n & 0xE) != 0) {
            n |= 1;
        }
        if (n == 1) {
            selectionInteractor = this._fixedSelectionInteractor;
        } else if (n == 3) {
            selectionInteractor = this._dragInteractor;
        } else if (n == 7) {
            selectionInteractor = this._selectionInteractor;
        }
        canvasFigure.setInteractor((Interactor)selectionInteractor);
    }

    public void selectArea(final SelectedAreaListener selectedAreaListener) {
        SelectionDragger selectionDragger = new SelectionDragger(this, this._graphicsPane){

            public void mouseReleased(LayerEvent layerEvent) {
                super.mouseReleased(layerEvent);
                this.setEnabled(false);
                Rectangle2D rectangle2D = this.getSelectedArea();
                if (rectangle2D != null) {
                    selectedAreaListener.setSelectedArea(rectangle2D);
                }
            }
        };
        selectionDragger.setEnabled(true);
    }

    public void repaint() {
        this._figureLayer.repaint();
    }

    public void repaint(Rectangle2D rectangle2D) {
        this._figureLayer.repaint(rectangle2D);
    }

    public void addSelectionDraggerListener(SelectionDraggerListener selectionDraggerListener) {
        this.selectionDraggerListeners.add(selectionDraggerListener);
    }

    public void removeSelectionDraggerListener(SelectionDraggerListener selectionDraggerListener) {
        this.selectionDraggerListeners.remove(selectionDraggerListener);
    }

    private void selectionDraggerSelectionFinished() {
        for (SelectionDraggerListener selectionDraggerListener : this.selectionDraggerListeners) {
            selectionDraggerListener.selectionDraggerSelectFinished();
        }
    }

    private class FigureRemover
    implements Runnable {
        CanvasFigure fig;

        public FigureRemover(CanvasFigure canvasFigure) {
            this.fig = canvasFigure;
        }

        @Override
        public void run() {
            AlmaDivaImageGraphics.this.remove(this.fig);
        }
    }
}

