/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.guiutil.jsky;

import alma.obsprep.util.GUIUtilities;
import alma.obsprep.util.astro.Resolver;
import alma.obsprep.util.astro.SimbadNameResolver;
import alma.obsprep.util.job.ObsprepThreadGroup;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.GridLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import java.util.List;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JTextField;
import jsky.catalog.astrocat.AstroCatConfig;
import jsky.catalog.skycat.SkycatCatalog;

public class ResolverGuiTest {
    private final Resolver resolver = new SimbadNameResolver();
    private String target = "Sombrero";
    private JLabel label;
    private final String DEF_LABEL_STRING = "Ra? Dec?                 ";
    private Container pane;
    private JComboBox comboBox;
    private JTextField tf;
    private JButton resolveButton;
    private List serverList;

    ResolverGuiTest() {
        this.buildGui();
    }

    public void mySleep(int n) throws InterruptedException {
        Thread.sleep(n);
    }

    private void buildGui() {
        Object object;
        this.tf = new JTextField(this.target);
        Box box = Box.createHorizontalBox();
        box.add(new JLabel("Name "));
        box.add(this.tf);
        ResolveCommand resolveCommand = new ResolveCommand();
        this.resolveButton = new JButton("Resolve");
        this.resolveButton.addActionListener(resolveCommand);
        JButton jButton = new JButton("Stop");
        jButton.addActionListener(resolveCommand);
        this.comboBox = new JComboBox();
        this.serverList = AstroCatConfig.getConfigFile().getNameServers();
        Iterator iterator = this.serverList.iterator();
        while (iterator.hasNext()) {
            object = ((SkycatCatalog)iterator.next()).getName();
            this.comboBox.addItem(object);
        }
        this.label = new JLabel("Ra? Dec?                 ");
        object = new JFrame("Top level");
        ((JFrame)object).setDefaultCloseOperation(3);
        this.pane = ((JFrame)object).getContentPane();
        this.pane.add(box);
        this.pane.add(this.resolveButton);
        this.pane.add(this.comboBox);
        this.pane.add(jButton);
        this.pane.add(this.label);
        GridLayout gridLayout = new GridLayout(5, 1);
        this.pane.setLayout(gridLayout);
        ((Window)object).pack();
        ((Window)object).setVisible(true);
    }

    public static void main(String[] stringArray) {
        new ResolverGuiTest();
    }

    private class ResolveCommand
    implements ActionListener {
        Thread resolveWorker;
        Thread waitWorker = null;

        private ResolveCommand() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getActionCommand() == "Stop") {
                System.out.println("NewResolverGui : Stop requested");
                if (this.waitWorker != null && this.waitWorker.isAlive()) {
                    System.out.println("waitWorker is alive! Interrupting!");
                    this.waitWorker.interrupt();
                }
            } else {
                try {
                    System.out.println("NewResolverGui : query start");
                    ResolverGuiTest.this.resolver.reset();
                    ResolverGuiTest.this.label.setText("Ra? Dec?                 ");
                    this.resolveWorker = new Thread(ObsprepThreadGroup.getInstance(), null, "ResolverGui.Resolve"){

                        @Override
                        public void run() {
                            ResolverGuiTest.this.pane.setCursor(new Cursor(3));
                            ResolverGuiTest.this.resolveButton.setEnabled(false);
                            ResolverGuiTest.this.resolver.setNameServer((String)ResolverGuiTest.this.comboBox.getSelectedItem());
                            ResolverGuiTest.this.target = ResolverGuiTest.this.tf.getText();
                            System.out.println("NewResolverGui : target = " + ResolverGuiTest.this.target);
                            try {
                                ResolverGuiTest.this.resolver.query(ResolverGuiTest.this.target);
                            }
                            catch (Exception exception) {
                                exception.printStackTrace();
                            }
                        }
                    };
                    this.resolveWorker.start();
                    this.waitWorker = new Thread(ObsprepThreadGroup.getInstance(), null, "ResolverGui.Wait"){

                        @Override
                        public void run() {
                            double d = Resolver.NODATA;
                            try {
                                do {
                                    d = ResolverGuiTest.this.resolver.getDec();
                                    ResolverGuiTest.this.mySleep(1000);
                                } while (d == Resolver.NODATA);
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                            if (d != Resolver.NODATA) {
                                if (d == Resolver.INVALID) {
                                    GUIUtilities.warning(null, "Could not resolve the name: " + ResolverGuiTest.this.target + "\nSource Name will be reset to previous value.");
                                } else {
                                    ResolverGuiTest.this.label.setText(ResolverGuiTest.this.resolver.toString());
                                    System.out.println(ResolverGuiTest.this.resolver);
                                }
                            }
                            ResolverGuiTest.this.pane.setCursor(new Cursor(0));
                            ResolverGuiTest.this.resolveButton.setEnabled(true);
                        }
                    };
                    this.waitWorker.start();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
    }
}

