/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.guiutil.events;

import alma.obsprep.guiutil.events.Event;
import alma.obsprep.guiutil.events.EventReceiver;
import alma.obsprep.guiutil.events.EventType;
import alma.obsprep.guiutil.events.EventTypeGroup;
import alma.obsprep.guiutil.events.Subscription;
import alma.obsprep.util.job.ObsprepThreadGroup;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.SwingUtilities;

public class EventManager {
    private static Map<Object, Set<EventReceiver>> subscriptions = new HashMap<Object, Set<EventReceiver>>();
    private static AsyncQueue asyncQueue = new AsyncQueue();
    private static AsyncHandlerThread asyncHandlerThread = null;

    public static void publish(Event event) {
        EventManager.publish(event, event.getType().getMode());
    }

    private static void publishToSwing(Event event) {
        EventManager.publish(event, 2);
    }

    private static void publish(Event event, int n) {
        if (n == 0) {
            EventManager.publishInternal(event);
        } else if (n == 2) {
            final Event event2 = event;
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    EventManager.publishInternal(event2);
                }
            };
            SwingUtilities.invokeLater(runnable);
        } else if (n == 1) {
            if (asyncHandlerThread == null) {
                asyncHandlerThread = new AsyncHandlerThread();
                asyncHandlerThread.start();
            }
            asyncQueue.add(event);
        } else {
            throw new IllegalArgumentException("unknown mode argument: " + n);
        }
    }

    private static void publishInternal(Event event) {
        Set<EventReceiver> set = EventManager.getList(event.getType());
        EventManager.publishToSet(set, event);
        set = EventManager.getList(event.getSource());
        EventManager.publishToSet(set, event);
    }

    private static void publishToSet(Set<EventReceiver> set, Event event) {
        for (EventReceiver eventReceiver : set) {
            eventReceiver.receiveEvent(event);
        }
    }

    private static Subscription subscribe(Object object, EventReceiver eventReceiver) {
        Set<EventReceiver> set = EventManager.getList(object);
        set.add(eventReceiver);
        return null;
    }

    public static Subscription subscribeBySrc(Object object, EventReceiver eventReceiver) {
        return EventManager.subscribe(object, eventReceiver);
    }

    public static Subscription subscribeByType(EventType eventType, EventReceiver eventReceiver) {
        return EventManager.subscribe(eventType, eventReceiver);
    }

    private static Subscription[] subscribeByTypeGroup(EventTypeGroup eventTypeGroup, EventReceiver eventReceiver) {
        Subscription[] subscriptionArray = new Subscription[eventTypeGroup.size()];
        for (int i = 0; i < eventTypeGroup.getElements().length; ++i) {
            Subscription subscription;
            EventType eventType = eventTypeGroup.getElements()[i];
            subscriptionArray[i] = subscription = EventManager.subscribe(eventType, eventReceiver);
        }
        return subscriptionArray;
    }

    private static Subscription[] subscribeGroup(EventTypeGroup eventTypeGroup, EventReceiver eventReceiver) {
        Subscription[] subscriptionArray = new Subscription[eventTypeGroup.size()];
        for (int i = 0; i < eventTypeGroup.getElements().length; ++i) {
            EventType eventType = eventTypeGroup.getElements()[i];
            Set<EventReceiver> set = EventManager.getList(eventType);
            Subscription subscription = new Subscription(eventReceiver);
            set.add((EventReceiver)((Object)subscription));
            subscriptionArray[i] = subscription;
        }
        return subscriptionArray;
    }

    private static Set<EventReceiver> getList(Object object) {
        Set<EventReceiver> set = subscriptions.get(object);
        if (set == null) {
            set = new HashSet<EventReceiver>();
            subscriptions.put(object, set);
        }
        return set;
    }

    public void unsubscribe(Subscription subscription) {
        subscriptions.remove(subscription);
    }

    public static void finish() {
        if (asyncHandlerThread != null) {
            asyncHandlerThread.halt();
        }
    }

    private static class AsyncHandlerThread
    extends Thread {
        private boolean shouldRun = true;

        AsyncHandlerThread() {
            super(ObsprepThreadGroup.getInstance(), null, "OT-EventQueue-0");
            super.setDaemon(true);
        }

        public void halt() {
            this.shouldRun = false;
            this.interrupt();
        }

        @Override
        public void run() {
            while (this.shouldRun) {
                Event event = asyncQueue.getNext();
                if (event == null) continue;
                EventManager.publishInternal(event);
            }
        }
    }

    static class AsyncQueue {
        private List<Event> l = new ArrayList<Event>();

        AsyncQueue() {
        }

        public synchronized void add(Event event) {
            this.l.add(event);
            this.notifyAll();
        }

        public synchronized Event getNext() {
            if (this.l.isEmpty()) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            if (!this.l.isEmpty()) {
                Event event = this.l.get(0);
                this.l.remove(0);
                return event;
            }
            return null;
        }
    }
}

