/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.bo.schedblock;

import alma.entity.xmlbinding.schedblock.SpectralLineT;
import alma.obsprep.bo.schedblock.data.SpectralLineData;
import alma.valuetypes.Frequency;
import alma.valuetypes.Velocity;
import lombok.NonNull;

public class SpectralLine
extends SpectralLineData {
    public String toString() {
        return "SpectralLine [getRestFrequency()=" + String.valueOf((Object)this.getRestFrequency()) + ", getTransition()=" + this.getTransition() + ", getSpatalogId()=" + this.getSpatalogId() + "]";
    }

    public SpectralLine(SpectralLineT spectralLineT) {
        super(spectralLineT);
    }

    public static SpectralLine createFromSplatalogue(alma.obsprep.services.experts.spectralline.SpectralLine spectralLine) {
        SpectralLine spectralLine2 = SpectralLine.createSpectralLine();
        spectralLine2.setRestFrequency(spectralLine.getFrequency());
        spectralLine2.setTransition(spectralLine.getTitle());
        spectralLine2.setSplatalogId(spectralLine.getLineId());
        return spectralLine2;
    }

    public void setTransition(String string) {
        if (string == null) {
            super.setTransition("");
        } else {
            String string2 = string.replaceAll("[^\\x00-\\x7F]", "_").replaceAll(" ", "_");
            super.setTransition(string2);
        }
    }

    public void setSplatalogId(Integer n) {
        if (n == null) {
            super.setSpatalogId("");
        } else {
            super.setSpatalogId(n.toString());
        }
    }

    public SpectralLine transposeLineToImageSSW(@NonNull Velocity velocity, @NonNull Frequency frequency) {
        if (velocity == null) {
            throw new NullPointerException("v is marked non-null but is null");
        }
        if (frequency == null) {
            throw new NullPointerException("skyLO1Freq is marked non-null but is null");
        }
        SpectralLine spectralLine = this.deepCopy();
        double d = frequency.getContentInGHz();
        if (this.getTransition().equals("Single_Continuum")) {
            double d2 = this.getRestFrequency().getContentInGHz();
            spectralLine.setRestFrequency(Frequency.createFrequencyGHZ(2.0 * d - d2));
        } else {
            double d3 = velocity.dopplerShift(this.getRestFrequency()).getContentInGHz();
            spectralLine.setRestFrequency(velocity.reverseShift(Frequency.createFrequencyGHZ(2.0 * d - d3)));
        }
        return spectralLine;
    }
}

