/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.bo.schedblock;

import alma.obsprep.bo.schedblock.ConfigModeDecoder;
import java.util.ArrayList;
import java.util.TreeMap;
import java.util.TreeSet;

public class ConfigModeDecoderImpl
implements ConfigModeDecoder {
    private ArrayList<EmbeddedCorrConfigMode> modeList;
    private TreeMap<Integer, EmbeddedCorrConfigMode> modeMap;
    private TreeSet<Integer> knownModesSet;
    private TreeSet<Integer> knownNominalChannelsSet;
    private TreeSet<Double> knownNominalBandwidthsSet;
    private long[] knownChannels = null;
    private int[] knownModes = null;
    private float[] knownNominalBandwidths = null;

    public ConfigModeDecoderImpl() {
        this.setup();
    }

    private void setup() {
        this.modeList = new ArrayList(200);
        this.modeList.add(new EmbeddedCorrConfigMode(0, 0.0, 0, null, false, null, null));
        this.modeList.add(new EmbeddedCorrConfigMode(1, 2000.0, 8192, 1992.1875, 8160, ConfigModeDecoder.eBits.BITS_2x2, false, ConfigModeDecoder.ePolarization.POLZ_SINGLE_X, ConfigModeDecoder.eFilterMode.FILTER_TFB, 0.98));
        this.modeList.add(new EmbeddedCorrConfigMode(2, 1000.0, 8192, ConfigModeDecoder.eBits.BITS_2x2, false, ConfigModeDecoder.ePolarization.POLZ_SINGLE_X, ConfigModeDecoder.eFilterMode.FILTER_TFB, 0.97));
        this.modeList.add(new EmbeddedCorrConfigMode(3, 1000.0, 4096, ConfigModeDecoder.eBits.BITS_2x2, false, ConfigModeDecoder.ePolarization.POLZ_SINGLE_X, ConfigModeDecoder.eFilterMode.FILTER_TFB, 0.98));
        this.modeList.add(new EmbeddedCorrConfigMode(4, 500.0, 8192, ConfigModeDecoder.eBits.BITS_2x2, false, ConfigModeDecoder.ePolarization.POLZ_SINGLE_X, ConfigModeDecoder.eFilterMode.FILTER_TFB, 0.96));
        this.modeList.add(new EmbeddedCorrConfigMode(5, 500.0, 4096, ConfigModeDecoder.eBits.BITS_2x2, false, ConfigModeDecoder.ePolarization.POLZ_SINGLE_X, ConfigModeDecoder.eFilterMode.FILTER_TFB, 0.97));
        this.modeList.add(new EmbeddedCorrConfigMode(6, 500.0, 2048, ConfigModeDecoder.eBits.BITS_2x2, false, ConfigModeDecoder.ePolarization.POLZ_SINGLE_X, ConfigModeDecoder.eFilterMode.FILTER_TFB, 0.98));
        this.modeList.add(new EmbeddedCorrConfigMode(7, 250.0, 8192, ConfigModeDecoder.eBits.BITS_2x2, false, ConfigModeDecoder.ePolarization.POLZ_SINGLE_X, ConfigModeDecoder.eFilterMode.FILTER_TFB, 0.94));
        this.modeList.add(new EmbeddedCorrConfigMode(8, 250.0, 4096, ConfigModeDecoder.eBits.BITS_2x2, false, ConfigModeDecoder.ePolarization.POLZ_SINGLE_X, ConfigModeDecoder.eFilterMode.FILTER_TFB, 0.96));
        this.modeList.add(new EmbeddedCorrConfigMode(9, 250.0, 2048, ConfigModeDecoder.eBits.BITS_2x2, false, ConfigModeDecoder.ePolarization.POLZ_SINGLE_X, ConfigModeDecoder.eFilterMode.FILTER_TFB, 0.97));
        this.modeList.add(new EmbeddedCorrConfigMode(10, 250.0, 1024, ConfigModeDecoder.eBits.BITS_2x2, false, ConfigModeDecoder.ePolarization.POLZ_SINGLE_X, ConfigModeDecoder.eFilterMode.FILTER_TFB, 0.98));
        this.modeList.add(new EmbeddedCorrConfigMode(11, 125.0, 8192, ConfigModeDecoder.eBits.BITS_2x2, false, ConfigModeDecoder.ePolarization.POLZ_SINGLE_X, ConfigModeDecoder.eFilterMode.FILTER_TFB, 0.91));
        this.modeList.add(new EmbeddedCorrConfigMode(12, 125.0, 4096, ConfigModeDecoder.eBits.BITS_2x2, false, ConfigModeDecoder.ePolarization.POLZ_SINGLE_X, ConfigModeDecoder.eFilterMode.FILTER_TFB, 0.94));
        this.modeList.add(new EmbeddedCorrConfigMode(13, 125.0, 2048, ConfigModeDecoder.eBits.BITS_2x2, false, ConfigModeDecoder.ePolarization.POLZ_SINGLE_X, ConfigModeDecoder.eFilterMode.FILTER_TFB, 0.96));
        this.modeList.add(new EmbeddedCorrConfigMode(14, 125.0, 1024, ConfigModeDecoder.eBits.BITS_2x2, false, ConfigModeDecoder.ePolarization.POLZ_SINGLE_X, ConfigModeDecoder.eFilterMode.FILTER_TFB, 0.97));
        this.modeList.add(new EmbeddedCorrConfigMode(1014, 125.0, 512, ConfigModeDecoder.eBits.BITS_2x2, false, ConfigModeDecoder.ePolarization.POLZ_SINGLE_X, ConfigModeDecoder.eFilterMode.FILTER_TFB, 0.97));
        this.modeList.add(new EmbeddedCorrConfigMode(15, 62.5, 8192, ConfigModeDecoder.eBits.BITS_2x2, false, ConfigModeDecoder.ePolarization.POLZ_SINGLE_X, ConfigModeDecoder.eFilterMode.FILTER_TFB, 0.87));
        this.modeList.add(new EmbeddedCorrConfigMode(16, 62.5, 4096, ConfigModeDecoder.eBits.BITS_2x2, false, ConfigModeDecoder.ePolarization.POLZ_SINGLE_X, ConfigModeDecoder.eFilterMode.FILTER_TFB, 0.91));
        this.modeList.add(new EmbeddedCorrConfigMode(17, 62.5, 2048, ConfigModeDecoder.eBits.BITS_2x2, false, ConfigModeDecoder.ePolarization.POLZ_SINGLE_X, ConfigModeDecoder.eFilterMode.FILTER_TFB, 0.94));
        this.modeList.add(new EmbeddedCorrConfigMode(18, 62.5, 1024, ConfigModeDecoder.eBits.BITS_2x2, false, ConfigModeDecoder.ePolarization.POLZ_SINGLE_X, ConfigModeDecoder.eFilterMode.FILTER_TFB, 0.96));
        this.modeList.add(new EmbeddedCorrConfigMode(1018, 62.5, 512, ConfigModeDecoder.eBits.BITS_2x2, false, ConfigModeDecoder.ePolarization.POLZ_SINGLE_X, ConfigModeDecoder.eFilterMode.FILTER_TFB, 0.96));
        this.modeList.add(new EmbeddedCorrConfigMode(1118, 62.5, 256, ConfigModeDecoder.eBits.BITS_2x2, false, ConfigModeDecoder.ePolarization.POLZ_SINGLE_X, ConfigModeDecoder.eFilterMode.FILTER_TFB, 0.96));
        this.modeList.add(new EmbeddedCorrConfigMode(19, 2000.0, 8192, 1992.1875, 8160, ConfigModeDecoder.eBits.BITS_2x2, false, ConfigModeDecoder.ePolarization.POLZ_SINGLE_Y, ConfigModeDecoder.eFilterMode.FILTER_TFB, 0.98));
        this.modeList.add(new EmbeddedCorrConfigMode(20, 1000.0, 8192, ConfigModeDecoder.eBits.BITS_2x2, false, ConfigModeDecoder.ePolarization.POLZ_SINGLE_Y, ConfigModeDecoder.eFilterMode.FILTER_TFB, 0.97));
        this.modeList.add(new EmbeddedCorrConfigMode(21, 1000.0, 4096, ConfigModeDecoder.eBits.BITS_2x2, false, ConfigModeDecoder.ePolarization.POLZ_SINGLE_Y, ConfigModeDecoder.eFilterMode.FILTER_TFB, 0.98));
        this.modeList.add(new EmbeddedCorrConfigMode(22, 500.0, 8192, ConfigModeDecoder.eBits.BITS_2x2, false, ConfigModeDecoder.ePolarization.POLZ_SINGLE_Y, ConfigModeDecoder.eFilterMode.FILTER_TFB, 0.96));
        this.modeList.add(new EmbeddedCorrConfigMode(23, 500.0, 4096, ConfigModeDecoder.eBits.BITS_2x2, false, ConfigModeDecoder.ePolarization.POLZ_SINGLE_Y, ConfigModeDecoder.eFilterMode.FILTER_TFB, 0.97));
        this.modeList.add(new EmbeddedCorrConfigMode(24, 500.0, 2048, ConfigModeDecoder.eBits.BITS_2x2, false, ConfigModeDecoder.ePolarization.POLZ_SINGLE_Y, ConfigModeDecoder.eFilterMode.FILTER_TFB, 0.98));
        this.modeList.add(new EmbeddedCorrConfigMode(25, 250.0, 8192, ConfigModeDecoder.eBits.BITS_2x2, false, ConfigModeDecoder.ePolarization.POLZ_SINGLE_Y, ConfigModeDecoder.eFilterMode.FILTER_TFB, 0.94));
        this.modeList.add(new EmbeddedCorrConfigMode(26, 250.0, 4096, ConfigModeDecoder.eBits.BITS_2x2, false, ConfigModeDecoder.ePolarization.POLZ_SINGLE_Y, ConfigModeDecoder.eFilterMode.FILTER_TFB, 0.96));
        this.modeList.add(new EmbeddedCorrConfigMode(27, 250.0, 2048, ConfigModeDecoder.eBits.BITS_2x2, false, ConfigModeDecoder.ePolarization.POLZ_SINGLE_Y, ConfigModeDecoder.eFilterMode.FILTER_TFB, 0.97));
        this.modeList.add(new EmbeddedCorrConfigMode(28, 250.0, 1024, ConfigModeDecoder.eBits.BITS_2x2, false, ConfigModeDecoder.ePolarization.POLZ_SINGLE_Y, ConfigModeDecoder.eFilterMode.FILTER_TFB, 0.98));
        this.modeList.add(new EmbeddedCorrConfigMode(29, 125.0, 8192, ConfigModeDecoder.eBits.BITS_2x2, false, ConfigModeDecoder.ePolarization.POLZ_SINGLE_Y, ConfigModeDecoder.eFilterMode.FILTER_TFB, 0.91));
        this.modeList.add(new EmbeddedCorrConfigMode(30, 125.0, 4096, ConfigModeDecoder.eBits.BITS_2x2, false, ConfigModeDecoder.ePolarization.POLZ_SINGLE_Y, ConfigModeDecoder.eFilterMode.FILTER_TFB, 0.94));
        this.modeList.add(new EmbeddedCorrConfigMode(31, 125.0, 2048, ConfigModeDecoder.eBits.BITS_2x2, false, ConfigModeDecoder.ePolarization.POLZ_SINGLE_Y, ConfigModeDecoder.eFilterMode.FILTER_TFB, 0.96));
        this.modeList.add(new EmbeddedCorrConfigMode(32, 125.0, 1024, ConfigModeDecoder.eBits.BITS_2x2, false, ConfigModeDecoder.ePolarization.POLZ_SINGLE_Y, ConfigModeDecoder.eFilterMode.FILTER_TFB, 0.97));
        this.modeList.add(new EmbeddedCorrConfigMode(33, 62.5, 8192, ConfigModeDecoder.eBits.BITS_2x2, false, ConfigModeDecoder.ePolarization.POLZ_SINGLE_Y, ConfigModeDecoder.eFilterMode.FILTER_TFB, 0.87));
        this.modeList.add(new EmbeddedCorrConfigMode(34, 62.5, 4096, ConfigModeDecoder.eBits.BITS_2x2, false, ConfigModeDecoder.ePolarization.POLZ_SINGLE_Y, ConfigModeDecoder.eFilterMode.FILTER_TFB, 0.91));
        this.modeList.add(new EmbeddedCorrConfigMode(35, 62.5, 2048, ConfigModeDecoder.eBits.BITS_2x2, false, ConfigModeDecoder.ePolarization.POLZ_SINGLE_Y, ConfigModeDecoder.eFilterMode.FILTER_TFB, 0.94));
        this.modeList.add(new EmbeddedCorrConfigMode(36, 62.5, 1024, ConfigModeDecoder.eBits.BITS_2x2, false, ConfigModeDecoder.ePolarization.POLZ_SINGLE_Y, ConfigModeDecoder.eFilterMode.FILTER_TFB, 0.96));
        this.modeList.add(new EmbeddedCorrConfigMode(37, 2000.0, 4096, 1992.1875, 4080, ConfigModeDecoder.eBits.BITS_2x2, false, ConfigModeDecoder.ePolarization.POLZ_DOUBLE, ConfigModeDecoder.eFilterMode.FILTER_TFB, 0.99));
        this.modeList.add(new EmbeddedCorrConfigMode(38, 1000.0, 4096, ConfigModeDecoder.eBits.BITS_2x2, false, ConfigModeDecoder.ePolarization.POLZ_DOUBLE, ConfigModeDecoder.eFilterMode.FILTER_TFB, 0.98));
        this.modeList.add(new EmbeddedCorrConfigMode(1038, 1000.0, 2048, ConfigModeDecoder.eBits.BITS_2x2, false, ConfigModeDecoder.ePolarization.POLZ_DOUBLE, ConfigModeDecoder.eFilterMode.FILTER_TFB, 0.98));
        this.modeList.add(new EmbeddedCorrConfigMode(39, 500.0, 4096, ConfigModeDecoder.eBits.BITS_2x2, false, ConfigModeDecoder.ePolarization.POLZ_DOUBLE, ConfigModeDecoder.eFilterMode.FILTER_TFB, 0.97));
        this.modeList.add(new EmbeddedCorrConfigMode(40, 500.0, 2048, ConfigModeDecoder.eBits.BITS_2x2, false, ConfigModeDecoder.ePolarization.POLZ_DOUBLE, ConfigModeDecoder.eFilterMode.FILTER_TFB, 0.98));
        this.modeList.add(new EmbeddedCorrConfigMode(1040, 500.0, 1024, ConfigModeDecoder.eBits.BITS_2x2, false, ConfigModeDecoder.ePolarization.POLZ_DOUBLE, ConfigModeDecoder.eFilterMode.FILTER_TFB, 0.98));
        this.modeList.add(new EmbeddedCorrConfigMode(41, 250.0, 4096, ConfigModeDecoder.eBits.BITS_2x2, false, ConfigModeDecoder.ePolarization.POLZ_DOUBLE, ConfigModeDecoder.eFilterMode.FILTER_TFB, 0.96));
        this.modeList.add(new EmbeddedCorrConfigMode(42, 250.0, 2048, ConfigModeDecoder.eBits.BITS_2x2, false, ConfigModeDecoder.ePolarization.POLZ_DOUBLE, ConfigModeDecoder.eFilterMode.FILTER_TFB, 0.97));
        this.modeList.add(new EmbeddedCorrConfigMode(43, 250.0, 1024, ConfigModeDecoder.eBits.BITS_2x2, false, ConfigModeDecoder.ePolarization.POLZ_DOUBLE, ConfigModeDecoder.eFilterMode.FILTER_TFB, 0.98));
        this.modeList.add(new EmbeddedCorrConfigMode(1043, 250.0, 512, ConfigModeDecoder.eBits.BITS_2x2, false, ConfigModeDecoder.ePolarization.POLZ_DOUBLE, ConfigModeDecoder.eFilterMode.FILTER_TFB, 0.98));
        this.modeList.add(new EmbeddedCorrConfigMode(44, 125.0, 4096, ConfigModeDecoder.eBits.BITS_2x2, false, ConfigModeDecoder.ePolarization.POLZ_DOUBLE, ConfigModeDecoder.eFilterMode.FILTER_TFB, 0.94));
        this.modeList.add(new EmbeddedCorrConfigMode(45, 125.0, 2048, ConfigModeDecoder.eBits.BITS_2x2, false, ConfigModeDecoder.ePolarization.POLZ_DOUBLE, ConfigModeDecoder.eFilterMode.FILTER_TFB, 0.96));
        this.modeList.add(new EmbeddedCorrConfigMode(46, 125.0, 1024, ConfigModeDecoder.eBits.BITS_2x2, false, ConfigModeDecoder.ePolarization.POLZ_DOUBLE, ConfigModeDecoder.eFilterMode.FILTER_TFB, 0.97));
        this.modeList.add(new EmbeddedCorrConfigMode(47, 125.0, 512, ConfigModeDecoder.eBits.BITS_2x2, false, ConfigModeDecoder.ePolarization.POLZ_DOUBLE, ConfigModeDecoder.eFilterMode.FILTER_TFB, 0.98));
        this.modeList.add(new EmbeddedCorrConfigMode(1047, 125.0, 256, ConfigModeDecoder.eBits.BITS_2x2, false, ConfigModeDecoder.ePolarization.POLZ_DOUBLE, ConfigModeDecoder.eFilterMode.FILTER_TFB, 0.98));
        this.modeList.add(new EmbeddedCorrConfigMode(48, 62.5, 4096, ConfigModeDecoder.eBits.BITS_2x2, false, ConfigModeDecoder.ePolarization.POLZ_DOUBLE, ConfigModeDecoder.eFilterMode.FILTER_TFB, 0.91));
        this.modeList.add(new EmbeddedCorrConfigMode(49, 62.5, 2048, ConfigModeDecoder.eBits.BITS_2x2, false, ConfigModeDecoder.ePolarization.POLZ_DOUBLE, ConfigModeDecoder.eFilterMode.FILTER_TFB, 0.94));
        this.modeList.add(new EmbeddedCorrConfigMode(50, 62.5, 1024, ConfigModeDecoder.eBits.BITS_2x2, false, ConfigModeDecoder.ePolarization.POLZ_DOUBLE, ConfigModeDecoder.eFilterMode.FILTER_TFB, 0.96));
        this.modeList.add(new EmbeddedCorrConfigMode(51, 62.5, 512, ConfigModeDecoder.eBits.BITS_2x2, false, ConfigModeDecoder.ePolarization.POLZ_DOUBLE, ConfigModeDecoder.eFilterMode.FILTER_TFB, 0.97));
        this.modeList.add(new EmbeddedCorrConfigMode(1051, 62.5, 256, ConfigModeDecoder.eBits.BITS_2x2, false, ConfigModeDecoder.ePolarization.POLZ_DOUBLE, ConfigModeDecoder.eFilterMode.FILTER_TFB, 0.97));
        this.modeList.add(new EmbeddedCorrConfigMode(1151, 62.5, 128, ConfigModeDecoder.eBits.BITS_2x2, false, ConfigModeDecoder.ePolarization.POLZ_DOUBLE, ConfigModeDecoder.eFilterMode.FILTER_TFB, 0.97));
        this.modeList.add(new EmbeddedCorrConfigMode(52, 2000.0, 2048, 1992.1875, 2040, ConfigModeDecoder.eBits.BITS_2x2, false, ConfigModeDecoder.ePolarization.POLZ_FULL, ConfigModeDecoder.eFilterMode.FILTER_TFB, 0.99));
        this.modeList.add(new EmbeddedCorrConfigMode(53, 1000.0, 2048, ConfigModeDecoder.eBits.BITS_2x2, false, ConfigModeDecoder.ePolarization.POLZ_FULL, ConfigModeDecoder.eFilterMode.FILTER_TFB, 0.99));
        this.modeList.add(new EmbeddedCorrConfigMode(54, 500.0, 2048, ConfigModeDecoder.eBits.BITS_2x2, false, ConfigModeDecoder.ePolarization.POLZ_FULL, ConfigModeDecoder.eFilterMode.FILTER_TFB, 0.98));
        this.modeList.add(new EmbeddedCorrConfigMode(55, 250.0, 2048, ConfigModeDecoder.eBits.BITS_2x2, false, ConfigModeDecoder.ePolarization.POLZ_FULL, ConfigModeDecoder.eFilterMode.FILTER_TFB, 0.97));
        this.modeList.add(new EmbeddedCorrConfigMode(56, 250.0, 1024, ConfigModeDecoder.eBits.BITS_2x2, false, ConfigModeDecoder.ePolarization.POLZ_FULL, ConfigModeDecoder.eFilterMode.FILTER_TFB, 0.98));
        this.modeList.add(new EmbeddedCorrConfigMode(57, 125.0, 2048, ConfigModeDecoder.eBits.BITS_2x2, false, ConfigModeDecoder.ePolarization.POLZ_FULL, ConfigModeDecoder.eFilterMode.FILTER_TFB, 0.96));
        this.modeList.add(new EmbeddedCorrConfigMode(58, 125.0, 1024, ConfigModeDecoder.eBits.BITS_2x2, false, ConfigModeDecoder.ePolarization.POLZ_FULL, ConfigModeDecoder.eFilterMode.FILTER_TFB, 0.97));
        this.modeList.add(new EmbeddedCorrConfigMode(59, 125.0, 512, ConfigModeDecoder.eBits.BITS_2x2, false, ConfigModeDecoder.ePolarization.POLZ_FULL, ConfigModeDecoder.eFilterMode.FILTER_TFB, 0.98));
        this.modeList.add(new EmbeddedCorrConfigMode(60, 62.5, 2048, ConfigModeDecoder.eBits.BITS_2x2, false, ConfigModeDecoder.ePolarization.POLZ_FULL, ConfigModeDecoder.eFilterMode.FILTER_TFB, 0.94));
        this.modeList.add(new EmbeddedCorrConfigMode(61, 62.5, 1024, ConfigModeDecoder.eBits.BITS_2x2, false, ConfigModeDecoder.ePolarization.POLZ_FULL, ConfigModeDecoder.eFilterMode.FILTER_TFB, 0.96));
        this.modeList.add(new EmbeddedCorrConfigMode(62, 62.5, 512, ConfigModeDecoder.eBits.BITS_2x2, false, ConfigModeDecoder.ePolarization.POLZ_FULL, ConfigModeDecoder.eFilterMode.FILTER_TFB, 0.97));
        this.modeList.add(new EmbeddedCorrConfigMode(63, 62.5, 256, ConfigModeDecoder.eBits.BITS_2x2, false, ConfigModeDecoder.ePolarization.POLZ_FULL, ConfigModeDecoder.eFilterMode.FILTER_TFB, 0.98));
        this.modeList.add(new EmbeddedCorrConfigMode(64, 2000.0, 4096, ConfigModeDecoder.eBits.BITS_2x2, true, ConfigModeDecoder.ePolarization.POLZ_SINGLE_X, ConfigModeDecoder.eFilterMode.FILTER_TFB, 0.99));
        this.modeList.add(new EmbeddedCorrConfigMode(65, 1000.0, 4096, ConfigModeDecoder.eBits.BITS_2x2, true, ConfigModeDecoder.ePolarization.POLZ_SINGLE_X, ConfigModeDecoder.eFilterMode.FILTER_TFB, 0.98));
        this.modeList.add(new EmbeddedCorrConfigMode(66, 500.0, 4096, ConfigModeDecoder.eBits.BITS_2x2, true, ConfigModeDecoder.ePolarization.POLZ_SINGLE_X, ConfigModeDecoder.eFilterMode.FILTER_TFB, 0.97));
        this.modeList.add(new EmbeddedCorrConfigMode(67, 250.0, 4096, ConfigModeDecoder.eBits.BITS_2x2, true, ConfigModeDecoder.ePolarization.POLZ_SINGLE_X, ConfigModeDecoder.eFilterMode.FILTER_TFB, 0.96));
        this.modeList.add(new EmbeddedCorrConfigMode(68, 125.0, 4096, ConfigModeDecoder.eBits.BITS_2x2, true, ConfigModeDecoder.ePolarization.POLZ_SINGLE_X, ConfigModeDecoder.eFilterMode.FILTER_TFB, 0.94));
        this.modeList.add(new EmbeddedCorrConfigMode(69, 62.5, 4096, ConfigModeDecoder.eBits.BITS_2x2, true, ConfigModeDecoder.ePolarization.POLZ_SINGLE_X, ConfigModeDecoder.eFilterMode.FILTER_TFB, 0.91));
        this.modeList.add(new EmbeddedCorrConfigMode(70, 31.25, 8192, ConfigModeDecoder.eBits.BITS_2x2, true, ConfigModeDecoder.ePolarization.POLZ_SINGLE_X, ConfigModeDecoder.eFilterMode.FILTER_TFB, 0.81));
        this.modeList.add(new EmbeddedCorrConfigMode(71, 31.25, 4096, ConfigModeDecoder.eBits.BITS_2x2, true, ConfigModeDecoder.ePolarization.POLZ_SINGLE_X, ConfigModeDecoder.eFilterMode.FILTER_TFB, 0.88));
        this.modeList.add(new EmbeddedCorrConfigMode(72, 31.25, 2048, ConfigModeDecoder.eBits.BITS_2x2, true, ConfigModeDecoder.ePolarization.POLZ_SINGLE_X, ConfigModeDecoder.eFilterMode.FILTER_TFB, 0.91));
        this.modeList.add(new EmbeddedCorrConfigMode(73, 31.25, 1024, ConfigModeDecoder.eBits.BITS_2x2, true, ConfigModeDecoder.ePolarization.POLZ_SINGLE_X, ConfigModeDecoder.eFilterMode.FILTER_TFB, 0.88));
        this.modeList.add(new EmbeddedCorrConfigMode(74, 2000.0, 4096, ConfigModeDecoder.eBits.BITS_2x2, true, ConfigModeDecoder.ePolarization.POLZ_SINGLE_Y, ConfigModeDecoder.eFilterMode.FILTER_TFB, 0.99));
        this.modeList.add(new EmbeddedCorrConfigMode(75, 1000.0, 4096, ConfigModeDecoder.eBits.BITS_2x2, true, ConfigModeDecoder.ePolarization.POLZ_SINGLE_Y, ConfigModeDecoder.eFilterMode.FILTER_TFB, 0.98));
        this.modeList.add(new EmbeddedCorrConfigMode(76, 500.0, 4096, ConfigModeDecoder.eBits.BITS_2x2, true, ConfigModeDecoder.ePolarization.POLZ_SINGLE_Y, ConfigModeDecoder.eFilterMode.FILTER_TFB, 0.97));
        this.modeList.add(new EmbeddedCorrConfigMode(77, 250.0, 4096, ConfigModeDecoder.eBits.BITS_2x2, true, ConfigModeDecoder.ePolarization.POLZ_SINGLE_Y, ConfigModeDecoder.eFilterMode.FILTER_TFB, 0.96));
        this.modeList.add(new EmbeddedCorrConfigMode(78, 125.0, 4096, ConfigModeDecoder.eBits.BITS_2x2, true, ConfigModeDecoder.ePolarization.POLZ_SINGLE_Y, ConfigModeDecoder.eFilterMode.FILTER_TFB, 0.94));
        this.modeList.add(new EmbeddedCorrConfigMode(79, 62.5, 4096, ConfigModeDecoder.eBits.BITS_2x2, true, ConfigModeDecoder.ePolarization.POLZ_SINGLE_Y, ConfigModeDecoder.eFilterMode.FILTER_TFB, 0.91));
        this.modeList.add(new EmbeddedCorrConfigMode(80, 31.25, 8192, ConfigModeDecoder.eBits.BITS_2x2, true, ConfigModeDecoder.ePolarization.POLZ_SINGLE_Y, ConfigModeDecoder.eFilterMode.FILTER_TFB, 0.81));
        this.modeList.add(new EmbeddedCorrConfigMode(81, 31.25, 4096, ConfigModeDecoder.eBits.BITS_2x2, true, ConfigModeDecoder.ePolarization.POLZ_SINGLE_Y, ConfigModeDecoder.eFilterMode.FILTER_TFB, 0.88));
        this.modeList.add(new EmbeddedCorrConfigMode(82, 31.25, 2048, ConfigModeDecoder.eBits.BITS_2x2, true, ConfigModeDecoder.ePolarization.POLZ_SINGLE_Y, ConfigModeDecoder.eFilterMode.FILTER_TFB, 0.91));
        this.modeList.add(new EmbeddedCorrConfigMode(83, 31.25, 1024, ConfigModeDecoder.eBits.BITS_2x2, true, ConfigModeDecoder.ePolarization.POLZ_SINGLE_Y, ConfigModeDecoder.eFilterMode.FILTER_TFB, 0.88));
        this.modeList.add(new EmbeddedCorrConfigMode(84, 1000.0, 2048, ConfigModeDecoder.eBits.BITS_2x2, true, ConfigModeDecoder.ePolarization.POLZ_DOUBLE, ConfigModeDecoder.eFilterMode.FILTER_TFB, 0.99));
        this.modeList.add(new EmbeddedCorrConfigMode(85, 500.0, 2048, ConfigModeDecoder.eBits.BITS_2x2, true, ConfigModeDecoder.ePolarization.POLZ_DOUBLE, ConfigModeDecoder.eFilterMode.FILTER_TFB, 0.98));
        this.modeList.add(new EmbeddedCorrConfigMode(86, 250.0, 2048, ConfigModeDecoder.eBits.BITS_2x2, true, ConfigModeDecoder.ePolarization.POLZ_DOUBLE, ConfigModeDecoder.eFilterMode.FILTER_TFB, 0.97));
        this.modeList.add(new EmbeddedCorrConfigMode(87, 125.0, 2048, ConfigModeDecoder.eBits.BITS_2x2, true, ConfigModeDecoder.ePolarization.POLZ_DOUBLE, ConfigModeDecoder.eFilterMode.FILTER_TFB, 0.96));
        this.modeList.add(new EmbeddedCorrConfigMode(88, 62.5, 2048, ConfigModeDecoder.eBits.BITS_2x2, true, ConfigModeDecoder.ePolarization.POLZ_DOUBLE, ConfigModeDecoder.eFilterMode.FILTER_TFB, 0.94));
        this.modeList.add(new EmbeddedCorrConfigMode(89, 31.25, 4096, ConfigModeDecoder.eBits.BITS_2x2, true, ConfigModeDecoder.ePolarization.POLZ_DOUBLE, ConfigModeDecoder.eFilterMode.FILTER_TFB, 0.87));
        this.modeList.add(new EmbeddedCorrConfigMode(90, 31.25, 2048, ConfigModeDecoder.eBits.BITS_2x2, true, ConfigModeDecoder.ePolarization.POLZ_DOUBLE, ConfigModeDecoder.eFilterMode.FILTER_TFB, 0.88));
        this.modeList.add(new EmbeddedCorrConfigMode(91, 31.25, 1024, ConfigModeDecoder.eBits.BITS_2x2, true, ConfigModeDecoder.ePolarization.POLZ_DOUBLE, ConfigModeDecoder.eFilterMode.FILTER_TFB, 0.94));
        this.modeList.add(new EmbeddedCorrConfigMode(92, 31.25, 512, ConfigModeDecoder.eBits.BITS_2x2, true, ConfigModeDecoder.ePolarization.POLZ_DOUBLE, ConfigModeDecoder.eFilterMode.FILTER_TFB, 0.88));
        this.modeList.add(new EmbeddedCorrConfigMode(93, 1000.0, 1024, ConfigModeDecoder.eBits.BITS_2x2, true, ConfigModeDecoder.ePolarization.POLZ_FULL, ConfigModeDecoder.eFilterMode.FILTER_TFB, 0.99));
        this.modeList.add(new EmbeddedCorrConfigMode(94, 500.0, 1024, ConfigModeDecoder.eBits.BITS_2x2, true, ConfigModeDecoder.ePolarization.POLZ_FULL, ConfigModeDecoder.eFilterMode.FILTER_TFB, 0.99));
        this.modeList.add(new EmbeddedCorrConfigMode(95, 250.0, 1024, ConfigModeDecoder.eBits.BITS_2x2, true, ConfigModeDecoder.ePolarization.POLZ_FULL, ConfigModeDecoder.eFilterMode.FILTER_TFB, 0.98));
        this.modeList.add(new EmbeddedCorrConfigMode(96, 125.0, 1024, ConfigModeDecoder.eBits.BITS_2x2, true, ConfigModeDecoder.ePolarization.POLZ_FULL, ConfigModeDecoder.eFilterMode.FILTER_TFB, 0.97));
        this.modeList.add(new EmbeddedCorrConfigMode(97, 62.5, 1024, ConfigModeDecoder.eBits.BITS_2x2, true, ConfigModeDecoder.ePolarization.POLZ_FULL, ConfigModeDecoder.eFilterMode.FILTER_TFB, 0.96));
        this.modeList.add(new EmbeddedCorrConfigMode(98, 31.25, 2048, ConfigModeDecoder.eBits.BITS_2x2, true, ConfigModeDecoder.ePolarization.POLZ_FULL, ConfigModeDecoder.eFilterMode.FILTER_TFB, 0.91));
        this.modeList.add(new EmbeddedCorrConfigMode(99, 31.25, 1024, ConfigModeDecoder.eBits.BITS_2x2, true, ConfigModeDecoder.ePolarization.POLZ_FULL, ConfigModeDecoder.eFilterMode.FILTER_TFB, 0.88));
        this.modeList.add(new EmbeddedCorrConfigMode(100, 31.25, 512, ConfigModeDecoder.eBits.BITS_2x2, true, ConfigModeDecoder.ePolarization.POLZ_FULL, ConfigModeDecoder.eFilterMode.FILTER_TFB, 0.96));
        this.modeList.add(new EmbeddedCorrConfigMode(101, 31.25, 256, ConfigModeDecoder.eBits.BITS_2x2, true, ConfigModeDecoder.ePolarization.POLZ_FULL, ConfigModeDecoder.eFilterMode.FILTER_TFB, 0.88));
        this.modeList.add(new EmbeddedCorrConfigMode(102, 2000.0, 2048, ConfigModeDecoder.eBits.BITS_4x4, false, ConfigModeDecoder.ePolarization.POLZ_SINGLE_X, ConfigModeDecoder.eFilterMode.FILTER_TFB, 0.88));
        this.modeList.add(new EmbeddedCorrConfigMode(103, 1000.0, 2048, ConfigModeDecoder.eBits.BITS_4x4, false, ConfigModeDecoder.ePolarization.POLZ_SINGLE_X, ConfigModeDecoder.eFilterMode.FILTER_TFB, 0.88));
        this.modeList.add(new EmbeddedCorrConfigMode(104, 500.0, 2048, ConfigModeDecoder.eBits.BITS_4x4, false, ConfigModeDecoder.ePolarization.POLZ_SINGLE_X, ConfigModeDecoder.eFilterMode.FILTER_TFB, 0.88));
        this.modeList.add(new EmbeddedCorrConfigMode(105, 250.0, 2048, ConfigModeDecoder.eBits.BITS_4x4, false, ConfigModeDecoder.ePolarization.POLZ_SINGLE_X, ConfigModeDecoder.eFilterMode.FILTER_TFB, 0.88));
        this.modeList.add(new EmbeddedCorrConfigMode(106, 125.0, 2048, ConfigModeDecoder.eBits.BITS_4x4, false, ConfigModeDecoder.ePolarization.POLZ_SINGLE_X, ConfigModeDecoder.eFilterMode.FILTER_TFB, 0.88));
        this.modeList.add(new EmbeddedCorrConfigMode(107, 62.5, 2048, ConfigModeDecoder.eBits.BITS_4x4, false, ConfigModeDecoder.ePolarization.POLZ_SINGLE_X, ConfigModeDecoder.eFilterMode.FILTER_TFB, 0.88));
        this.modeList.add(new EmbeddedCorrConfigMode(108, 2000.0, 2048, ConfigModeDecoder.eBits.BITS_4x4, false, ConfigModeDecoder.ePolarization.POLZ_SINGLE_Y, ConfigModeDecoder.eFilterMode.FILTER_TFB, 0.88));
        this.modeList.add(new EmbeddedCorrConfigMode(109, 1000.0, 2048, ConfigModeDecoder.eBits.BITS_4x4, false, ConfigModeDecoder.ePolarization.POLZ_SINGLE_Y, ConfigModeDecoder.eFilterMode.FILTER_TFB, 0.88));
        this.modeList.add(new EmbeddedCorrConfigMode(110, 500.0, 2048, ConfigModeDecoder.eBits.BITS_4x4, false, ConfigModeDecoder.ePolarization.POLZ_SINGLE_Y, ConfigModeDecoder.eFilterMode.FILTER_TFB, 0.88));
        this.modeList.add(new EmbeddedCorrConfigMode(111, 250.0, 2048, ConfigModeDecoder.eBits.BITS_4x4, false, ConfigModeDecoder.ePolarization.POLZ_SINGLE_Y, ConfigModeDecoder.eFilterMode.FILTER_TFB, 0.88));
        this.modeList.add(new EmbeddedCorrConfigMode(112, 125.0, 2048, ConfigModeDecoder.eBits.BITS_4x4, false, ConfigModeDecoder.ePolarization.POLZ_SINGLE_Y, ConfigModeDecoder.eFilterMode.FILTER_TFB, 0.88));
        this.modeList.add(new EmbeddedCorrConfigMode(113, 62.5, 2048, ConfigModeDecoder.eBits.BITS_4x4, false, ConfigModeDecoder.ePolarization.POLZ_SINGLE_Y, ConfigModeDecoder.eFilterMode.FILTER_TFB, 0.88));
        this.modeList.add(new EmbeddedCorrConfigMode(114, 1000.0, 1024, ConfigModeDecoder.eBits.BITS_4x4, false, ConfigModeDecoder.ePolarization.POLZ_DOUBLE, ConfigModeDecoder.eFilterMode.FILTER_TFB, 0.88, 0.988));
        this.modeList.add(new EmbeddedCorrConfigMode(115, 500.0, 1024, ConfigModeDecoder.eBits.BITS_4x4, false, ConfigModeDecoder.ePolarization.POLZ_DOUBLE, ConfigModeDecoder.eFilterMode.FILTER_TFB, 0.88, 0.988));
        this.modeList.add(new EmbeddedCorrConfigMode(116, 250.0, 1024, ConfigModeDecoder.eBits.BITS_4x4, false, ConfigModeDecoder.ePolarization.POLZ_DOUBLE, ConfigModeDecoder.eFilterMode.FILTER_TFB, 0.88, 0.988));
        this.modeList.add(new EmbeddedCorrConfigMode(117, 125.0, 1024, ConfigModeDecoder.eBits.BITS_4x4, false, ConfigModeDecoder.ePolarization.POLZ_DOUBLE, ConfigModeDecoder.eFilterMode.FILTER_TFB, 0.88, 0.988));
        this.modeList.add(new EmbeddedCorrConfigMode(118, 62.5, 1024, ConfigModeDecoder.eBits.BITS_4x4, false, ConfigModeDecoder.ePolarization.POLZ_DOUBLE, ConfigModeDecoder.eFilterMode.FILTER_TFB, 0.88, 0.988));
        this.modeList.add(new EmbeddedCorrConfigMode(119, 125.0, 512, ConfigModeDecoder.eBits.BITS_4x4, false, ConfigModeDecoder.ePolarization.POLZ_FULL, ConfigModeDecoder.eFilterMode.FILTER_TFB, 0.88));
        this.modeList.add(new EmbeddedCorrConfigMode(120, 62.5, 512, ConfigModeDecoder.eBits.BITS_4x4, false, ConfigModeDecoder.ePolarization.POLZ_FULL, ConfigModeDecoder.eFilterMode.FILTER_TFB, 0.88));
        this.modeList.add(new EmbeddedCorrConfigMode(121, 1000.0, 1024, ConfigModeDecoder.eBits.BITS_4x4, true, ConfigModeDecoder.ePolarization.POLZ_SINGLE_X, ConfigModeDecoder.eFilterMode.FILTER_TFB, 0.88));
        this.modeList.add(new EmbeddedCorrConfigMode(122, 500.0, 1024, ConfigModeDecoder.eBits.BITS_4x4, true, ConfigModeDecoder.ePolarization.POLZ_SINGLE_X, ConfigModeDecoder.eFilterMode.FILTER_TFB, 0.88));
        this.modeList.add(new EmbeddedCorrConfigMode(123, 250.0, 1024, ConfigModeDecoder.eBits.BITS_4x4, true, ConfigModeDecoder.ePolarization.POLZ_SINGLE_X, ConfigModeDecoder.eFilterMode.FILTER_TFB, 0.88));
        this.modeList.add(new EmbeddedCorrConfigMode(124, 125.0, 1024, ConfigModeDecoder.eBits.BITS_4x4, true, ConfigModeDecoder.ePolarization.POLZ_SINGLE_X, ConfigModeDecoder.eFilterMode.FILTER_TFB, 0.88));
        this.modeList.add(new EmbeddedCorrConfigMode(125, 62.5, 1024, ConfigModeDecoder.eBits.BITS_4x4, true, ConfigModeDecoder.ePolarization.POLZ_SINGLE_X, ConfigModeDecoder.eFilterMode.FILTER_TFB, 0.88));
        this.modeList.add(new EmbeddedCorrConfigMode(126, 31.25, 2048, ConfigModeDecoder.eBits.BITS_4x4, true, ConfigModeDecoder.ePolarization.POLZ_SINGLE_X, ConfigModeDecoder.eFilterMode.FILTER_TFB, 0.88));
        this.modeList.add(new EmbeddedCorrConfigMode(127, 1000.0, 1024, ConfigModeDecoder.eBits.BITS_4x4, true, ConfigModeDecoder.ePolarization.POLZ_SINGLE_Y, ConfigModeDecoder.eFilterMode.FILTER_TFB, 0.88));
        this.modeList.add(new EmbeddedCorrConfigMode(128, 500.0, 1024, ConfigModeDecoder.eBits.BITS_4x4, true, ConfigModeDecoder.ePolarization.POLZ_SINGLE_Y, ConfigModeDecoder.eFilterMode.FILTER_TFB, 0.88));
        this.modeList.add(new EmbeddedCorrConfigMode(129, 250.0, 1024, ConfigModeDecoder.eBits.BITS_4x4, true, ConfigModeDecoder.ePolarization.POLZ_SINGLE_Y, ConfigModeDecoder.eFilterMode.FILTER_TFB, 0.88));
        this.modeList.add(new EmbeddedCorrConfigMode(130, 125.0, 1024, ConfigModeDecoder.eBits.BITS_4x4, true, ConfigModeDecoder.ePolarization.POLZ_SINGLE_Y, ConfigModeDecoder.eFilterMode.FILTER_TFB, 0.88));
        this.modeList.add(new EmbeddedCorrConfigMode(131, 62.5, 1024, ConfigModeDecoder.eBits.BITS_4x4, true, ConfigModeDecoder.ePolarization.POLZ_SINGLE_Y, ConfigModeDecoder.eFilterMode.FILTER_TFB, 0.88));
        this.modeList.add(new EmbeddedCorrConfigMode(132, 31.25, 2048, ConfigModeDecoder.eBits.BITS_4x4, true, ConfigModeDecoder.ePolarization.POLZ_SINGLE_Y, ConfigModeDecoder.eFilterMode.FILTER_TFB, 0.88));
        this.modeList.add(new EmbeddedCorrConfigMode(133, 500.0, 512, ConfigModeDecoder.eBits.BITS_4x4, true, ConfigModeDecoder.ePolarization.POLZ_DOUBLE, ConfigModeDecoder.eFilterMode.FILTER_TFB, 0.88));
        this.modeList.add(new EmbeddedCorrConfigMode(134, 250.0, 512, ConfigModeDecoder.eBits.BITS_4x4, true, ConfigModeDecoder.ePolarization.POLZ_DOUBLE, ConfigModeDecoder.eFilterMode.FILTER_TFB, 0.88));
        this.modeList.add(new EmbeddedCorrConfigMode(135, 125.0, 512, ConfigModeDecoder.eBits.BITS_4x4, true, ConfigModeDecoder.ePolarization.POLZ_DOUBLE, ConfigModeDecoder.eFilterMode.FILTER_TFB, 0.88));
        this.modeList.add(new EmbeddedCorrConfigMode(136, 62.5, 512, ConfigModeDecoder.eBits.BITS_4x4, true, ConfigModeDecoder.ePolarization.POLZ_DOUBLE, ConfigModeDecoder.eFilterMode.FILTER_TFB, 0.88));
        this.modeList.add(new EmbeddedCorrConfigMode(137, 31.25, 1024, ConfigModeDecoder.eBits.BITS_4x4, false, ConfigModeDecoder.ePolarization.POLZ_DOUBLE, ConfigModeDecoder.eFilterMode.FILTER_TFB, 0.88));
        this.modeList.add(new EmbeddedCorrConfigMode(138, 62.5, 256, ConfigModeDecoder.eBits.BITS_4x4, true, ConfigModeDecoder.ePolarization.POLZ_FULL, ConfigModeDecoder.eFilterMode.FILTER_TFB, 0.88));
        this.modeList.add(new EmbeddedCorrConfigMode(139, 31.25, 512, ConfigModeDecoder.eBits.BITS_4x4, false, ConfigModeDecoder.ePolarization.POLZ_FULL, ConfigModeDecoder.eFilterMode.FILTER_TFB, 0.88));
        this.modeList.add(new EmbeddedCorrConfigMode(140, 2000.0, 64, ConfigModeDecoder.eBits.BITS_3x3, false, ConfigModeDecoder.ePolarization.POLZ_SINGLE_X, ConfigModeDecoder.eFilterMode.FILTER_TDM, 0.88));
        this.modeList.add(new EmbeddedCorrConfigMode(141, 2000.0, 64, ConfigModeDecoder.eBits.BITS_3x3, false, ConfigModeDecoder.ePolarization.POLZ_SINGLE_Y, ConfigModeDecoder.eFilterMode.FILTER_TDM, 0.88));
        this.modeList.add(new EmbeddedCorrConfigMode(142, 2000.0, 128, 1937.5, 124, ConfigModeDecoder.eBits.BITS_2x2, false, ConfigModeDecoder.ePolarization.POLZ_DOUBLE, ConfigModeDecoder.eFilterMode.FILTER_TDM, 0.99));
        this.modeList.add(new EmbeddedCorrConfigMode(143, 2000.0, 64, 1937.5, 62, ConfigModeDecoder.eBits.BITS_2x2, false, ConfigModeDecoder.ePolarization.POLZ_FULL, ConfigModeDecoder.eFilterMode.FILTER_TDM, 0.99));
        this.modeList.add(new EmbeddedCorrConfigMode(144, 2000.0, 256, 1937.5, 248, ConfigModeDecoder.eBits.BITS_2x2, false, ConfigModeDecoder.ePolarization.POLZ_SINGLE_X, ConfigModeDecoder.eFilterMode.FILTER_TDM, 0.99));
        this.modeList.add(new EmbeddedCorrConfigMode(145, 2000.0, 256, 1937.5, 248, ConfigModeDecoder.eBits.BITS_2x2, false, ConfigModeDecoder.ePolarization.POLZ_SINGLE_Y, ConfigModeDecoder.eFilterMode.FILTER_TDM, 0.99));
        this.modeMap = new TreeMap();
        for (EmbeddedCorrConfigMode embeddedCorrConfigMode : this.modeList) {
            this.modeMap.put(embeddedCorrConfigMode.mode, embeddedCorrConfigMode);
        }
        this.knownModesSet = new TreeSet();
        this.knownNominalChannelsSet = new TreeSet();
        this.knownNominalBandwidthsSet = new TreeSet();
        for (EmbeddedCorrConfigMode embeddedCorrConfigMode : this.modeList) {
            if (embeddedCorrConfigMode.mode == 0) continue;
            this.knownModesSet.add(embeddedCorrConfigMode.mode);
            this.knownNominalChannelsSet.add(embeddedCorrConfigMode.channels);
            this.knownNominalBandwidthsSet.add(embeddedCorrConfigMode.bandWidth);
        }
    }

    @Override
    public int findMode(float f, long l, ConfigModeDecoder.eBits eBits2, boolean bl, ConfigModeDecoder.ePolarization ePolarization2, ConfigModeDecoder.eFilterMode eFilterMode2) throws ConfigModeDecoder.ConfigModeException {
        for (EmbeddedCorrConfigMode embeddedCorrConfigMode : this.modeList) {
            if (l != (long)embeddedCorrConfigMode.channels || eBits2 != embeddedCorrConfigMode.bits || bl != embeddedCorrConfigMode.isOverSampled || eFilterMode2 != embeddedCorrConfigMode.filter || !(Math.abs((double)(f * 1000.0f) - embeddedCorrConfigMode.bandWidth) < 1.0E-5) || ePolarization2 != embeddedCorrConfigMode.polarizationProducts) continue;
            return embeddedCorrConfigMode.mode;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("BW=" + f * 1000.0f + "MHz,").append("CH=" + l + ",").append("bits=" + String.valueOf((Object)eBits2) + ",").append("OS=" + bl + ",").append("PP=" + String.valueOf((Object)ePolarization2) + ",").append("filter=" + String.valueOf((Object)eFilterMode2));
        throw new ConfigModeDecoder.ConfigModeException("Unsupported combination : " + stringBuilder.toString());
    }

    private EmbeddedCorrConfigMode getCorrConfigMode(int n) {
        return this.modeMap.get(n);
    }

    @Override
    public ConfigModeDecoder.eBits getBits(int n) throws ConfigModeDecoder.ConfigModeException {
        this.checkMode(n);
        return this.getCorrConfigMode((int)n).bits;
    }

    @Override
    public long getChannels(int n) throws ConfigModeDecoder.ConfigModeException {
        return this.getChannels(n, false);
    }

    @Override
    public long getChannels(int n, boolean bl) throws ConfigModeDecoder.ConfigModeException {
        this.checkMode(n);
        return bl ? (long)this.getCorrConfigMode((int)n).acaChProfChannels : (long)this.getCorrConfigMode((int)n).channels;
    }

    @Override
    public float getEffectiveBandwidthGHz(int n) throws ConfigModeDecoder.ConfigModeException {
        return this.getEffectiveBandwidthGHz(n, false);
    }

    public float getEffectiveBandwidthGHz(int n, boolean bl) throws ConfigModeDecoder.ConfigModeException {
        this.checkMode(n);
        return bl ? (float)this.getCorrConfigMode(n).getACAChProfEffectiveBandwidth() / 1000.0f : (float)this.getCorrConfigMode(n).getEffectiveBandwidth() / 1000.0f;
    }

    @Override
    public float getNominalBandwidthGHz(int n) throws ConfigModeDecoder.ConfigModeException {
        return this.getNominalBandwidthGHz(n, false);
    }

    @Override
    public float getNominalBandwidthGHz(int n, boolean bl) throws ConfigModeDecoder.ConfigModeException {
        this.checkMode(n);
        return bl ? (float)(this.getCorrConfigMode((int)n).acaChProfBandWidth / 1000.0) : (float)(this.getCorrConfigMode((int)n).bandWidth / 1000.0);
    }

    @Override
    public float getEffectiveResolutionGHz(int n) throws ConfigModeDecoder.ConfigModeException {
        this.checkMode(n);
        return (float)this.getCorrConfigMode(n).getResolutionMHz() / 1000.0f;
    }

    @Override
    public ConfigModeDecoder.eFilterMode getFilterMode(int n) throws ConfigModeDecoder.ConfigModeException {
        this.checkMode(n);
        return this.getCorrConfigMode((int)n).filter;
    }

    @Override
    public ConfigModeDecoder.ePolarization getPolarizationProducts(int n) throws ConfigModeDecoder.ConfigModeException {
        this.checkMode(n);
        return this.getCorrConfigMode((int)n).polarizationProducts;
    }

    @Override
    public boolean isOversampled(int n) throws ConfigModeDecoder.ConfigModeException {
        this.checkMode(n);
        return this.getCorrConfigMode((int)n).isOverSampled;
    }

    @Override
    public double getBLEfficiency(int n) throws ConfigModeDecoder.ConfigModeException {
        this.checkMode(n);
        return this.getCorrConfigMode(n).getBLEfficiency();
    }

    @Override
    public double getACAEfficiency(int n) throws ConfigModeDecoder.ConfigModeException {
        this.checkMode(n);
        return this.getCorrConfigMode(n).getACAEfficiency();
    }

    @Override
    public long[] getKnownChannels() {
        TreeSet<Integer> treeSet = this.knownNominalChannelsSet;
        if (this.knownChannels == null) {
            this.knownChannels = new long[treeSet.size()];
            int n = 0;
            for (Integer n2 : treeSet) {
                this.knownChannels[n++] = n2.intValue();
            }
        }
        return this.knownChannels;
    }

    @Override
    public int[] getKnownModes() {
        TreeSet<Integer> treeSet = this.knownModesSet;
        if (this.knownModes == null) {
            this.knownModes = new int[treeSet.size()];
            int n = 0;
            for (Integer n2 : treeSet) {
                this.knownModes[n++] = n2;
            }
        }
        return this.knownModes;
    }

    @Override
    public float[] getKnownNominalBandwidths() {
        TreeSet<Double> treeSet = this.knownNominalBandwidthsSet;
        if (this.knownNominalBandwidths == null) {
            this.knownNominalBandwidths = new float[treeSet.size()];
            int n = 0;
            for (Double d : treeSet) {
                this.knownNominalBandwidths[n++] = d.floatValue();
            }
        }
        return this.knownNominalBandwidths;
    }

    private void checkMode(int n) throws ConfigModeDecoder.ConfigModeException {
        if (n > 0 && this.knownModesSet.contains(n)) {
            return;
        }
        throw new ConfigModeDecoder.ConfigModeException("Unknown mode : " + n);
    }

    private static class EmbeddedCorrConfigMode {
        private static final double CORR_CONFIG_MODE_TFB_DROPOFF_FRACTION = 16.0;
        private static final double BL_2X2_EFFICIENCY = 0.88;
        private int mode;
        private double bandWidth;
        private int channels;
        private double acaChProfBandWidth;
        private int acaChProfChannels;
        private ConfigModeDecoder.eBits bits;
        private boolean isOverSampled;
        private ConfigModeDecoder.ePolarization polarizationProducts;
        private ConfigModeDecoder.eFilterMode filter;
        private double blEfficiency = 0.88;
        private double acaEfficiency;

        public EmbeddedCorrConfigMode(int n, double d, int n2, double d2, int n3, ConfigModeDecoder.eBits eBits2, boolean bl, ConfigModeDecoder.ePolarization ePolarization2, ConfigModeDecoder.eFilterMode eFilterMode2, double d3, double d4) {
            this.mode = n;
            this.bandWidth = d;
            this.channels = n2;
            this.acaChProfBandWidth = d2;
            this.acaChProfChannels = n3;
            this.bits = eBits2;
            this.isOverSampled = bl;
            this.polarizationProducts = ePolarization2;
            this.filter = eFilterMode2;
            this.acaEfficiency = d3;
            this.blEfficiency = d4;
        }

        public EmbeddedCorrConfigMode(int n, double d, int n2, double d2, int n3, ConfigModeDecoder.eBits eBits2, boolean bl, ConfigModeDecoder.ePolarization ePolarization2, ConfigModeDecoder.eFilterMode eFilterMode2, double d3) {
            this(n, d, n2, d, n2, eBits2, bl, ePolarization2, eFilterMode2, d3, 0.88);
        }

        private EmbeddedCorrConfigMode(int n, double d, int n2, ConfigModeDecoder.eBits eBits2, boolean bl, ConfigModeDecoder.ePolarization ePolarization2, ConfigModeDecoder.eFilterMode eFilterMode2, double d2) {
            this(n, d, n2, d, n2, eBits2, bl, ePolarization2, eFilterMode2, d2);
        }

        private EmbeddedCorrConfigMode(int n, double d, int n2, ConfigModeDecoder.eBits eBits2, boolean bl, ConfigModeDecoder.ePolarization ePolarization2, ConfigModeDecoder.eFilterMode eFilterMode2, double d2, double d3) {
            this(n, d, n2, d, n2, eBits2, bl, ePolarization2, eFilterMode2, d2, d3);
        }

        private EmbeddedCorrConfigMode(int n, double d, int n2, ConfigModeDecoder.eBits eBits2, boolean bl, ConfigModeDecoder.ePolarization ePolarization2, ConfigModeDecoder.eFilterMode eFilterMode2) {
            this(n, d, n2, eBits2, bl, ePolarization2, eFilterMode2, 0.88);
        }

        public double getEffectiveBandwidth() {
            if (this.filter == ConfigModeDecoder.eFilterMode.FILTER_TFB) {
                return this.bandWidth * 0.9375;
            }
            return this.bandWidth;
        }

        public double getACAChProfEffectiveBandwidth() {
            if (this.filter == ConfigModeDecoder.eFilterMode.FILTER_TFB) {
                return this.acaChProfBandWidth * 0.9375;
            }
            return this.acaChProfBandWidth;
        }

        protected int getEffectiveChannels() {
            if (this.filter == ConfigModeDecoder.eFilterMode.FILTER_TFB) {
                return (int)((double)this.channels * 0.9375);
            }
            return this.channels;
        }

        public double getResolutionMHz() {
            return this.bandWidth / (double)this.channels;
        }

        public double getACAEfficiency() {
            return this.acaEfficiency;
        }

        public double getBLEfficiency() {
            return this.blEfficiency;
        }
    }
}

