/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.bo.schedblock;

import alma.entity.xmlbinding.schedblock.ACASpectrometerCorrelatorConfigurationT;
import alma.observatorycharacteristics.capabilities.AlmaCapabilities;
import alma.obsprep.bo.enumerations.Array;
import alma.obsprep.bo.enumerations.CorrelatorType;
import alma.obsprep.bo.schedblock.ACABaseBandConfig;
import alma.obsprep.bo.schedblock.AbstractBaseBandConfig;
import alma.obsprep.bo.schedblock.AbstractCorrelatorConfiguration;
import alma.obsprep.bo.schedblock.data.ACASpectrometerCorrelatorConfigurationData;
import alma.obsprep.services.experts.CorrelatorExpert;
import alma.valuetypes.Time;

public class ACASpectrometerCorrelatorConfiguration
extends ACASpectrometerCorrelatorConfigurationData {
    static double DEF_DUMPDURATION_SECS = 0.016;

    public ACASpectrometerCorrelatorConfiguration(ACASpectrometerCorrelatorConfigurationT aCASpectrometerCorrelatorConfigurationT) {
        super(aCASpectrometerCorrelatorConfigurationT);
    }

    protected void initAsNew() {
        super.initAsNew();
        CorrelatorExpert correlatorExpert = CorrelatorExpert.getACAInstance();
        double d = correlatorExpert.calcChannelAverageDurationInsecs(1.0, DEF_DUMPDURATION_SECS);
        this.getChannelAverageDuration().setContentAndUnit(d, Time.UNIT_S);
        double d2 = correlatorExpert.calcIntegrationDurationInsecs(5.0, this.getChannelAverageDuration().getContentInUnits(Time.UNIT_S));
        this.getIntegrationDuration().setContentAndUnit(d2, Time.UNIT_S);
        this.getACAPhaseSwitchingConfiguration().setDoD180demodulation(false);
        this.getACAPhaseSwitchingConfiguration().setDoD180modulation(false);
    }

    public CorrelatorType getCorrelatorType() {
        return CorrelatorType.ACA;
    }

    public int getBaseBandConfigCount() {
        return this.getACABaseBandConfigCount();
    }

    public AbstractBaseBandConfig getBaseBandConfig(int n) {
        return this.getACABaseBandConfig(n);
    }

    public ACABaseBandConfig[] getBaseBandConfig() {
        return this.getACABaseBandConfig();
    }

    public ACABaseBandConfig newBaseBandConfig() {
        return ACABaseBandConfig.createACABaseBandConfig();
    }

    public void clearBaseBandConfig() {
        this.clearACABaseBandConfig();
    }

    public void clearACABaseBandConfig() {
        int n = this.getACABaseBandConfigCount();
        for (int i = 0; i < n; ++i) {
            ACABaseBandConfig aCABaseBandConfig = this.getACABaseBandConfig(0);
            this.primitiveRemoveBaseBandConfig((AbstractBaseBandConfig)((Object)aCABaseBandConfig));
        }
    }

    public ACABaseBandConfig primitiveAddBaseBandConfig(int n, AbstractBaseBandConfig abstractBaseBandConfig) {
        ACABaseBandConfig aCABaseBandConfig = (ACABaseBandConfig)((Object)abstractBaseBandConfig);
        super.addACABaseBandConfig(n, aCABaseBandConfig);
        return aCABaseBandConfig;
    }

    public boolean primitiveRemoveBaseBandConfig(AbstractBaseBandConfig abstractBaseBandConfig) {
        ACABaseBandConfig aCABaseBandConfig = (ACABaseBandConfig)((Object)abstractBaseBandConfig);
        return super.removeACABaseBandConfig(aCABaseBandConfig);
    }

    public void addACABaseBandConfig(ACABaseBandConfig aCABaseBandConfig) {
        this.primitiveAddBaseBandConfig(this.getACABaseBandConfigCount(), (AbstractBaseBandConfig)((Object)aCABaseBandConfig));
    }

    public void setACABaseBandConfig(ACABaseBandConfig[] aCABaseBandConfigArray) {
        this.clearACABaseBandConfig();
        for (int i = 0; i < aCABaseBandConfigArray.length; ++i) {
            this.primitiveAddBaseBandConfig(i, (AbstractBaseBandConfig)((Object)aCABaseBandConfigArray[i]));
        }
    }

    public int getNumAntennas() {
        AlmaCapabilities almaCapabilities = AlmaCapabilities.getInstance();
        return almaCapabilities.getNumAntennas(Array.ARRAY_7M, (AbstractCorrelatorConfiguration)((Object)this));
    }
}

