/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.bo.obsproposal;

import alma.entity.xmlbinding.obsproposal.ReceiverTimeBreakdownT;
import alma.obsprep.bo.obsproposal.ReceiverTime;
import alma.obsprep.bo.obsproposal.data.ReceiverTimeBreakdownData;
import alma.obsprep.bo.schedblock.ReceiverBand;
import alma.obsprep.services.experts.InvalidReceiverBandException;

public class ReceiverTimeBreakdown
extends ReceiverTimeBreakdownData {
    public ReceiverTimeBreakdown(ReceiverTimeBreakdownT receiverTimeBreakdownT) {
        super(receiverTimeBreakdownT);
    }

    public void setReceiverTime(ReceiverTime receiverTime) throws InvalidReceiverBandException {
        if (receiverTime == null) {
            throw new IllegalArgumentException("Can not set null as a receiver time.");
        }
        String string = receiverTime.getReceiverBand();
        if (string == null) {
            throw new NullPointerException("receiverBand in ReceiverName must not be null");
        }
        ReceiverBand receiverBand = ReceiverBand.getReceiverBand(string);
        if (receiverBand == null || receiverBand == ReceiverBand.ILLEGAL_RECEIVER) {
            throw new InvalidReceiverBandException(receiverBand);
        }
        int n = this.indexOf(receiverBand);
        if (n >= 0) {
            ReceiverTime receiverTime2 = this.getReceiverTime(n);
            this.removeReceiverTime(receiverTime2);
        }
        this.addReceiverTime(receiverTime);
    }

    public ReceiverTime getReceiverTime(String string) {
        return this.getReceiverTime(ReceiverBand.getReceiverBand(string));
    }

    public ReceiverTime getReceiverTime(ReceiverBand receiverBand) {
        if (receiverBand == null || receiverBand == ReceiverBand.ILLEGAL_RECEIVER) {
            throw new IllegalArgumentException("Illegal ReceiverBand : " + String.valueOf(receiverBand));
        }
        int n = this.indexOf(receiverBand);
        if (n >= 0) {
            return this.getReceiverTime(n);
        }
        ReceiverTime receiverTime = ReceiverTime.createReceiverTime(receiverBand);
        this.addReceiverTime(receiverTime);
        return receiverTime;
    }

    public void addReceiverTime(int n, ReceiverTime receiverTime) throws IndexOutOfBoundsException {
        ReceiverBand receiverBand = ReceiverBand.getReceiverBand(receiverTime.getReceiverBand());
        if (this.indexOf(receiverBand) >= 0) {
            String string = "Could not add arrayDataRates for " + String.valueOf(receiverBand) + ". Already exists.";
            throw new IllegalArgumentException(string);
        }
        super.addReceiverTime(n, receiverTime);
    }

    private int indexOf(ReceiverBand receiverBand) {
        ReceiverTime[] receiverTimeArray = this.getReceiverTime();
        for (int i = 0; i < receiverTimeArray.length; ++i) {
            ReceiverTime receiverTime = receiverTimeArray[i];
            if (!receiverTime.getReceiverBand().equals(receiverBand.getName())) continue;
            return i;
        }
        return -1;
    }
}

