/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.bo.obsproject;

import alma.obsprep.bo.obsproject.RepresentativeFrequencyChangeEvent;
import alma.obsprep.bo.obsproject.RepresentativeFrequencyListener;
import alma.obsprep.bo.obsproject.SpectralSetupParameters;
import alma.valuetypes.Frequency;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collection;
import java.util.concurrent.CopyOnWriteArrayList;
import lombok.NonNull;

public class RepresentativeFrequencyListenerHelper {
    private final Collection<RepresentativeFrequencyListener> listenersForRFChanges = new CopyOnWriteArrayList<RepresentativeFrequencyListener>();
    private final FrequencyReplacedListener freqReplacedListener = new FrequencyReplacedListener();
    private final FrequencyChangedListener freqChangedListener = new FrequencyChangedListener();

    public void add(RepresentativeFrequencyListener representativeFrequencyListener) {
        if (!this.listenersForRFChanges.contains(representativeFrequencyListener)) {
            this.listenersForRFChanges.add(representativeFrequencyListener);
        }
    }

    public boolean remove(RepresentativeFrequencyListener representativeFrequencyListener) {
        return this.listenersForRFChanges.remove(representativeFrequencyListener);
    }

    public void listenTo(@NonNull SpectralSetupParameters spectralSetupParameters) {
        if (spectralSetupParameters == null) {
            throw new NullPointerException("spectralSetupParameters is marked non-null but is null");
        }
        this.freqReplacedListener.listenTo(spectralSetupParameters);
        this.freqChangedListener.listenTo(spectralSetupParameters.gettrueRepresentativeFrequency());
    }

    private class FrequencyReplacedListener
    implements PropertyChangeListener {
        private SpectralSetupParameters sspBOToListenTo;

        private FrequencyReplacedListener() {
        }

        void listenTo(SpectralSetupParameters spectralSetupParameters) {
            if (this.sspBOToListenTo != null) {
                this.sspBOToListenTo.removePropertyChangeListener(this);
            }
            this.sspBOToListenTo = spectralSetupParameters;
            if (spectralSetupParameters != null) {
                this.sspBOToListenTo.addPropertyChangeListener(this);
            }
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            Object object = propertyChangeEvent.getSource();
            if (object instanceof SpectralSetupParameters && string.endsWith("SpectralSetupParameters.representativeFrequency")) {
                SpectralSetupParameters spectralSetupParameters = (SpectralSetupParameters)((Object)object);
                RepresentativeFrequencyListenerHelper.this.freqChangedListener.listenTo(spectralSetupParameters.getRepresentativeFrequency());
                RepresentativeFrequencyListenerHelper.this.freqChangedListener.publishFreqChangeEvent();
            }
        }
    }

    private class FrequencyChangedListener
    implements PropertyChangeListener {
        private Frequency rfBusinessObjectToListenTo;

        private FrequencyChangedListener() {
        }

        void listenTo(Frequency frequency) {
            if (this.rfBusinessObjectToListenTo != null) {
                this.rfBusinessObjectToListenTo.removePropertyChangeListener(this);
            }
            this.rfBusinessObjectToListenTo = frequency;
            if (frequency != null) {
                this.rfBusinessObjectToListenTo.addPropertyChangeListener(this);
            }
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            this.publishFreqChangeEvent();
        }

        void publishFreqChangeEvent() {
            RepresentativeFrequencyChangeEvent representativeFrequencyChangeEvent = new RepresentativeFrequencyChangeEvent((Object)this.rfBusinessObjectToListenTo);
            for (RepresentativeFrequencyListener representativeFrequencyListener : RepresentativeFrequencyListenerHelper.this.listenersForRFChanges) {
                representativeFrequencyListener.representativeFrequencyUpdated(representativeFrequencyChangeEvent);
            }
        }
    }
}

