/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.bo.obsproject;

import alma.entity.xmlbinding.obsproject.PerformanceParametersT;
import alma.entity.xmlbinding.obsproject.types.PerformanceParametersTResolutionOptionType;
import alma.hla.runtime.obsprep.bo.AbstractDoubleWithUnit;
import alma.hla.runtime.obsprep.bo.CopyException;
import alma.hla.runtime.obsprep.bo.IBusinessObject;
import alma.hla.runtime.obsprep.bo.ReferenceableProxy;
import alma.hla.runtime.obsprep.bo.ReferenceablesMap;
import alma.hla.runtime.obsprep.bo.ValueUnitPair;
import alma.hla.runtime.obsprep.util.Log;
import alma.hla.runtime.obsprep.util.UnknownEntityException;
import alma.obsprep.bo.enumerations.Array;
import alma.obsprep.bo.enumerations.ArrayType;
import alma.obsprep.bo.obsproject.AbstractScienceGoal;
import alma.obsprep.bo.obsproject.MonitoringConstraint;
import alma.obsprep.bo.obsproject.ObsProject;
import alma.obsprep.bo.obsproject.RepresentativeFrequencyChangeEvent;
import alma.obsprep.bo.obsproject.RepresentativeFrequencyListener;
import alma.obsprep.bo.obsproject.ScienceGoal;
import alma.obsprep.bo.obsproject.SpectralSetupParameters;
import alma.obsprep.bo.obsproject.TargetParameters;
import alma.obsprep.bo.obsproject.TemporalParameters;
import alma.obsprep.bo.obsproject.VisitConstraint;
import alma.obsprep.bo.obsproject.data.PerformanceParametersData;
import alma.obsprep.ot.actions.RetrieveAsNewACASupplementalCallProposalPerformer;
import alma.obsprep.ot.models.sciencegoals.AngularResolutionMode;
import alma.obsprep.ot.models.sciencegoals.SfiControlParameterModel;
import alma.obsprep.services.experts.Configuration;
import alma.obsprep.services.experts.InvalidConfigurationParametersException;
import alma.obsprep.services.generator.InvalidObsProgramParametersException;
import alma.obsprep.services.generator.WizardSBGenerationException;
import alma.obsprep.services.generator.refactored.RequestedArray;
import alma.valuetypes.Angle;
import alma.valuetypes.Frequency;
import alma.valuetypes.Length;
import alma.valuetypes.Time;
import alma.valuetypes.UserAngle;
import alma.valuetypes.UserFrequency;
import alma.valuetypes.UserSensitivity;
import java.beans.PropertyChangeListener;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import lombok.NonNull;

public class PerformanceParameters
extends PerformanceParametersData
implements RepresentativeFrequencyListener {
    private final Map<AngularResolutionMode, UserAngle> previousDesiredARValues = new HashMap<AngularResolutionMode, UserAngle>();
    private final Map<AngularResolutionMode, UserAngle> previousAcceptableARValues = new HashMap<AngularResolutionMode, UserAngle>();

    public PerformanceParameters(PerformanceParametersT performanceParametersT) {
        super(performanceParametersT);
    }

    protected void initAsNew() {
        super.initAsNew();
        this.setResolutionOption(PerformanceParametersData.RESOLUTIONOPTION_SINGLE);
        this.getDesiredAngularResolution().setUserUnitList(UserAngle.units_AngularResolutionAngle);
        this.getDesiredAngularResolution().setUserUnit(UserAngle.USERUNIT_ARCSEC);
        this.getAcceptableAngularResolution().setUserUnitList(UserAngle.units_AngularResolutionAngle);
        this.getAcceptableAngularResolution().setUserUnit(UserAngle.USERUNIT_ARCSEC);
        this.getDesiredLargestScale().setContentAndUnit(-1.0, Angle.UNIT_ARCSEC);
        this.setDesiredSDSensitivity(UserSensitivity.createUserSensitivity(0.0, UserSensitivity.UNIT_JY));
        this.setDesiredDynamicRange(1.0);
        this.setDesiredTime(Time.createTime((double)0.0, (String)Time.UNIT_MIN));
        this.setUseTP(false);
        this.setUseACA(false);
        this.getDesiredSensitivityReferenceFrequencyWidth().setUserUnit(UserFrequency.USERUNIT_MHZ);
        this.getDesiredSensitivityReferenceFrequencyWidth().setContentInMHz(0.0);
        this.configureSensitivityReferenceFrequencyWidthUpdater();
    }

    public String getName() {
        return super.getName();
    }

    public ScienceGoal getScienceGoal() {
        return (ScienceGoal)this.getParent();
    }

    public SpectralSetupParameters getSpectralSetupParameters() {
        ScienceGoal scienceGoal = this.getScienceGoal();
        if (scienceGoal == null) {
            return null;
        }
        return scienceGoal.getSpectralSetupParameters();
    }

    public Angle getACAAngularResolution() {
        Double d = null;
        ScienceGoal scienceGoal = this.getScienceGoal();
        if (scienceGoal != null && scienceGoal.getTargetParameters() != null) {
            try {
                double d2 = this.getRepresentativeFrequency().getContentInGHz();
                Configuration configuration = Configuration.getBestConfiguration(d2, RequestedArray.SEVEN_M, scienceGoal);
                assert (configuration != null);
                d = configuration.getAchievableResolution(d2, scienceGoal, RequestedArray.SEVEN_M);
                assert (d != null);
            }
            catch (InvalidConfigurationParametersException invalidConfigurationParametersException) {
                // empty catch block
            }
        }
        if (d == null) {
            Length length = Length.createLength((double)30.0, (String)Length.UNIT_M);
            return Array.syntheticBeamsize(this.getRepresentativeFrequency(), length);
        }
        assert (d != null);
        return Angle.createAngle((double)d, (String)Angle.UNIT_ARCSEC);
    }

    public Angle getTPAngularResolution() {
        Frequency frequency = this.getRepresentativeFrequency();
        return Array.ARRAY_TP.antenna.getBeamSize(frequency);
    }

    public synchronized void setRepresentativeFrequency(Frequency frequency) {
        super.setRepresentativeFrequency(frequency);
        this.getDesiredAngularResolution().setObservingFrequency(frequency);
        this.getAcceptableAngularResolution().setObservingFrequency(frequency);
        this.getDesiredSensitivity().setObservingFrequency(frequency);
        this.getDesiredACASensitivity().setObservingFrequency(frequency);
        this.getDesiredTPSensitivity().setObservingFrequency(frequency);
        if (this.gettrueDesiredSensitivityReferenceFrequencyWidth() != null) {
            this.gettrueDesiredSensitivityReferenceFrequencyWidth().setObservingFrequency(frequency);
        }
    }

    public synchronized void setDesiredAngularResolution(UserAngle userAngle) {
        super.setDesiredAngularResolution(userAngle);
        userAngle.setObservingFrequency(this.getRepresentativeFrequency());
    }

    public synchronized void setAcceptableAngularResolution(UserAngle userAngle) {
        super.setAcceptableAngularResolution(userAngle);
        userAngle.setObservingFrequency(this.getRepresentativeFrequency());
    }

    public synchronized void setDesiredSensitivity(UserSensitivity userSensitivity) {
        super.setDesiredSensitivity(userSensitivity);
        userSensitivity.setObservingFrequency(this.getRepresentativeFrequency());
        userSensitivity.setBeamsize((Angle)((Object)this.getDesiredAngularResolution()));
    }

    public synchronized void setDesiredSensitivityReferenceFrequencyWidth(UserFrequency userFrequency) {
        super.setDesiredSensitivityReferenceFrequencyWidth(userFrequency);
        userFrequency.setObservingFrequency(this.getRepresentativeFrequency());
    }

    public synchronized void setDesiredACASensitivity(UserSensitivity userSensitivity) {
        super.setDesiredACASensitivity(userSensitivity);
        userSensitivity.setObservingFrequency(this.getRepresentativeFrequency());
        userSensitivity.setBeamsize(this.getACAAngularResolution());
    }

    public synchronized void setDesiredTPSensitivity(UserSensitivity userSensitivity) {
        super.setDesiredTPSensitivity(userSensitivity);
        userSensitivity.setObservingFrequency(this.getRepresentativeFrequency());
        userSensitivity.setBeamsize(this.getTPAngularResolution());
    }

    public void wrapObjects(ReferenceablesMap referenceablesMap, List<ReferenceableProxy<? extends IBusinessObject>> list) {
        UserFrequency userFrequency;
        UserSensitivity userSensitivity;
        super.wrapObjects(referenceablesMap, list);
        UserAngle userAngle = this.gettrueDesiredAngularResolution();
        if (userAngle != null) {
            userAngle.unitMap().suspendUnitMapUpdater();
            userAngle.setObservingFrequency(this.getRepresentativeFrequency());
            userAngle.unitMap().resumeUnitMapUpdater();
            userAngle.setUserUnitList(UserAngle.units_AngularResolutionAngle);
        }
        if ((userAngle = this.gettrueAcceptableAngularResolution()) != null) {
            userAngle.unitMap().suspendUnitMapUpdater();
            userAngle.setObservingFrequency(this.getRepresentativeFrequency());
            userAngle.unitMap().resumeUnitMapUpdater();
            userAngle.setUserUnitList(UserAngle.units_AngularResolutionAngle);
        }
        if ((userSensitivity = this.gettrueDesiredSensitivity()) != null) {
            userSensitivity.unitMap().suspendUnitMapUpdater();
            userSensitivity.setObservingFrequency(this.getRepresentativeFrequency());
            userSensitivity.setBeamsize((Angle)((Object)this.getDesiredAngularResolution()));
            userSensitivity.unitMap().resumeUnitMapUpdater();
        }
        if ((userFrequency = this.gettrueDesiredSensitivityReferenceFrequencyWidth()) != null) {
            userFrequency.unitMap().suspendUnitMapUpdater();
            userFrequency.setObservingFrequency(this.getRepresentativeFrequency());
            userFrequency.unitMap().resumeUnitMapUpdater();
        }
        if ((userSensitivity = this.gettrueDesiredACASensitivity()) != null) {
            userSensitivity.unitMap().suspendUnitMapUpdater();
            userSensitivity.setObservingFrequency(this.getRepresentativeFrequency());
            userSensitivity.setBeamsize(this.getACAAngularResolution());
            userSensitivity.unitMap().resumeUnitMapUpdater();
        }
        if ((userSensitivity = this.gettrueDesiredTPSensitivity()) != null) {
            userSensitivity.unitMap().suspendUnitMapUpdater();
            userSensitivity.setObservingFrequency(this.getRepresentativeFrequency());
            userSensitivity.setBeamsize(this.getTPAngularResolution());
            userSensitivity.unitMap().resumeUnitMapUpdater();
        }
    }

    private void configureSensitivityReferenceFrequencyWidthUpdater() {
        PropertyChangeListener propertyChangeListener = propertyChangeEvent -> {
            String string;
            if (propertyChangeEvent.getPropertyName().endsWith("desiredSensitivityFrequencyMeasure") && !DESIREDSENSITIVITYFREQUENCYMEASURE_USER.equals(string = (String)propertyChangeEvent.getNewValue())) {
                this.getDesiredSensitivityReferenceFrequencyWidth().setContent(0.0);
            }
        };
        this.addPropertyChangeListener(propertyChangeListener);
    }

    public boolean isUserSpecificFrequencyWidth() {
        return this.getDesiredSensitivityFrequencyMeasure().equals(DESIREDSENSITIVITYFREQUENCYMEASURE_USER);
    }

    public Frequency getSensitivityFrequencyWidth() {
        if (this.isUserSpecificFrequencyWidth()) {
            return this.getDesiredSensitivityReferenceFrequencyWidth();
        }
        SpectralSetupParameters spectralSetupParameters = this.getSpectralSetupParameters();
        if (spectralSetupParameters == null) {
            return Frequency.createFrequency();
        }
        String string = this.getDesiredSensitivityFrequencyMeasure();
        return spectralSetupParameters.getDesiredSensitivityFrequencyWidth(string);
    }

    public UserFrequency getSensitivityFrequencyWidthAsUF() {
        if (this.isUserSpecificFrequencyWidth()) {
            return this.getDesiredSensitivityReferenceFrequencyWidth();
        }
        SpectralSetupParameters spectralSetupParameters = this.getSpectralSetupParameters();
        UserFrequency userFrequency = UserFrequency.createUserFrequency();
        if (spectralSetupParameters == null) {
            return userFrequency;
        }
        String string = this.getDesiredSensitivityFrequencyMeasure();
        userFrequency.setContentAndUnit((ValueUnitPair)spectralSetupParameters.getDesiredSensitivityFrequencyWidth(string));
        userFrequency.setObservingFrequency(this.getRepresentativeFrequencyWithSkyOffset());
        return userFrequency;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(super.toString()).append("[");
        stringBuilder.append("repfreq=").append((Object)this.getRepresentativeFrequency()).append(", ");
        stringBuilder.append("angres=").append(this.getDesiredAngularResolution()).append(", ");
        stringBuilder.append("lscal=").append((Object)this.getDesiredLargestScale()).append(", ");
        stringBuilder.append("sens=").append(this.getDesiredSensitivity()).append(", ");
        stringBuilder.append("range=").append(this.getDesiredDynamicRange()).append(", ");
        stringBuilder.append("useaca=").append(this.gettrueUseACA()).append(", ");
        stringBuilder.append("acasens=").append(this.getDesiredACASensitivity()).append(", ");
        stringBuilder.append("tpsens=").append(this.getDesiredTPSensitivity()).append(", ");
        stringBuilder.append("tconstr=").append(this.gettrueIsTimeConstrained());
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    public boolean getIsEquivalentToPointSource() {
        return this.getDesiredLargestScale().getContentInUnits(Angle.UNIT_ARCSEC) <= this.getDesiredAngularResolution().getContentInUnits(Angle.UNIT_ARCSEC);
    }

    public Frequency getRepresentativeFrequencyWithSkyOffset() {
        SpectralSetupParameters spectralSetupParameters = this.getSpectralSetupParameters();
        return spectralSetupParameters.getRepresentativeFrequencyWithSkyOffset();
    }

    public synchronized void updateRepresentativeFrequency() {
        Frequency frequency = this.getRepresentativeFrequency();
        super.getRepresentativeFrequency().setContentAndUnit((ValueUnitPair)frequency);
        this.getDesiredACASensitivity().setBeamsize(this.getACAAngularResolution());
        this.getDesiredTPSensitivity().setBeamsize(this.getTPAngularResolution());
    }

    public UserSensitivity getDesiredTPSensitivity() {
        UserSensitivity userSensitivity = super.getDesiredTPSensitivity();
        userSensitivity.setArrayType(ArrayType.SINGLEDISH);
        return userSensitivity;
    }

    @Override
    public synchronized void representativeFrequencyUpdated(RepresentativeFrequencyChangeEvent representativeFrequencyChangeEvent) {
        Object object = representativeFrequencyChangeEvent.getSource();
        if (!(object instanceof Frequency)) {
            return;
        }
        Frequency frequency = (Frequency)((Object)object);
        if (frequency.getContentInGHz() < 1.0) {
            return;
        }
        Frequency frequency2 = frequency;
        SpectralSetupParameters spectralSetupParameters = this.getSpectralSetupParameters();
        ScienceGoal scienceGoal = this.getScienceGoal();
        TargetParameters targetParameters = scienceGoal.getSoleTargetParameters();
        if (!(spectralSetupParameters == null || spectralSetupParameters.isSingleContinuumSkyFrequency() || spectralSetupParameters.getSSPDerivedFromSpectralScanSetup() || spectralSetupParameters.isSpectralScan() || targetParameters == null)) {
            frequency2 = targetParameters.getSourceVelocityInDefaultReferenceFrame(Optional.of(scienceGoal)).dopplerShift(frequency);
        }
        Frequency frequency3 = this.getRepresentativeFrequency();
        frequency3.setContentAndUnit((ValueUnitPair)frequency2);
        this.setRepresentativeFrequency(frequency3);
        Frequency frequency4 = this.getRepresentativeFrequency();
        this.firePropertyChangeEvent(this, "alma.obsprep.bo.obsproject.PerformanceParameters.representativeFrequency", (Object)frequency4);
    }

    public TimingConstraintType getTypeOfTimingConstraint() {
        TimingConstraintType timingConstraintType;
        block6: {
            if (!this.hasIsTimeConstrained() || !this.getIsTimeConstrained()) {
                return TimingConstraintType.TIMINGCONSTRAINTSTYPE_NONE;
            }
            String string = this.getTimingConstraintsType();
            timingConstraintType = TimingConstraintType.TIMINGCONSTRAINT_UNDECIDED;
            if (string == null) {
                return timingConstraintType;
            }
            try {
                timingConstraintType = TimingConstraintType.getEnumFromName(string);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                if (this.getVisitConstraintCount() > 0) {
                    this.clearVisitConstraint();
                }
                if (this.getTemporalParametersCount() > 0) {
                    this.clearTemporalParameters();
                }
                if (this.getMonitoringConstraintCount() <= 0) break block6;
                this.clearMonitoringConstraint();
            }
        }
        return timingConstraintType;
    }

    public boolean canAddMonitoringConstraints() {
        return this.getVisitConstraintCount() == 0 && this.getTemporalParametersCount() == 0;
    }

    public boolean canAddVisitConstraints() {
        return this.getMonitoringConstraintCount() == 0 && this.getTemporalParametersCount() == 0;
    }

    public boolean canAddTemporalParameters() {
        return this.getMonitoringConstraintCount() == 0 && this.getVisitConstraintCount() == 0;
    }

    public boolean isValidToEditTimingConstraintNote() {
        return this.getMonitoringConstraintCount() > 0 || this.getVisitConstraintCount() > 0 || this.getTemporalParametersCount() > 0;
    }

    public String getTimingConstraintNote() {
        if (this.getMonitoringConstraintCount() > 0) {
            return this.getMonitoringConstraint(0).getNote();
        }
        if (this.getVisitConstraintCount() > 0) {
            return this.getVisitConstraint(0).getNote();
        }
        if (this.getTemporalParametersCount() > 0) {
            return this.getTemporalParameters(0).getNote();
        }
        return "";
    }

    public synchronized void setTimingConstraintNote(String string) {
        if (this.getMonitoringConstraintCount() > 0) {
            for (MonitoringConstraint monitoringConstraint : this.getMonitoringConstraint()) {
                monitoringConstraint.setNote(string);
            }
            return;
        }
        if (this.getVisitConstraintCount() > 0) {
            for (VisitConstraint visitConstraint : this.getVisitConstraint()) {
                visitConstraint.setNote(string);
            }
            return;
        }
        if (this.getTemporalParametersCount() > 0) {
            for (TemporalParameters temporalParameters : this.getTemporalParameters()) {
                temporalParameters.setNote(string);
            }
        }
    }

    public TemporalConstraintType getTemporalConstraintType(int n) {
        TemporalConstraintType temporalConstraintType = TemporalConstraintType.NO_TEMPORAL_CONSTRAINTS;
        if (!this.getIsTimeConstrained()) {
            return temporalConstraintType;
        }
        if (this.getTemporalParametersCount() > 0) {
            return TemporalConstraintType.SINGLE_VISIT;
        }
        int n2 = this.getVisitConstraintCount();
        if (n2 == 0) {
            return TemporalConstraintType.NO_TEMPORAL_CONSTRAINTS;
        }
        if (n > n2 - 1) {
            throw new IllegalArgumentException("visitIndex is larger than the number of visits defined");
        }
        switch (this.getTypeOfTimingConstraint().ordinal()) {
            case 0: {
                return TemporalConstraintType.NO_TEMPORAL_CONSTRAINTS;
            }
            case 2: {
                VisitConstraint visitConstraint = this.getVisitConstraint(n);
                if (!visitConstraint.getIsFixedStart() && (visitConstraint.getPreviousVisitId() > 0 || visitConstraint.getPreviousVisitId() == 0 && n == 0)) {
                    temporalConstraintType = TemporalConstraintType.MULTIPLEVISIT_RELATIVEDATES;
                    break;
                }
                temporalConstraintType = TemporalConstraintType.MULTIPLEVISIT_SPECIFIC_DATES;
                break;
            }
            default: {
                throw new WizardSBGenerationException("Unable to handle timing constraint type: " + String.valueOf((Object)this.getTypeOfTimingConstraint()));
            }
        }
        return temporalConstraintType;
    }

    public synchronized PerformanceParameters deepCopy() throws CopyException {
        return super.deepCopy();
    }

    public AngularResolutionMode getAngularResolutionMode() {
        return AngularResolutionMode.getEnumOf(this.getResolutionOption());
    }

    public void setAngularResolutionMode(AngularResolutionMode angularResolutionMode) {
        this.setResolutionOption(angularResolutionMode.getBOMapping());
    }

    public boolean isAngularResolutionModeAny() {
        return this.getResolutionOption().equals(AngularResolutionMode.Any.getBOMapping());
    }

    public boolean isAngularResolutionModeSACA() {
        return this.getResolutionOption().equals(AngularResolutionMode.SACA.getBOMapping());
    }

    public boolean isDesiredBWForSensivitityAggregatedBW() {
        return this.getDesiredSensitivityFrequencyMeasure().equals(DESIREDSENSITIVITYFREQUENCYMEASURE_AGGREGATEBANDWIDTH);
    }

    public boolean isAngularResolutionModeRange() {
        return this.getResolutionOption().equals(AngularResolutionMode.Range.getBOMapping());
    }

    public synchronized String getResolutionOption() {
        String string;
        PerformanceParametersT performanceParametersT = this.getCastorObject();
        PerformanceParametersTResolutionOptionType performanceParametersTResolutionOptionType = performanceParametersT.getResolutionOption();
        String string2 = string = performanceParametersTResolutionOptionType == null ? null : performanceParametersTResolutionOptionType.toString();
        if (string == null) {
            string = RESOLUTIONOPTION_SINGLE;
            this.setResolutionOption(string);
        }
        return string;
    }

    public UserAngle getPISpecifiedAR(SfiControlParameterModel.RequestAngularResolutionEnum requestAngularResolutionEnum) {
        UserAngle userAngle;
        UserAngle userAngle2 = null;
        UserAngle userAngle3 = this.getAcceptableAngularResolution();
        if (userAngle3.isGreaterThan((AbstractDoubleWithUnit)(userAngle = this.getDesiredAngularResolution()))) {
            userAngle2 = requestAngularResolutionEnum.equals((Object)SfiControlParameterModel.RequestAngularResolutionEnum.COARSEST) ? userAngle3 : userAngle;
        } else {
            UserAngle userAngle4 = userAngle2 = requestAngularResolutionEnum.equals((Object)SfiControlParameterModel.RequestAngularResolutionEnum.COARSEST) ? userAngle : userAngle3;
        }
        assert (userAngle2 != null);
        return userAngle2;
    }

    public Optional<UserAngle> getPreviousDesiredARValues(@NonNull AngularResolutionMode angularResolutionMode) {
        if (angularResolutionMode == null) {
            throw new NullPointerException("mode is marked non-null but is null");
        }
        if (EnumSet.of(AngularResolutionMode.SACA, AngularResolutionMode.SACA).contains(angularResolutionMode)) {
            return Optional.empty();
        }
        UserAngle userAngle = this.previousDesiredARValues.get(angularResolutionMode);
        return userAngle == null ? Optional.empty() : Optional.of(userAngle);
    }

    public void setPreviousDesiredARValue(@NonNull AngularResolutionMode angularResolutionMode, @NonNull UserAngle userAngle) {
        if (angularResolutionMode == null) {
            throw new NullPointerException("mode is marked non-null but is null");
        }
        if (userAngle == null) {
            throw new NullPointerException("previousAR is marked non-null but is null");
        }
        this.previousDesiredARValues.put(angularResolutionMode, userAngle.deepCopy());
    }

    public Optional<UserAngle> getPreviousAcceptableARValues(@NonNull AngularResolutionMode angularResolutionMode) {
        if (angularResolutionMode == null) {
            throw new NullPointerException("mode is marked non-null but is null");
        }
        if (EnumSet.of(AngularResolutionMode.SACA, AngularResolutionMode.SACA).contains(angularResolutionMode)) {
            return Optional.empty();
        }
        UserAngle userAngle = this.previousAcceptableARValues.get(angularResolutionMode);
        return userAngle == null ? Optional.empty() : Optional.of(userAngle);
    }

    public void setPreviousAcceptableARValues(@NonNull AngularResolutionMode angularResolutionMode, @NonNull UserAngle userAngle) {
        if (angularResolutionMode == null) {
            throw new NullPointerException("mode is marked non-null but is null");
        }
        if (userAngle == null) {
            throw new NullPointerException("previousAR is marked non-null but is null");
        }
        this.previousAcceptableARValues.put(angularResolutionMode, userAngle.deepCopy());
    }

    public UserAngle getDesiredARLimit(@NonNull Configuration.DesiredAngularResolution desiredAngularResolution) {
        if (desiredAngularResolution == null) {
            throw new NullPointerException("arType is marked non-null but is null");
        }
        AngularResolutionMode angularResolutionMode = this.getAngularResolutionMode();
        if (angularResolutionMode == null) {
            throw new NullPointerException("Illegal argument. The argument cannot be null: angularResolutionMode");
        }
        UserAngle userAngle = this.getDesiredAngularResolution();
        assert (userAngle != null);
        UserAngle userAngle2 = switch (angularResolutionMode) {
            case AngularResolutionMode.Any, AngularResolutionMode.SACA, AngularResolutionMode.Single -> userAngle;
            case AngularResolutionMode.Range -> {
                UserAngle var5_5 = this.getAcceptableAngularResolution();
                if (!$assertionsDisabled && var5_5 == null) {
                    throw new AssertionError();
                }
                yield desiredAngularResolution.equals((Object)Configuration.DesiredAngularResolution.COARSEST) ? UserAngle.max((UserAngle)userAngle, (UserAngle)var5_5) : UserAngle.min((UserAngle)userAngle, (UserAngle)var5_5);
            }
            default -> throw new RuntimeException(String.valueOf(angularResolutionMode) + " is not supported");
        };
        assert (userAngle2 != null);
        return userAngle2;
    }

    public UserSensitivity getSensitivityForFinestAR() throws InvalidObsProgramParametersException {
        UserSensitivity userSensitivity;
        UserSensitivity userSensitivity2 = this.getDesiredSensitivity();
        if (this.isAngularResolutionModeRange()) {
            if (userSensitivity2.inFluxUnit()) {
                userSensitivity = userSensitivity2.deepCopy();
                UserAngle userAngle = this.getDesiredARLimit(Configuration.DesiredAngularResolution.FINEST);
                userSensitivity.setBeamsize((Angle)userAngle.inDefaultUnits());
            } else {
                userSensitivity = userSensitivity2.getF1FluxSensitivity(this.getScienceGoal());
            }
        } else {
            userSensitivity = userSensitivity2;
        }
        return userSensitivity;
    }

    public static boolean isSimultaneous12and7Observation(PerformanceParameters performanceParameters) {
        return performanceParameters != null && performanceParameters.hasIsSimultaneous12and7() && performanceParameters.getIsSimultaneous12and7();
    }

    public boolean isSimultaneous12and7Observation() {
        return this.hasIsSimultaneous12and7() && this.getIsSimultaneous12and7();
    }

    public boolean isARModeRangeWithFlux() {
        return this.isAngularResolutionModeRange() && this.getDesiredSensitivity().inFluxUnit();
    }

    public boolean isARModeRangeWithTemp() {
        return this.isAngularResolutionModeRange() && this.getDesiredSensitivity().inTemperatureUnit();
    }

    public static void setAttributesForHistoricalProjects(ObsProject obsProject) throws UnknownEntityException {
        if (obsProject.getObsProposal() != null) {
            for (AbstractScienceGoal abstractScienceGoal : obsProject.getObsProposal().getAbstractScienceGoal()) {
                ScienceGoal scienceGoal;
                PerformanceParameters performanceParameters;
                if (!(abstractScienceGoal instanceof ScienceGoal) || !(performanceParameters = (scienceGoal = (ScienceGoal)((Object)abstractScienceGoal)).getPerformanceParameters()).isAngularResolutionModeSACA()) continue;
                Angle angle = performanceParameters.getACAAngularResolution();
                performanceParameters.setAcceptableAngularResolution(UserAngle.createUserAngle(angle));
                performanceParameters.setDesiredAngularResolution(UserAngle.createUserAngle(angle));
                Log.logger(RetrieveAsNewACASupplementalCallProposalPerformer.class).fine("SG " + scienceGoal.getName() + " " + String.valueOf((Object)angle));
                SfiControlParameterModel.updateACASensitivityValues(scienceGoal);
            }
        }
    }

    public static enum TimingConstraintType {
        TIMINGCONSTRAINTSTYPE_NONE(PerformanceParametersData.TIMINGCONSTRAINTSTYPE_NONE, "None"),
        TIMINGCONSTRAINTSTYPE_SPECIFICDATES(PerformanceParametersData.TIMINGCONSTRAINTSTYPE_SPECIFICDATES, "Single Visit"),
        TIMINGCONSTRAINTSTYPE_MULTIPLEVISITS(PerformanceParametersData.TIMINGCONSTRAINTSTYPE_MULTIPLEVISITS, "Multiple Visits"),
        TIMINGCONSTRAINT_UNDECIDED(null, null);

        public final String name;
        public final String label;

        public static TimingConstraintType getTypeFromButtonLabel(String string) {
            for (TimingConstraintType timingConstraintType : TimingConstraintType.values()) {
                if (!string.equals(timingConstraintType.label)) continue;
                return timingConstraintType;
            }
            String string2 = "No enum matching : " + string;
            throw new IllegalArgumentException(string2);
        }

        public static TimingConstraintType getEnumFromName(String string) {
            for (TimingConstraintType timingConstraintType : TimingConstraintType.values()) {
                if (!string.equals(timingConstraintType.name)) continue;
                return timingConstraintType;
            }
            String string2 = "No enum matching : " + string;
            throw new IllegalArgumentException(string2);
        }

        private TimingConstraintType(String string2, String string3) {
            this.name = string2;
            this.label = string3;
        }
    }

    public static enum TemporalConstraintType {
        NO_TEMPORAL_CONSTRAINTS,
        SINGLE_VISIT,
        MULTIPLEVISIT_RELATIVEDATES,
        MULTIPLEVISIT_SPECIFIC_DATES,
        CONTINOUS_MONITORING;

    }
}

