/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.bo.obsproject;

import alma.hla.runtime.obsprep.util.Log;
import alma.hla.runtime.obsprep.util.UnknownEntityException;
import alma.observatorycharacteristics.policies.AlmaPolicies;
import alma.obsprep.bo.obsproject.AbstractScienceGoal;
import alma.obsprep.bo.obsproject.ObsProgram;
import alma.obsprep.bo.obsproject.ObsProject;
import alma.obsprep.bo.obsproject.PerformanceParameters;
import alma.obsprep.bo.obsproject.PointingPatternAdapter;
import alma.obsprep.bo.obsproject.ScienceGoal;
import alma.obsprep.bo.obsproject.TargetParameters;
import alma.obsprep.bo.obsproposal.ObsProposal;
import alma.obsprep.bo.schedblock.FieldPattern;
import alma.obsprep.ot.actions.RetrieveAsNewPerformer;
import alma.obsprep.services.sfi.SingleFieldScienceGoalModel;
import alma.valuetypes.SkyCoordinates;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;

public class HistoricalProjectRefresher {
    private static final String UNABLE_TO_DETERMINE_STANDARD_MODES = "Unable to determine standard modes: ";
    private final ObsProject obsProject;

    public void applyCurrentCycleConstraints() {
        this.resetNonStandardObservingModes();
        this.resetTimeConstrainedFlagWhenNoVisitsDefined();
        this.resetSolarCoordTypes();
    }

    private void ensureCycleCodeForNonSubmittedProjectsIsCurrent() {
        if (this.obsProject.isNewProject()) {
            try {
                ObsProposal obsProposal = this.obsProject.getObsProposal();
                String string = AlmaPolicies.getInstance().getCycleNumber();
                if (!obsProposal.getCycle().equals(string)) {
                    obsProposal.setCycle(string);
                }
            }
            catch (UnknownEntityException unknownEntityException) {
                Log.logger(HistoricalProjectRefresher.class).warning("Unable to fetch the ObsProposal " + unknownEntityException.getMessage());
            }
        }
    }

    private void resetSolarCoordTypes() {
        List<Object> list = new ArrayList();
        try {
            list = this.getAllScienceGoalsInProject();
        }
        catch (UnableToFindAllScienceGoalsException unableToFindAllScienceGoalsException) {
            Log.logger(RetrieveAsNewPerformer.class).warning(UNABLE_TO_DETERMINE_STANDARD_MODES + unableToFindAllScienceGoalsException.getMessage());
        }
        for (AbstractScienceGoal abstractScienceGoal : list) {
            ScienceGoal scienceGoal = (ScienceGoal)((Object)abstractScienceGoal);
            for (TargetParameters targetParameters : scienceGoal.getTargetParameters()) {
                PointingPatternAdapter pointingPatternAdapter;
                if (!targetParameters.getNonSiderealMotion() || !targetParameters.getFieldPatternType().equals((Object)FieldPattern.FieldPatternType.POINT) || (pointingPatternAdapter = targetParameters.getPointingPattern()) == null || !pointingPatternAdapter.isAbsolutePointingPattern()) continue;
                Arrays.asList(pointingPatternAdapter.getPhaseCenterCoordinates()).stream().forEach(skyCoordinates -> skyCoordinates.setAbsoluteCoordinatesInDegInSystem(0.0, 0.0, SkyCoordinates.SYSTEM_ICRS));
                pointingPatternAdapter.setOffsetPointingPattern(true);
            }
        }
    }

    private List<AbstractScienceGoal> getAllScienceGoalsInProject() throws UnableToFindAllScienceGoalsException {
        ObsProposal obsProposal = null;
        try {
            obsProposal = this.obsProject.getObsProposal();
        }
        catch (UnknownEntityException unknownEntityException) {
            Log.logger(RetrieveAsNewPerformer.class).warning("No obsProposal found when expected");
            throw new UnableToFindAllScienceGoalsException();
        }
        if (obsProposal == null) {
            Log.logger(RetrieveAsNewPerformer.class).warning("No obsProposal found when expected");
            throw new UnableToFindAllScienceGoalsException();
        }
        ArrayList<AbstractScienceGoal> arrayList = new ArrayList<AbstractScienceGoal>(Arrays.asList(obsProposal.getAbstractScienceGoal()));
        ObsProgram obsProgram = this.obsProject.getObsProgram();
        if (obsProgram != null) {
            arrayList.addAll(Arrays.asList(obsProgram.getAbstractScienceGoal()));
        }
        return arrayList;
    }

    private void resetNonStandardObservingModes() {
        List<Object> list = new ArrayList();
        try {
            list = this.getAllScienceGoalsInProject();
        }
        catch (UnableToFindAllScienceGoalsException unableToFindAllScienceGoalsException) {
            Log.logger(RetrieveAsNewPerformer.class).warning(UNABLE_TO_DETERMINE_STANDARD_MODES + unableToFindAllScienceGoalsException.getMessage());
        }
        for (AbstractScienceGoal abstractScienceGoal : list) {
            ScienceGoal scienceGoal = (ScienceGoal)((Object)abstractScienceGoal);
            try {
                EnumSet<SingleFieldScienceGoalModel.NonStandardMode> enumSet = SingleFieldScienceGoalModel.establishNonStandardObservingModes(scienceGoal);
                scienceGoal.setMode(enumSet.isEmpty() ? ScienceGoal.MODE_STANDARD : ScienceGoal.MODE_OTHER);
            }
            catch (SingleFieldScienceGoalModel.UnableToDetermineObservingModesException unableToDetermineObservingModesException) {
                Log.logger(RetrieveAsNewPerformer.class).warning(UNABLE_TO_DETERMINE_STANDARD_MODES + unableToDetermineObservingModesException.getMessage());
            }
        }
    }

    public void resetTimeConstrainedFlagWhenNoVisitsDefined() {
        ArrayList<AbstractScienceGoal> arrayList = new ArrayList<AbstractScienceGoal>();
        try {
            if (this.obsProject.getObsProposal() != null) {
                arrayList = new ArrayList<AbstractScienceGoal>(Arrays.asList(this.obsProject.getObsProposal().getAbstractScienceGoal()));
            }
            if (this.obsProject.getObsProgram() != null) {
                arrayList.addAll(Arrays.asList(this.obsProject.getObsProgram().getAbstractScienceGoal()));
            }
        }
        catch (UnknownEntityException unknownEntityException) {
            return;
        }
        for (AbstractScienceGoal abstractScienceGoal : arrayList) {
            ScienceGoal scienceGoal;
            PerformanceParameters performanceParameters;
            if (!(abstractScienceGoal instanceof ScienceGoal) || !(performanceParameters = (scienceGoal = (ScienceGoal)((Object)abstractScienceGoal)).getPerformanceParameters()).getIsTimeConstrained() || performanceParameters.getTimingConstraintsType() == null || !performanceParameters.getTimingConstraintsType().equals(PerformanceParameters.TIMINGCONSTRAINTSTYPE_NONE)) continue;
            performanceParameters.setIsTimeConstrained(false);
        }
    }

    public HistoricalProjectRefresher(ObsProject obsProject) {
        this.obsProject = obsProject;
    }

    public class UnableToFindAllScienceGoalsException
    extends Exception {
        public UnableToFindAllScienceGoalsException() {
            this(null, null);
        }

        public UnableToFindAllScienceGoalsException(String string) {
            this(string, null);
        }

        public UnableToFindAllScienceGoalsException(Throwable throwable) {
            this(throwable != null ? throwable.getMessage() : null, throwable);
        }

        public UnableToFindAllScienceGoalsException(String string, Throwable throwable) {
            super(string);
            if (throwable != null) {
                super.initCause(throwable);
            }
        }
    }
}

