/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.bo.obsproject;

import alma.entity.xmlbinding.obsproject.ExpectedPropertiesT;
import alma.hla.runtime.obsprep.bo.IBusinessObject;
import alma.hla.runtime.obsprep.bo.ReferenceableProxy;
import alma.hla.runtime.obsprep.bo.ReferenceablesMap;
import alma.obsprep.bo.obsproject.RepresentativeFrequencyChangeEvent;
import alma.obsprep.bo.obsproject.RepresentativeFrequencyListener;
import alma.obsprep.bo.obsproject.ScienceGoal;
import alma.obsprep.bo.obsproject.SpectralSetupParameters;
import alma.obsprep.bo.obsproject.TargetParameters;
import alma.obsprep.bo.obsproject.data.ExpectedPropertiesData;
import alma.valuetypes.Flux;
import alma.valuetypes.Frequency;
import alma.valuetypes.UserFrequency;
import alma.valuetypes.UserSensitivity;
import alma.valuetypes.data.UserFrequencyData;
import java.util.List;

public class ExpectedProperties
extends ExpectedPropertiesData
implements RepresentativeFrequencyListener {
    private Flux expectedPeakLinePolarizationFluxDensity = Flux.createFlux();
    private UserFrequency linePolarizationExpectedBW;
    private UserSensitivity sensitivityForBW;

    public ExpectedProperties(ExpectedPropertiesT expectedPropertiesT) {
        super(expectedPropertiesT);
    }

    protected void initAsNew() {
        super.initAsNew();
        Frequency frequency = Frequency.createFrequencyGHZ(1.0);
        this.setReferenceFrequency(frequency);
        UserFrequency userFrequency = this.getExpectedLineWidth();
        userFrequency.setObservingFrequency(frequency);
        userFrequency.setUserUnit(UserFrequency.USERUNIT_KM_S);
        this.setDesiredPolarizationPercentage(0.0);
        this.setSolarActivityLevel(SOLARACTIVITYLEVEL_ACTIVESUN);
    }

    public void updateLocalReference() {
        if (this.getSolarActivityLevel().equals(SOLARACTIVITYLEVEL_NONE)) {
            this.setSolarActivityLevel(SOLARACTIVITYLEVEL_ACTIVESUN);
        }
    }

    public void setSolarActivityLevel(String string) throws IllegalArgumentException {
        if (string.equals(SOLARACTIVITYLEVEL_NONE)) {
            super.setSolarActivityLevel(SOLARACTIVITYLEVEL_ACTIVESUN);
        } else {
            super.setSolarActivityLevel(string);
        }
    }

    private UserFrequency convertExpectedLineWidthFrequencyToVelocity(UserFrequency userFrequency) {
        if (userFrequency.hasContent() && !userFrequency.getUserUnit().equals(UserFrequencyData.USERUNIT_KM_S) && !userFrequency.getUserUnit().equals(UserFrequencyData.USERUNIT_M_S)) {
            userFrequency.convertToUserUnit(UserFrequencyData.USERUNIT_KM_S);
            if (Math.abs(userFrequency.getContentInUnits(UserFrequencyData.USERUNIT_KM_S)) < 1.0) {
                userFrequency.convertToUserUnit(UserFrequencyData.USERUNIT_M_S);
            }
        }
        userFrequency.setUserUnitList(new String[]{UserFrequencyData.USERUNIT_M_S, UserFrequencyData.USERUNIT_KM_S});
        return userFrequency;
    }

    public UserFrequency getExpectedLineWidth() {
        UserFrequency userFrequency = super.getExpectedLineWidth();
        return this.convertExpectedLineWidthFrequencyToVelocity(userFrequency);
    }

    public void setExpectedLineWidth(UserFrequency userFrequency) {
        userFrequency.setObservingFrequency(this.getReferenceFrequency());
        super.setExpectedLineWidth(this.convertExpectedLineWidthFrequencyToVelocity(userFrequency));
    }

    public void setExpectedLineWidthAndReferenceFrequency(UserFrequency userFrequency) {
        this.setReferenceFrequency(userFrequency.getObservingFrequency());
        super.setExpectedLineWidth(userFrequency);
    }

    public void wrapObjects(ReferenceablesMap referenceablesMap, List<ReferenceableProxy<? extends IBusinessObject>> list) {
        super.wrapObjects(referenceablesMap, list);
        UserFrequency userFrequency = this.gettrueExpectedLineWidth();
        if (userFrequency != null) {
            userFrequency.unitMap().suspendUnitMapUpdater();
            userFrequency.setObservingFrequency(this.getReferenceFrequency());
            userFrequency.unitMap().resumeUnitMapUpdater();
        }
    }

    public TargetParameters getTargetParameters() {
        return (TargetParameters)this.getParent();
    }

    public ScienceGoal getScienceGoal() {
        return (ScienceGoal)this.getTargetParameters().getParent();
    }

    private SpectralSetupParameters getSpectralSetupParameters() {
        ScienceGoal scienceGoal = this.getScienceGoal();
        if (scienceGoal == null) {
            return null;
        }
        return scienceGoal.getSpectralSetupParameters();
    }

    public void setReferenceFrequency(Frequency frequency) {
        super.setReferenceFrequency(frequency);
        this.getExpectedLineWidth().setObservingFrequency(frequency);
    }

    @Override
    public void representativeFrequencyUpdated(RepresentativeFrequencyChangeEvent representativeFrequencyChangeEvent) {
        Frequency frequency;
        TargetParameters targetParameters = this.getTargetParameters();
        if (targetParameters == null) {
            return;
        }
        ScienceGoal scienceGoal = targetParameters.getScienceGoal();
        if (scienceGoal == null) {
            return;
        }
        SpectralSetupParameters spectralSetupParameters = this.getSpectralSetupParameters();
        if (spectralSetupParameters == null) {
            return;
        }
        Object object = representativeFrequencyChangeEvent.getSource();
        if (object instanceof Frequency) {
            frequency = (Frequency)((Object)representativeFrequencyChangeEvent.getSource());
        } else {
            try {
                frequency = spectralSetupParameters.getRepresentativeFrequency();
            }
            catch (NullPointerException nullPointerException) {
                frequency = Frequency.createFrequencyGHZ(0.0);
            }
        }
        if (!frequency.isZero()) {
            if (spectralSetupParameters.isSingleContinuumSkyFrequency() || spectralSetupParameters.isSpectralScan()) {
                this.getExpectedLineWidth().setObservingFrequency(frequency.deepCopy());
                super.setReferenceFrequency(frequency.deepCopy());
            } else {
                this.getExpectedLineWidth().setObservingFrequency(targetParameters.getSourceVelocity().dopplerShift(frequency));
                super.setReferenceFrequency(targetParameters.getSourceVelocity().dopplerShift(frequency));
            }
        } else {
            super.setReferenceFrequency(frequency);
        }
    }

    public Flux getExpectedPeakLinePolarizationFluxDensity() {
        return this.expectedPeakLinePolarizationFluxDensity;
    }

    public void setExpectedPeakLinePolarizationFluxDensity(Flux flux) {
        this.expectedPeakLinePolarizationFluxDensity = flux;
    }

    public void setlinePolarizationExpectedBW(UserFrequency userFrequency) {
        this.setLinearPolarizationExpectedBW(userFrequency);
    }

    public UserFrequency getLinePolarizationExpectedBW() {
        return this.linePolarizationExpectedBW;
    }

    public void setLinearPolarizationExpectedBW(UserFrequency userFrequency) {
        this.linePolarizationExpectedBW = userFrequency;
    }

    public UserSensitivity getSensitivityForBW() {
        return this.sensitivityForBW;
    }

    public void setSensitivityForBW(UserSensitivity userSensitivity) {
        this.sensitivityForBW = userSensitivity;
    }
}

