/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.xjc.reader.xmlschema.parser;

import com.sun.tools.xjc.reader.xmlschema.parser.Messages;
import java.util.HashSet;
import java.util.Set;
import java.util.Stack;
import javax.xml.namespace.QName;
import org.xml.sax.Attributes;
import org.xml.sax.ErrorHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.XMLFilterImpl;

public class CustomizationContextChecker
extends XMLFilterImpl {
    private final Stack<QName> elementNames = new Stack();
    private final ErrorHandler errorHandler;
    private Locator locator;
    private static final Set<String> prohibitedSchemaElementNames = new HashSet<String>();

    public CustomizationContextChecker(ErrorHandler _errorHandler) {
        this.errorHandler = _errorHandler;
    }

    private QName top() {
        return this.elementNames.peek();
    }

    @Override
    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        QName schemaElement;
        QName newElement = new QName(namespaceURI, localName);
        if (newElement.getNamespaceURI().equals("https://jakarta.ee/xml/ns/jaxb") && this.top().getNamespaceURI().equals("http://www.w3.org/2001/XMLSchema") && this.elementNames.size() >= 3 && prohibitedSchemaElementNames.contains((schemaElement = (QName)this.elementNames.get(this.elementNames.size() - 3)).getLocalPart())) {
            this.errorHandler.error(new SAXParseException(Messages.format("CustomizationContextChecker.UnacknolwedgedCustomization", localName), this.locator));
        }
        this.elementNames.push(newElement);
        super.startElement(namespaceURI, localName, qName, atts);
    }

    @Override
    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        super.endElement(namespaceURI, localName, qName);
        this.elementNames.pop();
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        super.setDocumentLocator(locator);
        this.locator = locator;
    }

    static {
        prohibitedSchemaElementNames.add("restriction");
        prohibitedSchemaElementNames.add("extension");
        prohibitedSchemaElementNames.add("simpleContent");
        prohibitedSchemaElementNames.add("complexContent");
        prohibitedSchemaElementNames.add("list");
        prohibitedSchemaElementNames.add("union");
    }
}

