/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.xjc.addon.code_injector;

import com.sun.istack.NotNull;
import com.sun.tools.xjc.Options;
import com.sun.tools.xjc.Plugin;
import com.sun.tools.xjc.model.CPluginCustomization;
import com.sun.tools.xjc.outline.CustomizableOutline;
import com.sun.tools.xjc.outline.Outline;
import com.sun.tools.xjc.util.DOMUtils;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.xml.sax.ErrorHandler;

public class PluginImpl
extends Plugin {
    @Override
    public String getOptionName() {
        return "Xinject-code";
    }

    @Override
    public List<String> getCustomizationURIs() {
        return Collections.singletonList("http://jaxb.dev.java.net/plugin/code-injector");
    }

    @Override
    public boolean isCustomizationTagName(String nsUri, String localName) {
        return "http://jaxb.dev.java.net/plugin/code-injector".equals(nsUri) && "code".equals(localName);
    }

    @Override
    public String getUsage() {
        return "  -Xinject-code       :  inject specified Java code fragments into the generated code";
    }

    @Override
    public boolean run(@NotNull Outline model, Options opt, ErrorHandler errorHandler) {
        PluginImpl.checkAndInject(model.getClasses());
        PluginImpl.checkAndInject(model.getEnums());
        return true;
    }

    private static void checkAndInject(Collection<? extends CustomizableOutline> outlines) {
        for (CustomizableOutline customizableOutline : outlines) {
            CPluginCustomization c = customizableOutline.getTarget().getCustomizations().find("http://jaxb.dev.java.net/plugin/code-injector", "code");
            if (c == null) continue;
            c.markAsAcknowledged();
            String codeFragment = DOMUtils.getElementText(c.element);
            customizableOutline.getImplClass().direct(codeFragment);
        }
    }
}

