/*
 * Decompiled with CFR 0.152.
 */
package jsky.util.gui;

import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeEvent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import jsky.science.Quantity;
import jsky.util.FormatUtilities;
import jsky.util.ReplaceablePropertyChangeListener;
import jsky.util.ReplacementEvent;

public class QuantityPanel
extends JPanel
implements ReplaceablePropertyChangeListener,
ActionListener,
FocusListener {
    Quantity fQuantity = null;
    Class fClass = null;
    int fDecs = 2;
    JTextField fTextValue;
    JLabel fLabelUnits;
    boolean fAbbreviate = true;
    public static final String QUANTITY = "Quantity";
    private static final String NAN_STRING = "Invalid";
    private static final String NINFINITY_STRING = "-Infinity";
    private static final String PINFINITY_STRING = "+Infinity";
    private static final String MAXVAL_STRING = "MaxVal";
    private static final String MINVAL_STRING = "MinVal";
    private Color fNormalColor = Color.black;
    private Color fErrorColor = Color.red;
    private boolean isListening = false;
    private String oldText = null;
    private boolean errorPaneUp = false;

    public QuantityPanel(Class cl) {
        this(8, 3, cl);
    }

    public QuantityPanel(int width, Class cl) {
        this(width, 3, cl);
    }

    public QuantityPanel(int width, int labelLocation, Class cl) {
        this.fClass = cl;
        if (labelLocation == 3) {
            this.setLayout(new FlowLayout());
        } else {
            this.setLayout(new GridLayout(2, 1));
        }
        this.fTextValue = new JTextField(width);
        this.fTextValue.setActionCommand(QUANTITY);
        this.add(this.fTextValue);
        this.fLabelUnits = new JLabel();
        this.setAbbreviate(this.fAbbreviate);
        this.add(this.fLabelUnits);
        this.updateText();
        Quantity.addDefaultUnitsChangeListener(this.fClass, this);
        this.addListeners();
    }

    public void setAbbreviate(boolean abbrev) {
        this.fAbbreviate = abbrev;
        if (this.fAbbreviate) {
            this.fLabelUnits.setText(Quantity.getDefaultUnitsAbbrev(this.fClass));
        } else {
            this.fLabelUnits.setText(Quantity.getDefaultUnits(this.fClass));
        }
    }

    private void addListeners() {
        if (!this.isListening) {
            this.isListening = true;
            this.fTextValue.addActionListener(this);
            this.fTextValue.addFocusListener(this);
        }
    }

    private void removeListeners() {
        if (this.isListening) {
            this.isListening = false;
            this.fTextValue.removeActionListener(this);
            this.fTextValue.removeFocusListener(this);
        }
    }

    public void setNormalColor(Color c) {
        this.fNormalColor = c;
        this.updateText();
    }

    public void setErrorColor(Color c) {
        this.fErrorColor = c;
        this.updateText();
    }

    private void updateText() {
        double q;
        double d = q = this.fQuantity == null ? 0.0 : this.fQuantity.getValue();
        if (this.fQuantity == null) {
            this.fTextValue.setForeground(this.fNormalColor);
            this.fTextValue.setText("");
        } else if (Double.isNaN(q)) {
            this.fTextValue.setForeground(this.fErrorColor);
            this.fTextValue.setText(NAN_STRING);
        } else if (Double.isInfinite(q)) {
            this.fTextValue.setForeground(this.fErrorColor);
            this.fTextValue.setText(q < Double.POSITIVE_INFINITY ? NINFINITY_STRING : PINFINITY_STRING);
        } else if (q == Double.MAX_VALUE) {
            this.fTextValue.setForeground(this.fErrorColor);
            this.fTextValue.setText(MAXVAL_STRING);
        } else if (q == Double.MIN_VALUE) {
            this.fTextValue.setForeground(this.fErrorColor);
            this.fTextValue.setText(MINVAL_STRING);
        } else {
            this.fTextValue.setForeground(this.fNormalColor);
            this.fTextValue.setText(FormatUtilities.formatDouble(q, this.fDecs, this.fTextValue.getColumns()));
        }
    }

    public void setQuantity(Quantity newQ) {
        Quantity oldW = this.fQuantity;
        if (newQ != null && !this.fClass.isInstance(newQ)) {
            throw new ClassCastException();
        }
        this.fQuantity = newQ;
        this.firePropertyChange(QUANTITY, oldW, newQ);
        this.updateText();
    }

    public Quantity getQuantity() {
        return this.fQuantity;
    }

    public void setDecs(int inDecs) {
        this.fDecs = inDecs;
        this.updateText();
    }

    public int getDecs() {
        return this.fDecs;
    }

    @Override
    public void setFont(Font f) {
        if (this.fTextValue != null) {
            this.fTextValue.setFont(f);
        }
    }

    @Override
    public Font getFont() {
        return this.fTextValue == null ? null : this.fTextValue.getFont();
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        if (event.getPropertyName().equals(Quantity.getDefaultUnitsProperty(this.fClass))) {
            this.fLabelUnits.setText((String)event.getNewValue());
            this.updateText();
        }
    }

    @Override
    public void replaceObject(ReplacementEvent event) {
        this.setQuantity((Quantity)event.getNewValue());
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        if (event != null && !event.getActionCommand().equals(QUANTITY)) {
            return;
        }
        if (this.fQuantity == null) {
            return;
        }
        String t = this.fTextValue.getText();
        if (t.equalsIgnoreCase("null") && t.equalsIgnoreCase(NAN_STRING)) {
            this.setQuantity(this.fQuantity.newInstance(Double.NaN));
        } else if (t.equalsIgnoreCase(NINFINITY_STRING)) {
            this.setQuantity(this.fQuantity.newInstance(Double.NEGATIVE_INFINITY));
        } else if (t.equalsIgnoreCase(PINFINITY_STRING)) {
            this.setQuantity(this.fQuantity.newInstance(Double.POSITIVE_INFINITY));
        } else if (t.equalsIgnoreCase(MAXVAL_STRING)) {
            this.setQuantity(this.fQuantity.newInstance(Double.MAX_VALUE));
        } else if (t.equalsIgnoreCase(MINVAL_STRING)) {
            this.setQuantity(this.fQuantity.newInstance(Double.MIN_VALUE));
        } else {
            try {
                this.setQuantity(this.fQuantity.newInstance(new Double(t)));
            }
            catch (NumberFormatException e) {
                this.errorPaneUp = true;
                JOptionPane.showMessageDialog(this, "Decimal number expected, please re-enter", "Invalid number", 0);
                this.errorPaneUp = false;
            }
        }
    }

    @Override
    public void focusGained(FocusEvent event) {
        this.oldText = this.fTextValue.getText();
    }

    @Override
    public void focusLost(FocusEvent event) {
        if (!this.oldText.equals(this.fTextValue.getText()) && !this.errorPaneUp) {
            this.actionPerformed(null);
        }
    }

    public void setUnitsVisible(boolean onOff) {
        this.fLabelUnits.setVisible(onOff);
    }

    @Override
    public void setToolTipText(String text) {
        super.setToolTipText(text);
        this.fTextValue.setToolTipText(text);
        this.fLabelUnits.setToolTipText(text);
    }

    @Override
    public void setEnabled(boolean b) {
        super.setEnabled(b);
        this.fTextValue.setEnabled(b);
    }
}

