/*
 * Decompiled with CFR 0.152.
 */
package jsky.science;

import java.awt.Component;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import jsky.science.Passband;
import jsky.science.Quantity;
import jsky.science.Wavelength;
import jsky.util.FormatUtilities;

public class WavelengthNotInPassbandException
extends Exception {
    Passband pBand;
    Wavelength pWL;
    private static String TITLE = "Wavelength Not In Passband Range";
    private static JOptionPane optionPane = null;

    public WavelengthNotInPassbandException(Passband inBand, Wavelength inWL) {
        super("WavelengthNotInPassbandException");
        this.pBand = inBand;
        this.pWL = inWL;
    }

    @Override
    public String getMessage() {
        return "Target wavelength (" + this.pWL.toString() + ") is not in the\ngrating's band pass (" + this.pBand.toString() + "). \n\nPlease enter a new wavelength";
    }

    public void showErrorMessageDialog(Component parent) {
        if (optionPane == null) {
            optionPane = new JOptionPane(this.getMessage(), 0, 2);
            optionPane.setWantsInput(true);
        }
        boolean tryAgain = true;
        Object selectedValue = FormatUtilities.formatDouble(this.pWL.getValue(), 2);
        double bandLow = this.pBand.getLowWavelength().getValue();
        double bandHigh = this.pBand.getHighWavelength().getValue();
        while (tryAgain) {
            optionPane.setMessage(this.getMessage());
            optionPane.setInputValue(null);
            optionPane.setInitialSelectionValue(null);
            JDialog dialog = optionPane.createDialog(parent, TITLE);
            dialog.show();
            selectedValue = optionPane.getInputValue();
            if (selectedValue == null) {
                if (0 != JOptionPane.showConfirmDialog(parent, "This will leave the wavelength at " + FormatUtilities.formatDouble(this.pWL.getValue(), 2) + " " + Quantity.getDefaultUnitsAbbrev(Wavelength.class) + "\nIs this what you want?")) continue;
                return;
            }
            try {
                double dWL = Double.NaN;
                if (selectedValue instanceof String) {
                    dWL = new Double((String)selectedValue);
                } else if (selectedValue instanceof Number) {
                    dWL = ((Number)selectedValue).doubleValue();
                }
                if (!(bandLow <= dWL) || !(dWL <= bandHigh)) continue;
                this.pWL = new Wavelength(dWL, this.pWL.getDefaultUnits());
                tryAgain = false;
            }
            catch (NumberFormatException numberFormatException) {}
        }
    }

    public Wavelength getWavelength() {
        return this.pWL;
    }
}

