/*
 * Decompiled with CFR 0.152.
 */
package jsky.science;

import jsky.science.Quantity;
import jsky.science.Time;

public class QuantityRange {
    public static Quantity MIN_QUANTITY = new Time(-1.7976931348623157E308);
    public static Quantity MAX_QUANTITY = new Time(Double.MAX_VALUE);
    public static final QuantityRange INVALID_RANGE = new QuantityRange(null, null);
    public static final QuantityRange ALL_RANGE = new QuantityRange(MIN_QUANTITY, MAX_QUANTITY);
    private Quantity fMinRange;
    private Quantity fMaxRange;

    public QuantityRange(Quantity min, Quantity max) {
        this.fMinRange = min;
        this.fMaxRange = max;
    }

    public Quantity getMinimumRange() {
        return this.fMinRange;
    }

    public Quantity getMaximumRange() {
        return this.fMaxRange;
    }

    public boolean intersects(QuantityRange range) {
        boolean intersects = true;
        if (range.getMinimumRange().getValue() < this.fMinRange.getValue() && range.getMaximumRange().getValue() < this.fMinRange.getValue() || range.getMinimumRange().getValue() > this.fMaxRange.getValue() && range.getMaximumRange().getValue() > this.fMaxRange.getValue()) {
            intersects = false;
        }
        return intersects;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.fMinRange.toString());
        sb.append("...");
        sb.append(this.fMaxRange.toString());
        return sb.toString();
    }
}

