/*
 * Decompiled with CFR 0.152.
 */
package jsky.science;

import jsky.science.MrqFit;

public class IQE
implements MrqFit.MrqFunc {
    private static final double _HSQ2 = 0.7071067811865476;
    private static final double _S2F = 2.0 * Math.sqrt(2.0 * Math.log(2.0));
    private static final double _R2D = 45.0 / Math.atan(1.0);
    private static final int _MA = 6;
    private static final int _MITER = 64;
    private double _meanX;
    private double _meanY;
    private double _fwhmX;
    private double _fwhmY;
    private double _angle;
    private double _objectPeak;
    private double _meanBackground;
    private boolean _status = true;
    private int _mp;
    private int _mx;
    private int _pwght;
    private float[] _pval;
    private double[] _w = new double[9];
    private double[] _xi = new double[9];
    private double[] _yi = new double[9];

    public IQE(float[] pfm, int mx, int my) {
        int[] nbg = new int[1];
        float[] bgv = new float[1];
        float[] bgs = new float[1];
        float[] ap = new float[6];
        float[] cv = new float[6];
        float[] est = new float[6];
        float[] sec = new float[6];
        if (this._iqebgv(pfm, mx, my, bgv, bgs, nbg) != 0) {
            this._status = false;
            return;
        }
        this._meanBackground = bgv[0];
        if (this._iqemnt(pfm, mx, my, bgv[0], bgs[0], est) != 0) {
            this._status = false;
            return;
        }
        this._meanX = est[1];
        this._fwhmX = _S2F * (double)est[2];
        this._meanY = est[3];
        this._fwhmY = _S2F * (double)est[4];
        this._objectPeak = est[0];
        if (this._iqesec(pfm, mx, my, bgv, est, sec) != 0) {
            this._status = false;
            return;
        }
        this._angle = _R2D * (double)sec[5];
        if (this._iqefit(pfm, mx, my, bgv, sec, ap, cv) < 0) {
            this._status = false;
            return;
        }
        this._meanX = ap[1];
        this._fwhmX = _S2F * (double)ap[2];
        this._meanY = ap[3];
        this._fwhmY = _S2F * (double)ap[4];
        this._angle = (_R2D * (double)ap[5] + 180.0) % 180.0;
        this._objectPeak = ap[0];
    }

    public double getMeanX() {
        return this._meanX;
    }

    public double getMeanY() {
        return this._meanY;
    }

    public double getFwhmX() {
        return this._fwhmX;
    }

    public double getFwhmY() {
        return this._fwhmY;
    }

    public double getAngle() {
        return this._angle;
    }

    public double getObjectPeak() {
        return this._objectPeak;
    }

    public double getMeanBackground() {
        return this._meanBackground;
    }

    public boolean getStatus() {
        return this._status;
    }

    private int _iqebgv(float[] pfm, int mx, int my, float[] bgm, float[] bgs, int[] nbg) {
        int n;
        int pf0;
        int m;
        bgm[0] = 0.0f;
        bgs[0] = 0.0f;
        nbg[0] = 0;
        int pfs0 = 0;
        int pfs1 = mx - 1;
        int pfs2 = mx * (my - 1);
        int pfs3 = mx * my - 1;
        int ns = mx < my ? mx - 1 : my - 1;
        int ms = mx < my ? mx / 4 : my / 4;
        float[] pfb = new float[8 * ns * ms];
        int pwb = 4 * ns * ms;
        int nt = 0;
        int pf = 0;
        int pw = pwb;
        for (m = 0; m < ms; ++m) {
            pf0 = pfs0;
            int pf1 = pfs1;
            int pf2 = pfs2;
            int pf3 = pfs3;
            for (n = 0; n < ns; ++n) {
                pfb[pf++] = pfm[pf0++];
                pfb[pf++] = pfm[pf1];
                pf1 += mx;
                pfb[pf++] = pfm[pf2];
                pf2 -= mx;
                pfb[pf++] = pfm[pf3--];
            }
            nt += 4 * ns;
            ns -= 2;
            pfs0 += mx + 1;
            pfs1 += mx - 1;
            pfs2 -= mx - 1;
            pfs3 -= mx + 1;
        }
        pf0 = 0;
        pf = 0;
        pw = pwb;
        n = nt;
        int mt = nt;
        while (n-- > 0) {
            pfb[pw++] = 1.0f;
        }
        this._hsort(mt, pfb);
        nt = mt;
        m = mt / 2;
        n = mt / 20;
        double ba = pfb[m];
        double bs = 0.606 * (ba - (double)pfb[n]);
        if (bs <= 0.0) {
            bs = Math.sqrt(Math.abs(ba));
        }
        bgm[0] = (float)ba;
        for (m = 0; m < 5; ++m) {
            pf = 0;
            pw = pwb;
            double fks = 5.0 * bs;
            bs = 0.0;
            double bm = 0.0;
            mt = 0;
            n = 0;
            while (n < nt) {
                double val = pfb[pf++];
                if (0.0 < (double)pfb[pw] && Math.abs(val - ba) < fks) {
                    bm += val;
                    bs += val * val;
                    ++mt;
                } else {
                    pfb[pw] = 0.0f;
                }
                ++n;
                ++pw;
            }
            if (mt < 1) {
                return -2;
            }
            ba = bm / (double)mt;
            bs = 0.0 < (bs = bs / (double)mt - ba * ba) ? Math.sqrt(bs) : 0.0;
        }
        bgm[0] = (float)ba;
        bgs[0] = (float)bs;
        nbg[0] = mt;
        return 0;
    }

    private int _iqemnt(float[] pfm, int mx, int my, float bgv, float bgs, float[] amm) {
        double val;
        double x;
        int nt;
        int nx;
        int ndx = 0;
        int ndy = 0;
        float[] av = new float[1];
        float[] dx = new float[1];
        float[] dy = new float[1];
        double dv = 5.0 * (double)bgs;
        double xm = (double)mx - 1.0;
        double ym = (double)my - 1.0;
        for (nx = 0; nx < 6; ++nx) {
            amm[nx] = 0.0f;
        }
        int ny = 1;
        nx = 1;
        int n = 1;
        int nxc = mx / 2;
        int nyc = my / 2;
        int n2 = nt = nxc < nyc ? nxc : nyc;
        while (nt-- > 0 && this._estm9p(pfm, mx, my, nxc, nyc, av, dx, dy) == 0) {
            if (n != 0) {
                n = 0;
            } else {
                if ((double)(dx[0] * (float)ndx) < 0.0) {
                    nx = 0;
                }
                if ((double)(dy[0] * (float)ndy) < 0.0) {
                    ny = 0;
                }
            }
            if (nx == 0 && ny == 0) break;
            ndx = 0.0 < (double)dx[0] ? nx : -nx;
            ndy = 0.0 < (double)dy[0] ? ny : -ny;
            nxc += ndx;
            nyc += ndy;
        }
        double y = 0.0;
        nt = 0;
        ny = my;
        int pf = 0;
        double ay = 0.0;
        double ax = 0.0;
        while (ny-- > 0) {
            x = 0.0;
            nx = my;
            while (nx-- > 0) {
                int n3 = pf++;
                val = pfm[n3] - bgv;
                if (dv < val) {
                    ax += x;
                    ay += y;
                    ++nt;
                }
                x += 1.0;
            }
            y += 1.0;
        }
        if (nt < 1) {
            return -1;
        }
        nx = (int)Math.floor(ax / (double)nt);
        val = pfm[nx + mx * (ny = (int)Math.floor(ay / (double)nt))];
        if ((double)av[0] < val) {
            nxc = nx;
            nyc = ny;
        }
        nt = 0;
        nx = 1;
        x = nxc;
        y = nyc;
        int ioff = nxc + mx * nyc;
        n = mx < my ? mx - 1 : my - 1;
        pf = ioff;
        double am = val = (double)(pfm[pf] - bgv);
        ax = val * x;
        ay = val * y;
        double axx = val * x * x;
        double ayy = val * y * y;
        double axy = val * x * y;
        ++nt;
        int kn = 1;
        int ks = 1;
        int ki = 1;
        while (n-- > 0) {
            int k = kn;
            if (ki == 0 && ks == -1) {
                if (nx == 0) break;
                nx = 0;
            }
            int n4 = ioff = ki != 0 ? ks : ks * mx;
            while (k-- > 0) {
                if (ki != 0) {
                    x += (double)ks;
                } else {
                    y += (double)ks;
                }
                if (x < 0.0 || y < 0.0 || xm < x || ym < y) break;
                pf += ioff;
                try {
                    val = pfm[pf] - bgv;
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    return -1;
                }
                if (!(dv < val)) continue;
                am += val;
                ax += val * x;
                ay += val * y;
                axx += val * x * x;
                ayy += val * y * y;
                axy += val * x * y;
                ++nt;
                ++nx;
            }
            if (ki != 0) {
                ki = 0;
                continue;
            }
            ki = 1;
            ks = -ks;
            ++kn;
        }
        if (am <= 0.0) {
            return -1;
        }
        amm[1] = (float)(ax / am);
        amm[3] = (float)(ay / am);
        amm[2] = (float)(0.0 < (axx = axx / am - (double)(amm[1] * amm[1])) ? Math.sqrt(axx) : 0.0);
        ayy = ayy / am - (double)(amm[3] * amm[3]);
        amm[4] = (float)(0.0 < ayy ? Math.sqrt(ayy) : 0.0);
        axy = (axy / am - (double)(amm[1] * amm[3])) / axx;
        amm[5] = (float)((Math.atan(axy) + 4.0 * Math.atan(1.0)) % (4.0 * Math.atan(1.0)));
        nx = (int)amm[1];
        ny = (int)amm[3];
        amm[0] = pfm[nx + ny * mx] - bgv;
        return 0;
    }

    private int _estm9p(float[] pfm, int mx, int my, int nx, int ny, float[] rm, float[] dx, float[] dy) {
        int n;
        int ix;
        int pf = nx - 1 + mx * (ny - 1);
        int iy = 3;
        int[] idx = new int[9];
        float[] fb = new float[9];
        int pfb = 0;
        float[] wb = new float[9];
        int pwb = 0;
        if (nx < 1 || mx < nx - 2 || ny < 1 || my < ny - 2) {
            return -1;
        }
        while (iy-- > 0) {
            ix = 3;
            while (ix-- > 0) {
                try {
                    fb[pfb++] = pfm[pf++];
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    return -1;
                }
                wb[pwb++] = 1.0f;
            }
            pf += mx - 3;
        }
        this._indexx(9, fb, idx);
        wb[idx[8]] = 0.0f;
        int nt = 0;
        float am = 0.0f;
        for (n = 0; n < 9; ++n) {
            if (!(0.0 < (double)wb[n])) continue;
            am += fb[n];
            ++nt;
        }
        rm[0] = am / (float)nt;
        am = 0.0f;
        float a = 0.0f;
        iy = 0;
        ix = 0;
        for (n = 0; n < 9; n += 3) {
            if (0.0 < (double)wb[n]) {
                a += fb[n];
                ++ix;
            }
            if (!(0.0 < (double)wb[n + 2])) continue;
            am += fb[n + 2];
            ++iy;
        }
        dx[0] = (float)(0.5 * (double)(am / (float)iy - a / (float)ix));
        am = 0.0f;
        a = 0.0f;
        iy = 0;
        ix = 0;
        for (n = 0; n < 3; ++n) {
            if (0.0 < (double)wb[n]) {
                a += fb[n];
                ++ix;
            }
            if (!(0.0 < (double)wb[n + 6])) continue;
            am += fb[n + 6];
            ++iy;
        }
        dy[0] = (float)(0.5 * (double)(am / (float)iy - a / (float)ix));
        return 0;
    }

    private int _iqesec(float[] pfm, int mx, int my, float[] bgv, float[] est, float[] sec) {
        int ioff;
        double rh;
        double rl;
        double y;
        double x;
        int n;
        int[] ns = new int[8];
        double[] sb = new double[8];
        double fac = 1.0 / Math.atan(1.0);
        for (n = 0; n < 6; ++n) {
            sec[n] = 0.0f;
        }
        for (n = 0; n < 8; ++n) {
            sb[n] = 0.0;
            ns[n] = 0;
        }
        double xc = x = (double)est[1];
        double xm = (double)mx - 1.0;
        double yc = y = (double)est[3];
        double ym = (double)my - 1.0;
        if (est[2] < est[4]) {
            rl = 2.0 * (double)est[2];
            rh = 4.0 * (double)est[4];
            n = (int)Math.ceil(16.0 * (double)est[4]);
        } else {
            rl = 2.0 * (double)est[4];
            rh = 4.0 * (double)est[2];
            n = (int)Math.ceil(16.0 * (double)est[2]);
        }
        int nxc = (int)Math.floor(x + 0.5);
        int nyc = (int)Math.floor(y + 0.5);
        int pf = ioff = nxc + mx * nyc;
        int pw = ioff;
        int kn = 1;
        int ks = 1;
        int ki = 1;
        while (n-- > 0) {
            int k = kn;
            int n2 = ioff = ki != 0 ? ks : ks * mx;
            while (k-- > 0) {
                int idx;
                if (ki != 0) {
                    x += (double)ks;
                } else {
                    y += (double)ks;
                }
                if (x < 0.0 || y < 0.0 || xm < x || ym < y) break;
                pw += ioff;
                double dx = x - xc;
                double dy = y - yc;
                double r = Math.sqrt(dx * dx + dy * dy);
                if (!(rl < r) || !(r < rh) || (pf += ioff) < 0 || pf >= pfm.length) continue;
                int f = (int)(pfm[pf] - bgv[0]);
                int n3 = idx = (int)(fac * Math.atan2(y - yc, x - xc) + 8.5) % 8;
                sb[n3] = sb[n3] + (0.0 < (double)f ? (double)f : 0.0);
                int n4 = idx;
                ns[n4] = ns[n4] + 1;
            }
            if (ki != 0) {
                ki = 0;
                continue;
            }
            ki = 1;
            ks = -ks;
            ++kn;
        }
        for (n = 0; n < 8; ++n) {
            if (ns[n] < 1) {
                ns[n] = 1;
            }
            int n5 = n;
            sb[n5] = sb[n5] / (double)ns[n];
        }
        double a1r = sb[0] + 0.7071067811865476 * sb[1] - 0.7071067811865476 * sb[3] - sb[4] - 0.7071067811865476 * sb[5] + 0.7071067811865476 * sb[7];
        double a1i = 0.7071067811865476 * sb[1] + sb[2] + 0.7071067811865476 * sb[3] - 0.7071067811865476 * sb[5] - sb[6] - 0.7071067811865476 * sb[7];
        double a2r = sb[0] - sb[2] + sb[4] - sb[6];
        double a2i = sb[1] - sb[3] + sb[5] - sb[7];
        for (n = 0; n < 6; ++n) {
            sec[n] = est[n];
        }
        if (a2r == 0.0 && a2i == 0.0) {
            return -2;
        }
        sec[5] = (float)(0.5 * Math.atan2(a2i, a2r) % (4.0 / fac));
        return 0;
    }

    private int _iqefit(float[] pfm, int mx, int my, float[] bgv, float[] est, float[] ap, float[] cm) {
        int ny;
        int nx;
        int nys;
        int n;
        double[] chi = new double[1];
        for (n = 0; n < 6; ++n) {
            cm[n] = 0.0f;
            ap[n] = 0.0f;
        }
        int nxs = (int)Math.floor((double)est[1] - 4.0 * (double)est[2]);
        if (nxs < 0) {
            nxs = 0;
        }
        if ((nys = (int)Math.floor((double)est[3] - 4.0 * (double)est[4])) < 0) {
            nys = 0;
        }
        if (mx < nxs + (nx = (int)Math.ceil(8.0 * (double)est[2]))) {
            nx = my - nxs;
        }
        if (my < nys + (ny = (int)Math.ceil(8.0 * (double)est[4]))) {
            ny = my - nys;
        }
        float[] pfb = new float[2 * nx * ny];
        int pwb = nx * ny;
        int fb = nxs + mx * nys;
        int pf = 0;
        int pw = pwb;
        int iy = ny;
        while (iy-- > 0) {
            int ix = nx;
            while (ix-- > 0) {
                pfb[pf++] = pfm[fb++] - bgv[0];
                pfb[pw++] = 1.0f;
            }
            fb += mx - nx;
        }
        ap[0] = est[0];
        ap[1] = est[1] - (float)nxs;
        ap[2] = est[2];
        ap[3] = est[3] - (float)nys;
        ap[4] = est[4];
        ap[5] = est[5];
        n = this._g2efit(pfb, pwb, nx, ny, ap, cm, chi);
        ap[1] = ap[1] + (float)nxs;
        ap[3] = ap[3] + (float)nys;
        return n;
    }

    @Override
    public int mrqFunc(int idx, float[] val, float[] fval, float[] psig, float[] a, float[] dyda, int ma) {
        double yy;
        double xx;
        if (idx < 0 || this._mp <= idx) {
            return -1;
        }
        if (this._pval != null && (double)this._pval[this._pwght + idx] < 0.0) {
            return 1;
        }
        if ((double)a[2] <= 0.0 || (double)a[4] <= 0.0) {
            return -2;
        }
        double xc = (double)(idx % this._mx) - (double)a[1];
        double yc = (double)(idx / this._mx) - (double)a[3];
        double xm5 = (double)(idx % this._mx) - (double)a[1] - 0.5;
        double xp5 = xm5 + 1.0;
        double ym5 = (double)(idx / this._mx) - (double)a[3] - 0.5;
        double yp5 = ym5 + 1.0;
        val[0] = this._pval[idx];
        psig[0] = this._pval != null ? this._pval[this._pwght + idx] : 1.0f;
        double si = Math.sin(a[5]);
        double ci = Math.cos(a[5]);
        double sum = 0.0;
        for (int n = 0; n < 9; ++n) {
            double x = xc + this._xi[n];
            double y = yc + this._yi[n];
            xx = (ci * x + si * y) / (double)a[2];
            yy = (-si * x + ci * y) / (double)a[4];
            sum += this._w[n] * Math.exp(-0.5 * (xx * xx + yy * yy));
        }
        xx = (ci * xc + si * yc) / (double)a[2];
        yy = (-si * xc + ci * yc) / (double)a[4];
        double ff = (double)a[0] * sum;
        fval[0] = (float)ff;
        dyda[0] = (float)sum;
        dyda[1] = (float)(ff * (ci * xx / (double)a[2] - si * yy / (double)a[4]));
        dyda[2] = (float)(ff * xx * xx / (double)a[2]);
        dyda[3] = (float)(ff * (si * xx / (double)a[2] + ci * yy / (double)a[4]));
        dyda[4] = (float)(ff * yy * yy / (double)a[4]);
        dyda[5] = (float)(ff * ((si * xc - ci * yc) * xx / (double)a[2] + (ci * xc + si * yc) * yy / (double)a[4]));
        return 0;
    }

    private int _g2efit(float[] val, int wght, int nx, int ny, float[] ap, float[] cv, double[] pchi) {
        int ni;
        int n;
        int[] lista = new int[6];
        float[] apo = new float[6];
        double[] a1 = new double[1];
        double[] alpha = new double[36];
        double[] cvm = new double[36];
        if (nx < 1) {
            this._pval = null;
            this._pwght = 0;
            this._mp = 0;
            this._mx = 0;
            return -1;
        }
        this._mx = nx;
        this._mp = 0 < ny ? ny * nx : nx;
        this._pwght = wght;
        this._pval = val;
        double fh = 0.5 * Math.sqrt(0.6);
        double w1 = 0.19753086419753085;
        double w2 = 0.12345679012345678;
        double w3 = 0.07716049382716049;
        this._xi[0] = 0.0;
        this._yi[0] = 0.0;
        this._w[0] = w1;
        this._xi[1] = 0.0;
        this._yi[1] = fh;
        this._w[1] = w2;
        this._xi[2] = 0.0;
        this._yi[2] = -fh;
        this._w[2] = w2;
        this._xi[3] = fh;
        this._yi[3] = 0.0;
        this._w[3] = w2;
        this._xi[4] = -fh;
        this._yi[4] = 0.0;
        this._w[4] = w2;
        this._xi[5] = fh;
        this._yi[5] = fh;
        this._w[5] = w3;
        this._xi[6] = -fh;
        this._yi[6] = fh;
        this._w[6] = w3;
        this._xi[7] = fh;
        this._yi[7] = -fh;
        this._w[7] = w3;
        this._xi[8] = -fh;
        this._yi[8] = -fh;
        this._w[8] = w3;
        double pi = 4.0 * Math.atan(1.0);
        a1[0] = -1.0;
        int mt = nx * ny;
        for (n = 0; n < 6; ++n) {
            lista[n] = n;
            cv[n] = 0.0f;
        }
        double c2 = 0.0;
        pchi[0] = 0.0;
        double a2 = 0.0;
        int na = 0;
        for (ni = 0; ni < 64; ++ni) {
            for (n = 0; n < 6; ++n) {
                apo[n] = ap[n];
            }
            if (MrqFit.mrqmin(mt, ap, 6, lista, 6, cvm, alpha, pchi, this, a1) != 0) {
                return -2;
            }
            if (a1[0] < a2 && Math.abs(pchi[0] - c2) < 1.0E-5 * c2) break;
            if (a1[0] < a2) {
                c2 = pchi[0];
                na = 0;
            } else {
                ++na;
            }
            a2 = a1[0];
            if (5 < na) break;
            if ((double)ap[0] <= 0.0) {
                ap[0] = (float)(0.5 * (double)apo[0]);
            }
            if ((double)ap[2] <= 0.0) {
                ap[2] = (float)(0.5 * (double)apo[2]);
            }
            if ((double)ap[4] <= 0.0) {
                ap[4] = (float)(0.5 * (double)apo[4]);
            }
            ap[5] = (float)((double)ap[5] % pi);
            if (!((double)ap[1] < 0.0 || (float)nx < ap[1] || (double)ap[3] < 0.0) && !((float)ny < ap[3])) continue;
            return -3;
        }
        a1[0] = 0.0;
        if (MrqFit.mrqmin(mt, ap, 6, lista, 6, cvm, alpha, pchi, this, a1) != 0) {
            return -2;
        }
        ap[5] = (float)((double)ap[5] + pi % pi);
        for (n = 0; n < 6; ++n) {
            cv[n] = (float)Math.sqrt(cvm[n + n * 6]);
        }
        return 64 <= ni ? -4 : ni;
    }

    private void _hsort(int n, float[] ra) {
        int l = n >> 1;
        int ir = n - 1;
        while (true) {
            float rra;
            if (l > 0) {
                rra = ra[--l];
            } else {
                rra = ra[ir];
                ra[ir] = ra[0];
                if (--ir == 0) {
                    ra[0] = rra;
                    return;
                }
            }
            int i = l;
            int j = (l << 1) + 1;
            while (j <= ir) {
                if (j < ir && ra[j] < ra[j + 1]) {
                    ++j;
                }
                if (rra < ra[j]) {
                    ra[i] = ra[j];
                    i = j;
                    j += i + 1;
                    continue;
                }
                j = ir + 1;
            }
            ra[i] = rra;
        }
    }

    private void _indexx(int n, float[] arrin, int[] indx) {
        int j;
        for (j = 0; j < n; ++j) {
            indx[j] = j;
        }
        int l = n >> 1;
        int ir = n - 1;
        while (true) {
            float q;
            int indxt;
            if (l > 0) {
                indxt = indx[--l];
                q = arrin[indxt];
            } else {
                indxt = indx[ir];
                q = arrin[indxt];
                indx[ir] = indx[0];
                if (--ir == 0) {
                    indx[0] = indxt;
                    return;
                }
            }
            int i = l;
            for (j = (l << 1) + 1; j <= ir; j += i + 1) {
                if (j < ir && arrin[indx[j]] < arrin[indx[j + 1]]) {
                    ++j;
                }
                if (!(q < arrin[indx[j]])) break;
                indx[i] = indx[j];
                i = j;
            }
            indx[i] = indxt;
        }
    }
}

