/*
 * Decompiled with CFR 0.152.
 */
package jsky.science;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import jsky.science.AbstractScienceObject;
import jsky.science.ScienceObjectModel;
import jsky.science.ScienceObjectNodeModel;
import jsky.util.ReplacementEvent;
import jsky.util.ReplacementVetoException;

public abstract class AbstractScienceObjectNode
extends AbstractScienceObject
implements ScienceObjectNodeModel {
    private boolean fMoreDataAvailable;
    private ScienceObjectNodeModel fDataSource;
    private List<ScienceObjectModel> fChildren;
    private static final long serialVersionUID = 1L;
    private boolean fHolding = false;
    private boolean fUpdateNeeded = false;
    private boolean fPending = false;
    protected static String cloneIndent = "";

    public AbstractScienceObjectNode() {
        this(null, false);
    }

    public AbstractScienceObjectNode(String inName, boolean holding) {
        super(inName);
        this.fHolding = holding;
        this.fUpdateNeeded = holding;
        this.fChildren = new ArrayList<ScienceObjectModel>(5);
        this.fMoreDataAvailable = false;
        this.fDataSource = null;
        this.initializeTransients();
    }

    public AbstractScienceObjectNode(boolean holding) {
        this(null, holding);
    }

    public AbstractScienceObjectNode(String inName) {
        this(inName, false);
    }

    @Override
    public Object clone() {
        AbstractScienceObjectNode newSO = (AbstractScienceObjectNode)super.clone();
        newSO.clearAllListeners();
        if (this.isTracing()) {
            this.writeDebug(cloneIndent + AbstractScienceObjectNode.getObjectIdString(this) + ".clone", " to " + AbstractScienceObjectNode.getObjectIdString(newSO));
            cloneIndent = cloneIndent + "  ";
        }
        newSO.fChildren = new ArrayList<ScienceObjectModel>(5);
        for (ScienceObjectModel thisChild : this.fChildren) {
            ScienceObjectModel thatChild = (ScienceObjectModel)thisChild.clone();
            newSO.addChild(thatChild);
        }
        if (this.isTracing()) {
            cloneIndent = cloneIndent.substring(2);
        }
        return newSO;
    }

    public int indexOfChild(Object child) {
        for (int childIndex = 0; childIndex < this.fChildren.size(); ++childIndex) {
            ScienceObjectModel next = this.fChildren.get(childIndex);
            if (next != child) continue;
            return childIndex;
        }
        return -1;
    }

    public ScienceObjectModel namedClone() {
        AbstractScienceObjectNode copy = (AbstractScienceObjectNode)this.clone();
        copy.setName(this.createDefaultName());
        return copy;
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof AbstractScienceObjectNode)) {
            return false;
        }
        AbstractScienceObjectNode that = (AbstractScienceObjectNode)obj;
        if (this.fDataSource == null ? that.fDataSource != null : !this.fDataSource.equals(that.fDataSource)) {
            return false;
        }
        return !(this.fChildren == null ? that.fChildren != null : !this.fChildren.equals(that.fChildren));
    }

    @Override
    public void replaceObject(ReplacementEvent ev) throws ReplacementVetoException {
        ScienceObjectModel newObject;
        ScienceObjectModel oldObject = (ScienceObjectModel)ev.getOldValue();
        if (oldObject == (newObject = (ScienceObjectModel)ev.getNewValue())) {
            return;
        }
        if (oldObject == this) {
            this.setHolding(true);
            try {
                Iterator oldKids = this.getChildren().iterator();
                Iterator newKids = ((ScienceObjectNodeModel)newObject).getChildren().iterator();
                while (oldKids.hasNext() && newKids.hasNext()) {
                    ScienceObjectModel oldC = (ScienceObjectModel)oldKids.next();
                    oldC.removePropertyChangeListener(this);
                    oldC.replaceObject(new ReplacementEvent(oldC, (ScienceObjectModel)newKids.next()));
                }
            }
            catch (ClassCastException oldKids) {
                // empty catch block
            }
            try {
                this.fireReplaceObject(this, newObject);
            }
            catch (ReplacementVetoException e) {
                this.writeError(this, "Unexpected exception: " + e.toString());
            }
        } else {
            for (int index = 0; index < this.fChildren.size(); ++index) {
                if (this.fChildren.get(index) != oldObject || newObject == oldObject) continue;
                this.fChildren.set(index, newObject);
                oldObject.removePropertyChangeListener(this);
                newObject.addPropertyChangeListener(this);
                newObject.setParent(this);
            }
        }
    }

    public void saveAsText(PrintWriter pw, int indent) {
        String id = AbstractScienceObjectNode.repeat(" ", indent);
        pw.println(id + this.toString());
    }

    public static String repeat(String inS, int n) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < n; ++i) {
            sb.append(inS);
        }
        return sb.toString();
    }

    public void saveAsText(PrintWriter pw) {
        this.saveAsText(pw, 0);
    }

    @Override
    public boolean isMoreDataAvailable() {
        return this.fMoreDataAvailable;
    }

    @Override
    public void setMoreDataAvailable(boolean more) {
        boolean old = this.fMoreDataAvailable;
        this.fMoreDataAvailable = more;
        this.firePropertyChange(MORE_DATA_PROPERTY, new Boolean(true), new Boolean(false));
    }

    @Override
    public void retrieveMoreData(ScienceObjectNodeModel forObject) {
        forObject.setMoreDataAvailable(false);
    }

    @Override
    public void requestMoreData() {
        if (!this.fMoreDataAvailable) {
            return;
        }
        if (this.fDataSource != null) {
            this.fDataSource.retrieveMoreData(this);
        }
    }

    @Override
    public ScienceObjectNodeModel getDataSource() {
        return this.fDataSource;
    }

    @Override
    public void setDataSource(ScienceObjectNodeModel s) {
        ScienceObjectNodeModel old = this.fDataSource;
        this.fDataSource = s;
        this.firePropertyChange(DATA_SOURCE_PROPERTY, old, this.fDataSource);
    }

    @Override
    public boolean isHolding() {
        return this.fHolding;
    }

    @Override
    public void setHolding(boolean inH) {
        this.fHolding = inH;
        if (!inH && this.fUpdateNeeded) {
            this.update();
        }
    }

    public void setUpdatesPending(boolean inH) {
        this.fUpdateNeeded = inH;
    }

    protected synchronized void update() {
        if (this.fHolding) {
            this.fUpdateNeeded = true;
        } else {
            this.setPending(true);
            this.processUpdates();
            this.fUpdateNeeded = false;
        }
    }

    protected void processUpdates() {
        this.setPending(false);
    }

    public boolean isUpToDate() {
        if (!this.isHolding()) {
            return true;
        }
        return this.fUpdateNeeded;
    }

    @Override
    public boolean isValid() {
        return true;
    }

    @Override
    public boolean isPending() {
        return this.fPending;
    }

    protected void setPending(boolean b) {
        if (this.fPending == b) {
            return;
        }
        Boolean hold = new Boolean(this.fPending);
        this.fPending = b;
        this.firePropertyChange(ScienceObjectModel.PENDING_PROPERTY, hold, new Boolean(this.fPending));
    }

    @Override
    public void setTracing(boolean onOff) {
        super.setTracing(onOff);
        this.writeDebug(AbstractScienceObjectNode.getObjectIdString(this), "tracing has been turned " + (onOff ? "ON" : "OFF"));
    }

    protected void initializeTransients() {
        this.setParent(null);
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        this.initializeTransients();
        for (ScienceObjectModel obj : this.fChildren) {
            obj.addPropertyChangeListener(this);
            obj.setParent(this);
        }
    }

    @Override
    public void addChild(ScienceObjectModel newKid) {
        newKid.addPropertyChangeListener(this);
        newKid.setParent(this);
        for (int i = 0; i < this.fChildren.size(); ++i) {
            if (this.fChildren.get(i) != newKid) continue;
            return;
        }
        this.fChildren.add(newKid);
    }

    @Override
    public ScienceObjectModel removeChild(ScienceObjectModel oldKid) {
        if (oldKid != null) {
            for (int index = 0; index < this.fChildren.size(); ++index) {
                if (this.fChildren.get(index) != oldKid) continue;
                this.fChildren.remove(index++);
                oldKid.removePropertyChangeListener(this);
                oldKid.setParent(null);
                return oldKid;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeAllChildren() {
        List<ScienceObjectModel> list = this.fChildren;
        synchronized (list) {
            Object[] copy = this.fChildren.toArray();
            for (int i = 0; i < copy.length; ++i) {
                this.removeChild((ScienceObjectModel)copy[i]);
            }
        }
    }

    @Override
    public ScienceObjectModel replaceChild(ScienceObjectModel oldKid, ScienceObjectModel newKid) {
        if (oldKid != null) {
            for (int index = 0; index < this.fChildren.size(); ++index) {
                if (this.fChildren.get(index) != oldKid) continue;
                this.fChildren.set(index, newKid);
                oldKid.removePropertyChangeListener(this);
                oldKid.setParent(null);
                if (newKid != null) {
                    newKid.addPropertyChangeListener(this);
                    newKid.setParent(this);
                }
                return oldKid;
            }
        }
        if (newKid != null) {
            this.addChild(newKid);
        }
        return null;
    }

    @Override
    public List getChildren() {
        return this.fChildren;
    }
}

