/*
 * Decompiled with CFR 0.152.
 */
package jsky.util;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;

public class TransferableList
extends ArrayList
implements Transferable {
    public TransferableList() {
    }

    public TransferableList(int initialCapacity) {
        super(initialCapacity);
    }

    @Override
    public DataFlavor[] getTransferDataFlavors() {
        HashSet<DataFlavor> flavors = new HashSet<DataFlavor>();
        for (int i = 0; i < this.size(); ++i) {
            Transferable obj = (Transferable)this.get(i);
            DataFlavor[] objFlavs = obj.getTransferDataFlavors();
            flavors.addAll(Arrays.asList(objFlavs));
        }
        DataFlavor[] flavArray = new DataFlavor[flavors.size()];
        int i = 0;
        for (Object e : flavors) {
            flavArray[i++] = (DataFlavor)e;
        }
        return flavArray;
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor flavor) {
        DataFlavor[] flavors;
        boolean supported = false;
        for (DataFlavor f : flavors = this.getTransferDataFlavors()) {
            if (!flavor.equals(f)) continue;
            supported = true;
            break;
        }
        return supported;
    }

    @Override
    public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
        ArrayList<Object> data = new ArrayList<Object>();
        for (int i = 0; i < this.size(); ++i) {
            Transferable obj = (Transferable)this.get(i);
            if (!obj.isDataFlavorSupported(flavor)) continue;
            data.add(obj.getTransferData(flavor));
        }
        if (data.size() == 0) {
            throw new UnsupportedFlavorException(flavor);
        }
        return data.toArray();
    }
}

