/*
 * Decompiled with CFR 0.152.
 */
package alma.acs.entityutil;

import alma.acs.entityutil.DefaultXmlEntityStructFactory;
import alma.acs.entityutil.EntityException;
import alma.acs.entityutil.EntityTFinder;
import alma.acs.entityutil.XmlEntityStructFactory;
import alma.entities.commonentity.EntityT;
import alma.xmlentity.XmlEntityStruct;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.logging.Logger;
import org.exolab.castor.xml.Marshaller;

public class EntitySerializer {
    private static EntitySerializer s_entitySerializer;
    private Logger m_logger;
    private boolean m_verbose;
    private XmlEntityStructFactory m_esf;
    private EntityTFinder m_finder;

    public static EntitySerializer getEntitySerializer(Logger logger) {
        if (s_entitySerializer == null) {
            s_entitySerializer = new EntitySerializer(logger);
        }
        return s_entitySerializer;
    }

    private EntitySerializer(Logger logger) {
        this.m_logger = logger;
        this.m_esf = new DefaultXmlEntityStructFactory();
        this.m_finder = new EntityTFinder(this.m_logger);
        this.setVerbose(false);
    }

    public void setXmlEntityFactory(XmlEntityStructFactory esf) {
        this.m_esf = esf;
    }

    public XmlEntityStruct serializeEntity(Object entityObject, EntityT entityMeta) throws EntityException {
        if (entityObject == null) {
            return null;
        }
        if (entityMeta == null) {
            throw new EntityException("Entity administrational data of type EntityT must not be null. (object of type " + entityObject.getClass().getName() + ")");
        }
        XmlEntityStruct entStruct = this.m_esf.createXmlEntityStruct();
        try {
            entStruct.entityId = entityMeta.getEntityId();
            entStruct.entityTypeName = entityMeta.getEntityTypeName();
            entStruct.schemaVersion = entityMeta.getSchemaVersion() != null ? entityMeta.getSchemaVersion() : "";
            entStruct.timeStamp = entityMeta.getTimestamp() != null ? entityMeta.getTimestamp() : "";
            entStruct.xmlString = this.serializeEntityPart(entityObject);
        }
        catch (Exception e) {
            throw new EntityException(e);
        }
        return entStruct;
    }

    public XmlEntityStruct serializeEntity(Object entityObject) throws EntityException {
        if (entityObject == null) {
            return null;
        }
        EntityT entityMeta = this.m_finder.extractEntityT(entityObject);
        return this.serializeEntity(entityObject, entityMeta);
    }

    public String serializeEntityPart(Object entityPart) throws EntityException {
        try {
            StringWriter wr = new StringWriter();
            Marshaller marsh = this.createMarshaller(wr);
            marsh.setValidation(false);
            marsh.marshal(entityPart);
            return wr.toString();
        }
        catch (Exception e) {
            throw new EntityException("failed to serialize entity part of type '" + entityPart.getClass().getName() + "'.", e);
        }
    }

    protected Marshaller createMarshaller(StringWriter wr) throws IOException {
        return new Marshaller((Writer)wr);
    }

    public void setVerbose(boolean verbose) {
        this.m_verbose = verbose;
        this.m_finder.setVerbose(this.m_verbose);
    }
}

