/*
 * Decompiled with CFR 0.152.
 */
package alma.acs.container.corba;

import alma.acs.container.corba.JacOrbConfigurator;
import alma.acs.util.ACSPorts;
import alma.acs.util.CmdLineArgs;
import alma.acs.util.CmdLineRegisteredOption;
import java.util.ArrayList;
import java.util.Properties;

public abstract class OrbConfigurator {
    protected static boolean debug = false;
    private CmdLineArgs m_cmdArgs;
    private CmdLineRegisteredOption[] m_opts = this._declareOptions();
    public static final String ORB_CLASS_KEY = "org.omg.CORBA.ORBClass";
    public static final String ORB_SINGLETON_CLASS_KEY = "org.omg.CORBA.ORBSingletonClass";
    public static final int ORB_DEFAULT_PORT = ACSPorts.getBasePort() * 100 + 3000 + 51;
    private int m_port;

    protected OrbConfigurator() {
        if (this.m_opts == null) {
            this.m_opts = new CmdLineRegisteredOption[0];
        }
        this.m_cmdArgs = new CmdLineArgs();
        for (int i = 0; i < this.m_opts.length; ++i) {
            this.m_cmdArgs.registerOption(this.m_opts[i]);
        }
    }

    public static OrbConfigurator getOrbConfigurator() {
        return new JacOrbConfigurator();
    }

    public static void setDebug(boolean debug) {
        OrbConfigurator.debug = debug;
    }

    protected abstract CmdLineRegisteredOption[] _declareOptions();

    public void setOptions(String[] args) {
        this.m_cmdArgs.parseArgs(args);
    }

    public void setORBInitRef(String objectID, String objectURL) {
        if (objectID != null && objectURL != null) {
            this.m_cmdArgs.parseArgs(new String[]{"-ORBInitRef", objectID + "=" + objectURL});
        }
    }

    public void setPort(int port) {
        this.m_port = port;
    }

    public String[] getOptions() {
        return this.m_cmdArgs.getAllArgs();
    }

    public Properties getProperties() {
        return this.getProperties(false);
    }

    public Properties getProperties(boolean suppressPortProperty) {
        Properties props = this._getProperties();
        if (props == null) {
            props = new Properties();
        }
        if (this.getORBClass() != null) {
            props.setProperty(ORB_CLASS_KEY, this.getORBClass());
        }
        if (this.getORBSingleton() != null) {
            props.setProperty(ORB_SINGLETON_CLASS_KEY, this.getORBSingleton());
        }
        if (this.getPortPropertyName() != null && !suppressPortProperty) {
            props.setProperty(this.getPortPropertyName(), Integer.toString(this.m_port));
        }
        return props;
    }

    protected abstract Properties _getProperties();

    public abstract String getORBClass();

    public abstract String getORBSingleton();

    public abstract String getPortPropertyName();

    protected void setDefaultOptions() {
        ArrayList<CmdLineRegisteredOption> options = new ArrayList<CmdLineRegisteredOption>();
        CmdLineRegisteredOption orbDottedDecAdr = new CmdLineRegisteredOption("-ORBDottedDecimalAddresses", 1);
        options.add(orbDottedDecAdr);
        options.add(new CmdLineRegisteredOption("-ORBEndpoint", 1));
        options.add(new CmdLineRegisteredOption("-ORBInitRef", 1));
    }
}

