/*
 * Decompiled with CFR 0.152.
 */
package alma.acs.container.corba;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import org.omg.CORBA.Object;
import org.omg.CORBA.portable.IDLEntity;

public class CorbaNullFinder {
    private final java.lang.Object corbaData;
    private List<String> errors;

    public CorbaNullFinder(java.lang.Object corbaData) {
        this.corbaData = corbaData;
    }

    private synchronized void checkForNulls() {
        if (this.errors == null) {
            this.errors = new ArrayList<String>();
            if (this.corbaData != null) {
                String path = this.corbaData.getClass().getSimpleName();
                this.recursiveCheckForNulls(this.corbaData, path);
            } else {
                this.errors.add("Top-level object is null; cannot distinguish between a legal null object reference and an illegal null data item.");
            }
        }
    }

    private void recursiveCheckForNulls(java.lang.Object _corbaData, String path) {
        if (_corbaData == null) {
            this.errors.add("Null object in field " + path);
            return;
        }
        if (_corbaData.getClass().getPackage() != null && _corbaData.getClass().getPackage().getName().startsWith("java")) {
            return;
        }
        if (_corbaData.getClass().isArray()) {
            for (int i = 0; i < Array.getLength(_corbaData); ++i) {
                String recPath = path.endsWith("[]") ? path.substring(0, path.length() - 1) + i + "]" : path;
                this.recursiveCheckForNulls(Array.get(_corbaData, i), recPath);
            }
        } else {
            Field[] fields;
            for (Field field : fields = _corbaData.getClass().getFields()) {
                Class<?> clzz = field.getType();
                String qualifiedFieldName = path + "/" + field.getName();
                try {
                    java.lang.Object value = field.get(_corbaData);
                    if (clzz.isPrimitive()) continue;
                    if (clzz == String.class) {
                        if (value != null) continue;
                        this.errors.add("Null string in field " + qualifiedFieldName);
                        continue;
                    }
                    if (CorbaNullFinder.isIDLEnumClass(clzz)) {
                        if (value != null) continue;
                        this.errors.add("Null enum in field " + qualifiedFieldName);
                        continue;
                    }
                    if (CorbaNullFinder.isIDLStructClass(clzz)) {
                        if (value == null) {
                            this.errors.add("Null struct in field " + qualifiedFieldName);
                            continue;
                        }
                        this.recursiveCheckForNulls(value, qualifiedFieldName);
                        continue;
                    }
                    if (clzz.isArray()) {
                        if (value == null) {
                            this.errors.add("Null array in field " + qualifiedFieldName);
                            continue;
                        }
                        this.recursiveCheckForNulls(value, qualifiedFieldName + "[]");
                        continue;
                    }
                    if (CorbaNullFinder.isIDLInterfaceClass(clzz)) continue;
                    System.out.println("DEBUG: Check if we need to update " + CorbaNullFinder.class.getName() + " to support " + clzz.getName() + " used in " + qualifiedFieldName);
                }
                catch (Exception ex) {
                    this.errors.add("Failed to read field of type " + clzz.getName());
                }
            }
        }
    }

    static boolean isIDLEnumClass(Class<?> clzz) {
        if (IDLEntity.class.isAssignableFrom(clzz) && !Object.class.isAssignableFrom(clzz)) {
            try {
                clzz.getMethod("from_int", Integer.TYPE);
                return true;
            }
            catch (Exception ex) {
                return false;
            }
        }
        return false;
    }

    static boolean isIDLStructClass(Class<?> clzz) {
        if (IDLEntity.class.isAssignableFrom(clzz) && !Object.class.isAssignableFrom(clzz)) {
            try {
                clzz.getMethod("from_int", Integer.TYPE);
                return false;
            }
            catch (Exception ex) {
                return true;
            }
        }
        return false;
    }

    public static boolean isIDLInterfaceClass(Class<?> clzz) {
        return IDLEntity.class.isAssignableFrom(clzz) && Object.class.isAssignableFrom(clzz);
    }

    public boolean hasErrors() {
        this.checkForNulls();
        return this.errors.size() > 0;
    }

    public List<String> getErrors() {
        this.checkForNulls();
        return new ArrayList<String>(this.errors);
    }
}

